/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxTunIdBuilder
implements Builder<NxmNxTunId> {
    private BigInteger _value;
    Map<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKVALUERANGE_RANGES;

    public NxmNxTunIdBuilder() {
    }

    public NxmNxTunIdBuilder(NxmNxTunId base) {
        AugmentationHolder casted;
        this._value = base.getValue();
        if (base instanceof NxmNxTunIdImpl) {
            NxmNxTunIdImpl impl = (NxmNxTunIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>(casted.augmentations());
        }
    }

    public BigInteger getValue() {
        return this._value;
    }

    public <E extends Augmentation<NxmNxTunId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKVALUERANGE_RANGES)));
    }

    public NxmNxTunIdBuilder setValue(BigInteger value) {
        if (value != null) {
            NxmNxTunIdBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _value_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public NxmNxTunIdBuilder addAugmentation(Class<? extends Augmentation<NxmNxTunId>> augmentationType, Augmentation<NxmNxTunId> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxmNxTunIdBuilder removeAugmentation(Class<? extends Augmentation<NxmNxTunId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxTunId build() {
        return new NxmNxTunIdImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVALUERANGE_RANGES = a;
    }

    private static final class NxmNxTunIdImpl
    implements NxmNxTunId {
        private final BigInteger _value;
        private Map<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxmNxTunId> getImplementedInterface() {
            return NxmNxTunId.class;
        }

        private NxmNxTunIdImpl(NxmNxTunIdBuilder base) {
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getValue() {
            return this._value;
        }

        public <E extends Augmentation<NxmNxTunId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxTunId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxTunId other = (NxmNxTunId)obj;
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxTunIdImpl otherImpl = (NxmNxTunIdImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxmNxTunId [");
            boolean first = true;
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

