/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrcBuilder {
    private Integer _ofsNbits;
    private static List<Range<BigInteger>> _ofsNbits_range;
    private SrcChoice _srcChoice;
    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();

    public SrcBuilder() {
    }

    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }

    public SrcBuilder(Src base) {
        this._ofsNbits = base.getOfsNbits();
        this._srcChoice = base.getSrcChoice();
        if (base instanceof SrcImpl) {
            SrcImpl _impl = (SrcImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping] \nbut was: " + arg);
        }
    }

    public Integer getOfsNbits() {
        return this._ofsNbits;
    }

    public SrcChoice getSrcChoice() {
        return this._srcChoice;
    }

    public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SrcBuilder setOfsNbits(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : SrcBuilder._ofsNbits_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _ofsNbits_range));
            }
        }
        this._ofsNbits = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _ofsNbits_range() {
        if (_ofsNbits_range != null) return _ofsNbits_range;
        Class<SrcBuilder> clazz = SrcBuilder.class;
        synchronized (SrcBuilder.class) {
            if (_ofsNbits_range != null) return _ofsNbits_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _ofsNbits_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _ofsNbits_range;
        }
    }

    public SrcBuilder setSrcChoice(SrcChoice value) {
        this._srcChoice = value;
        return this;
    }

    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
    implements Src {
        private final Integer _ofsNbits;
        private final SrcChoice _srcChoice;
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();

        public Class<Src> getImplementedInterface() {
            return Src.class;
        }

        private SrcImpl(SrcBuilder base) {
            this._ofsNbits = base.getOfsNbits();
            this._srcChoice = base.getSrcChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getOfsNbits() {
            return this._ofsNbits;
        }

        @Override
        public SrcChoice getSrcChoice() {
            return this._srcChoice;
        }

        public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ofsNbits == null ? 0 : this._ofsNbits.hashCode());
            result = 31 * result + (this._srcChoice == null ? 0 : this._srcChoice.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (this._ofsNbits == null ? other.getOfsNbits() != null : !this._ofsNbits.equals(other.getOfsNbits())) {
                return false;
            }
            if (this._srcChoice == null ? other.getSrcChoice() != null : !this._srcChoice.equals(other.getSrcChoice())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrcImpl otherImpl = (SrcImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Src [");
            boolean first = true;
            if (this._ofsNbits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ofsNbits=");
                builder.append(this._ofsNbits);
            }
            if (this._srcChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcChoice=");
                builder.append(this._srcChoice);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

