/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxOutputRegBuilder {
    private Integer _maxLen;
    private static List<Range<BigInteger>> _maxLen_range;
    private Src _src;
    Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>();

    public NxOutputRegBuilder() {
    }

    public NxOutputRegBuilder(NxOutputReg base) {
        this._maxLen = base.getMaxLen();
        this._src = base.getSrc();
        if (base instanceof NxOutputRegImpl) {
            NxOutputRegImpl _impl = (NxOutputRegImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(_impl.augmentation);
        }
    }

    public Integer getMaxLen() {
        return this._maxLen;
    }

    public Src getSrc() {
        return this._src;
    }

    public <E extends Augmentation<NxOutputReg>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxOutputRegBuilder setMaxLen(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : NxOutputRegBuilder._maxLen_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxLen_range));
            }
        }
        this._maxLen = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxLen_range() {
        if (_maxLen_range != null) return _maxLen_range;
        Class<NxOutputRegBuilder> clazz = NxOutputRegBuilder.class;
        synchronized (NxOutputRegBuilder.class) {
            if (_maxLen_range != null) return _maxLen_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _maxLen_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxLen_range;
        }
    }

    public NxOutputRegBuilder setSrc(Src value) {
        this._src = value;
        return this;
    }

    public NxOutputRegBuilder addAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType, Augmentation<NxOutputReg> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxOutputReg build() {
        return new NxOutputRegImpl(this);
    }

    private static final class NxOutputRegImpl
    implements NxOutputReg {
        private final Integer _maxLen;
        private final Src _src;
        private Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>();

        public Class<NxOutputReg> getImplementedInterface() {
            return NxOutputReg.class;
        }

        private NxOutputRegImpl(NxOutputRegBuilder base) {
            this._maxLen = base.getMaxLen();
            this._src = base.getSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxLen() {
            return this._maxLen;
        }

        @Override
        public Src getSrc() {
            return this._src;
        }

        public <E extends Augmentation<NxOutputReg>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxLen == null ? 0 : this._maxLen.hashCode());
            result = 31 * result + (this._src == null ? 0 : this._src.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxOutputReg.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxOutputReg other = (NxOutputReg)obj;
            if (this._maxLen == null ? other.getMaxLen() != null : !this._maxLen.equals(other.getMaxLen())) {
                return false;
            }
            if (this._src == null ? other.getSrc() != null : !this._src.equals(other.getSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxOutputRegImpl otherImpl = (NxOutputRegImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxOutputReg [");
            boolean first = true;
            if (this._maxLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLen=");
                builder.append(this._maxLen);
            }
            if (this._src != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_src=");
                builder.append(this._src);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

