/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsi.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsi.grouping.NxActionSetNsi;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionSetNsiBuilder
implements Builder<NxActionSetNsi> {
    private ExperimenterId _experimenterId;
    private Short _nsi;
    Map<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>> augmentation = Collections.emptyMap();

    public NxActionSetNsiBuilder() {
    }

    public NxActionSetNsiBuilder(NxActionSetNsi base) {
        AugmentationHolder casted;
        this._experimenterId = base.getExperimenterId();
        this._nsi = base.getNsi();
        if (base instanceof NxActionSetNsiImpl) {
            NxActionSetNsiImpl impl = (NxActionSetNsiImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>>(casted.augmentations());
        }
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Short getNsi() {
        return this._nsi;
    }

    public <E extends Augmentation<NxActionSetNsi>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxActionSetNsiBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkNsiRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxActionSetNsiBuilder setNsi(Short value) {
        if (value != null) {
            NxActionSetNsiBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    public NxActionSetNsiBuilder addAugmentation(Class<? extends Augmentation<NxActionSetNsi>> augmentationType, Augmentation<NxActionSetNsi> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionSetNsiBuilder removeAugmentation(Class<? extends Augmentation<NxActionSetNsi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionSetNsi build() {
        return new NxActionSetNsiImpl(this);
    }

    private static final class NxActionSetNsiImpl
    implements NxActionSetNsi {
        private final ExperimenterId _experimenterId;
        private final Short _nsi;
        private Map<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionSetNsi> getImplementedInterface() {
            return NxActionSetNsi.class;
        }

        private NxActionSetNsiImpl(NxActionSetNsiBuilder base) {
            this._experimenterId = base.getExperimenterId();
            this._nsi = base.getNsi();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        public <E extends Augmentation<NxActionSetNsi>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._nsi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionSetNsi.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionSetNsi other = (NxActionSetNsi)obj;
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._nsi, other.getNsi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionSetNsiImpl otherImpl = (NxActionSetNsiImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionSetNsi>>, Augmentation<NxActionSetNsi>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionSetNsi [");
            boolean first = true;
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._nsi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsi=");
                builder.append(this._nsi);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

