/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.resubmit.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.resubmit.grouping.NxActionResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionResubmitBuilder
implements Builder<NxActionResubmit> {
    private ExperimenterId _experimenterId;
    private Integer _inPort;
    private Short _table;
    Map<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>> augmentation = Collections.emptyMap();

    public NxActionResubmitBuilder() {
    }

    public NxActionResubmitBuilder(NxActionResubmit base) {
        AugmentationHolder casted;
        this._experimenterId = base.getExperimenterId();
        this._inPort = base.getInPort();
        this._table = base.getTable();
        if (base instanceof NxActionResubmitImpl) {
            NxActionResubmitImpl impl = (NxActionResubmitImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>>(casted.augmentations());
        }
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Short getTable() {
        return this._table;
    }

    public <E extends Augmentation<NxActionResubmit>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxActionResubmitBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkInPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionResubmitBuilder setInPort(Integer value) {
        if (value != null) {
            NxActionResubmitBuilder.checkInPortRange(value);
        }
        this._inPort = value;
        return this;
    }

    private static void checkTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxActionResubmitBuilder setTable(Short value) {
        if (value != null) {
            NxActionResubmitBuilder.checkTableRange(value);
        }
        this._table = value;
        return this;
    }

    public NxActionResubmitBuilder addAugmentation(Class<? extends Augmentation<NxActionResubmit>> augmentationType, Augmentation<NxActionResubmit> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionResubmit build() {
        return new NxActionResubmitImpl(this);
    }

    private static final class NxActionResubmitImpl
    implements NxActionResubmit {
        private final ExperimenterId _experimenterId;
        private final Integer _inPort;
        private final Short _table;
        private Map<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionResubmit> getImplementedInterface() {
            return NxActionResubmit.class;
        }

        private NxActionResubmitImpl(NxActionResubmitBuilder base) {
            this._experimenterId = base.getExperimenterId();
            this._inPort = base.getInPort();
            this._table = base.getTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Short getTable() {
            return this._table;
        }

        public <E extends Augmentation<NxActionResubmit>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._table);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionResubmit.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionResubmit other = (NxActionResubmit)obj;
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._table, other.getTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionResubmitImpl otherImpl = (NxActionResubmitImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionResubmit>>, Augmentation<NxActionResubmit>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionResubmit [");
            boolean first = true;
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._inPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPort=");
                builder.append(this._inPort);
            }
            if (this._table != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_table=");
                builder.append(this._table);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

