/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.multipath.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.multipath.grouping.NxActionMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionMultipathBuilder
implements Builder<NxActionMultipath> {
    private OfjNxMpAlgorithm _algorithm;
    private Long _arg;
    private Integer _basis;
    private Long _dst;
    private ExperimenterId _experimenterId;
    private OfjNxHashFields _fields;
    private Integer _maxLink;
    private Integer _ofsNbits;
    Map<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>> augmentation = Collections.emptyMap();

    public NxActionMultipathBuilder() {
    }

    public NxActionMultipathBuilder(NxActionMultipath base) {
        AugmentationHolder casted;
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._experimenterId = base.getExperimenterId();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
        this._ofsNbits = base.getOfsNbits();
        if (base instanceof NxActionMultipathImpl) {
            NxActionMultipathImpl impl = (NxActionMultipathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>>(casted.augmentations());
        }
    }

    public OfjNxMpAlgorithm getAlgorithm() {
        return this._algorithm;
    }

    public Long getArg() {
        return this._arg;
    }

    public Integer getBasis() {
        return this._basis;
    }

    public Long getDst() {
        return this._dst;
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public OfjNxHashFields getFields() {
        return this._fields;
    }

    public Integer getMaxLink() {
        return this._maxLink;
    }

    public Integer getOfsNbits() {
        return this._ofsNbits;
    }

    public <E extends Augmentation<NxActionMultipath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxActionMultipathBuilder setAlgorithm(OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }

    private static void checkArgRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionMultipathBuilder setArg(Long value) {
        if (value != null) {
            NxActionMultipathBuilder.checkArgRange(value);
        }
        this._arg = value;
        return this;
    }

    private static void checkBasisRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionMultipathBuilder setBasis(Integer value) {
        if (value != null) {
            NxActionMultipathBuilder.checkBasisRange(value);
        }
        this._basis = value;
        return this;
    }

    private static void checkDstRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionMultipathBuilder setDst(Long value) {
        if (value != null) {
            NxActionMultipathBuilder.checkDstRange(value);
        }
        this._dst = value;
        return this;
    }

    public NxActionMultipathBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    public NxActionMultipathBuilder setFields(OfjNxHashFields value) {
        this._fields = value;
        return this;
    }

    private static void checkMaxLinkRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionMultipathBuilder setMaxLink(Integer value) {
        if (value != null) {
            NxActionMultipathBuilder.checkMaxLinkRange(value);
        }
        this._maxLink = value;
        return this;
    }

    private static void checkOfsNbitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionMultipathBuilder setOfsNbits(Integer value) {
        if (value != null) {
            NxActionMultipathBuilder.checkOfsNbitsRange(value);
        }
        this._ofsNbits = value;
        return this;
    }

    public NxActionMultipathBuilder addAugmentation(Class<? extends Augmentation<NxActionMultipath>> augmentationType, Augmentation<NxActionMultipath> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionMultipathBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionMultipath build() {
        return new NxActionMultipathImpl(this);
    }

    private static final class NxActionMultipathImpl
    implements NxActionMultipath {
        private final OfjNxMpAlgorithm _algorithm;
        private final Long _arg;
        private final Integer _basis;
        private final Long _dst;
        private final ExperimenterId _experimenterId;
        private final OfjNxHashFields _fields;
        private final Integer _maxLink;
        private final Integer _ofsNbits;
        private Map<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionMultipath> getImplementedInterface() {
            return NxActionMultipath.class;
        }

        private NxActionMultipathImpl(NxActionMultipathBuilder base) {
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._experimenterId = base.getExperimenterId();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
            this._ofsNbits = base.getOfsNbits();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>>(base.augmentation);
                }
            }
        }

        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Long getArg() {
            return this._arg;
        }

        @Override
        public Integer getBasis() {
            return this._basis;
        }

        @Override
        public Long getDst() {
            return this._dst;
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public OfjNxHashFields getFields() {
            return this._fields;
        }

        @Override
        public Integer getMaxLink() {
            return this._maxLink;
        }

        @Override
        public Integer getOfsNbits() {
            return this._ofsNbits;
        }

        public <E extends Augmentation<NxActionMultipath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._algorithm);
            result = 31 * result + Objects.hashCode(this._arg);
            result = 31 * result + Objects.hashCode(this._basis);
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode((Object)this._fields);
            result = 31 * result + Objects.hashCode(this._maxLink);
            result = 31 * result + Objects.hashCode(this._ofsNbits);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionMultipath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionMultipath other = (NxActionMultipath)obj;
            if (!Objects.equals((Object)this._algorithm, (Object)other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._arg, other.getArg())) {
                return false;
            }
            if (!Objects.equals(this._basis, other.getBasis())) {
                return false;
            }
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals((Object)this._fields, (Object)other.getFields())) {
                return false;
            }
            if (!Objects.equals(this._maxLink, other.getMaxLink())) {
                return false;
            }
            if (!Objects.equals(this._ofsNbits, other.getOfsNbits())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionMultipathImpl otherImpl = (NxActionMultipathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionMultipath>>, Augmentation<NxActionMultipath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionMultipath [");
            boolean first = true;
            if (this._algorithm != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_algorithm=");
                builder.append((Object)this._algorithm);
            }
            if (this._arg != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_arg=");
                builder.append(this._arg);
            }
            if (this._basis != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_basis=");
                builder.append(this._basis);
            }
            if (this._dst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dst=");
                builder.append(this._dst);
            }
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._fields != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fields=");
                builder.append((Object)this._fields);
            }
            if (this._maxLink != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLink=");
                builder.append(this._maxLink);
            }
            if (this._ofsNbits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ofsNbits=");
                builder.append(this._ofsNbits);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

