/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmOfIpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.ip.dst.grouping.IpDstValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.IpDstCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.IpDstCaseValueBuilder;

public class IpDstCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 4;
    private static final int NXM_FIELD_CODE = 8;
    public static final MatchEntrySerializerKey<Nxm0Class, NxmOfIpDst> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm0Class.class, NxmOfIpDst.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 0, 8);

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntriesBuilder = this.deserializeHeader(message);
        IpDstCaseValueBuilder caseBuilder = new IpDstCaseValueBuilder();
        caseBuilder.setIpDstValues(new IpDstValuesBuilder().setValue(message.readUnsignedInt()).build());
        matchEntriesBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return matchEntriesBuilder.build();
    }

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        IpDstCaseValue ipDstCase = (IpDstCaseValue)input.getMatchEntryValue();
        outBuffer.writeInt(ipDstCase.getIpDstValues().getValue().intValue());
    }

    @Override
    public int getNxmFieldCode() {
        return 8;
    }

    @Override
    public int getOxmClassCode() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 4;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmOfIpDst.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm0Class.class;
    }
}

