/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmOfArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.arp.spa.grouping.ArpSpaValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.ArpSpaCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.ArpSpaCaseValueBuilder;

public class ArpSpaCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 4;
    private static final int NXM_FIELD_CODE = 16;
    public static final MatchEntrySerializerKey<Nxm0Class, NxmOfArpSpa> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm0Class.class, NxmOfArpSpa.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 0, 16);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        ArpSpaCaseValue arpSpaCase = (ArpSpaCaseValue)input.getMatchEntryValue();
        outBuffer.writeInt(arpSpaCase.getArpSpaValues().getValue().intValue());
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntryBuilder = this.deserializeHeader(message);
        ArpSpaCaseValueBuilder caseBuilder = new ArpSpaCaseValueBuilder();
        caseBuilder.setArpSpaValues(new ArpSpaValuesBuilder().setValue(message.readUnsignedInt()).build());
        matchEntryBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return matchEntryBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 16;
    }

    @Override
    public int getOxmClassCode() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 4;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmOfArpSpa.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm0Class.class;
    }
}

