/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.NxmHeader;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;

public abstract class AbstractMatchCodec
implements OFSerializer<MatchEntry>,
OFDeserializer<MatchEntry> {
    private NxmHeader headerWithMask;
    private NxmHeader headerWithoutMask;

    protected MatchEntryBuilder deserializeHeader(ByteBuf message) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(this.getOxmClass());
        message.skipBytes(2);
        builder.setOxmMatchField(this.getNxmField());
        boolean hasMask = (message.readUnsignedByte() & 1) != 0;
        builder.setHasMask(Boolean.valueOf(hasMask));
        message.skipBytes(1);
        return builder;
    }

    protected void serializeHeader(MatchEntry input, ByteBuf outBuffer) {
        outBuffer.writeInt(this.serializeHeaderToLong(input.isHasMask()).intValue());
    }

    private Long serializeHeaderToLong(boolean hasMask) {
        if (hasMask) {
            return this.getHeaderWithHasMask().toLong();
        }
        return this.getHeaderWithoutHasMask().toLong();
    }

    public NxmHeader getHeaderWithoutHasMask() {
        if (this.headerWithoutMask == null) {
            this.headerWithoutMask = new NxmHeader(this.getOxmClassCode(), this.getNxmFieldCode(), false, this.getValueLength());
        }
        return this.headerWithoutMask;
    }

    public NxmHeader getHeaderWithHasMask() {
        if (this.headerWithMask == null) {
            this.headerWithMask = new NxmHeader(this.getOxmClassCode(), this.getNxmFieldCode(), true, this.getValueLength());
        }
        return this.headerWithMask;
    }

    public abstract int getNxmFieldCode();

    public abstract int getOxmClassCode();

    public abstract int getValueLength();

    public abstract Class<? extends MatchField> getNxmField();

    public abstract Class<? extends OxmClassBase> getOxmClass();
}

