/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateTableOutputBuilder
implements Builder<UpdateTableOutput> {
    private TransactionId _transactionId;
    Map<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTRANSACTIONIDRANGE_RANGES;

    public UpdateTableOutputBuilder() {
    }

    public UpdateTableOutputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public UpdateTableOutputBuilder(UpdateTableOutput base) {
        AugmentationHolder casted;
        this._transactionId = base.getTransactionId();
        if (base instanceof UpdateTableOutputImpl) {
            UpdateTableOutputImpl impl = (UpdateTableOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public <E extends Augmentation<UpdateTableOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkTransactionIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSACTIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSACTIONIDRANGE_RANGES)));
    }

    public UpdateTableOutputBuilder setTransactionId(TransactionId value) {
        if (value != null) {
            UpdateTableOutputBuilder.checkTransactionIdRange(value.getValue());
        }
        this._transactionId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _transactionId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public UpdateTableOutputBuilder addAugmentation(Class<? extends Augmentation<UpdateTableOutput>> augmentationType, Augmentation<UpdateTableOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateTableOutputBuilder removeAugmentation(Class<? extends Augmentation<UpdateTableOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateTableOutput build() {
        return new UpdateTableOutputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSACTIONIDRANGE_RANGES = a;
    }

    private static final class UpdateTableOutputImpl
    implements UpdateTableOutput {
        private final TransactionId _transactionId;
        private Map<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateTableOutput> getImplementedInterface() {
            return UpdateTableOutput.class;
        }

        private UpdateTableOutputImpl(UpdateTableOutputBuilder base) {
            this._transactionId = base.getTransactionId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        public <E extends Augmentation<UpdateTableOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateTableOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateTableOutput other = (UpdateTableOutput)obj;
            if (this._transactionId == null ? other.getTransactionId() != null : !this._transactionId.equals(other.getTransactionId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateTableOutputImpl otherImpl = (UpdateTableOutputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateTableOutput>>, Augmentation<UpdateTableOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdateTableOutput [");
            boolean first = true;
            if (this._transactionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

