/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.table.update.OriginalTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.table.update.UpdatedTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateTableInputBuilder
implements Builder<UpdateTableInput> {
    private NodeRef _node;
    private OriginalTable _originalTable;
    private TableRef _tableRef;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private UpdatedTable _updatedTable;
    Map<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTRANSACTIONIDRANGE_RANGES;

    public UpdateTableInputBuilder() {
    }

    public UpdateTableInputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public UpdateTableInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateTableInputBuilder(TableUpdate arg) {
        this._originalTable = arg.getOriginalTable();
        this._updatedTable = arg.getUpdatedTable();
        this._node = arg.getNode();
    }

    public UpdateTableInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateTableInputBuilder(UpdateTableInput base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._originalTable = base.getOriginalTable();
        this._tableRef = base.getTableRef();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._updatedTable = base.getUpdatedTable();
        if (base instanceof UpdateTableInputImpl) {
            UpdateTableInputImpl impl = (UpdateTableInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof TableUpdate) {
            this._originalTable = ((TableUpdate)arg).getOriginalTable();
            this._updatedTable = ((TableUpdate)arg).getUpdatedTable();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdate] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalTable getOriginalTable() {
        return this._originalTable;
    }

    public TableRef getTableRef() {
        return this._tableRef;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedTable getUpdatedTable() {
        return this._updatedTable;
    }

    public <E extends Augmentation<UpdateTableInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateTableInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public UpdateTableInputBuilder setOriginalTable(OriginalTable value) {
        this._originalTable = value;
        return this;
    }

    public UpdateTableInputBuilder setTableRef(TableRef value) {
        if (value != null) {
            // empty if block
        }
        this._tableRef = value;
        return this;
    }

    private static void checkTransactionIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSACTIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSACTIONIDRANGE_RANGES)));
    }

    public UpdateTableInputBuilder setTransactionId(TransactionId value) {
        if (value != null) {
            UpdateTableInputBuilder.checkTransactionIdRange(value.getValue());
        }
        this._transactionId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _transactionId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public UpdateTableInputBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public UpdateTableInputBuilder setUpdatedTable(UpdatedTable value) {
        this._updatedTable = value;
        return this;
    }

    public UpdateTableInputBuilder addAugmentation(Class<? extends Augmentation<UpdateTableInput>> augmentationType, Augmentation<UpdateTableInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateTableInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateTableInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateTableInput build() {
        return new UpdateTableInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSACTIONIDRANGE_RANGES = a;
    }

    private static final class UpdateTableInputImpl
    implements UpdateTableInput {
        private final NodeRef _node;
        private final OriginalTable _originalTable;
        private final TableRef _tableRef;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final UpdatedTable _updatedTable;
        private Map<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateTableInput> getImplementedInterface() {
            return UpdateTableInput.class;
        }

        private UpdateTableInputImpl(UpdateTableInputBuilder base) {
            this._node = base.getNode();
            this._originalTable = base.getOriginalTable();
            this._tableRef = base.getTableRef();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._updatedTable = base.getUpdatedTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalTable getOriginalTable() {
            return this._originalTable;
        }

        @Override
        public TableRef getTableRef() {
            return this._tableRef;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedTable getUpdatedTable() {
            return this._updatedTable;
        }

        public <E extends Augmentation<UpdateTableInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._originalTable == null ? 0 : this._originalTable.hashCode());
            result = 31 * result + (this._tableRef == null ? 0 : this._tableRef.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._updatedTable == null ? 0 : this._updatedTable.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateTableInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateTableInput other = (UpdateTableInput)obj;
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._originalTable == null ? other.getOriginalTable() != null : !this._originalTable.equals(other.getOriginalTable())) {
                return false;
            }
            if (this._tableRef == null ? other.getTableRef() != null : !this._tableRef.equals((Object)other.getTableRef())) {
                return false;
            }
            if (this._transactionId == null ? other.getTransactionId() != null : !this._transactionId.equals(other.getTransactionId())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._updatedTable == null ? other.getUpdatedTable() != null : !this._updatedTable.equals(other.getUpdatedTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateTableInputImpl otherImpl = (UpdateTableInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdateTableInput [");
            boolean first = true;
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._originalTable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_originalTable=");
                builder.append(this._originalTable);
            }
            if (this._tableRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableRef=");
                builder.append(this._tableRef);
            }
            if (this._transactionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._updatedTable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_updatedTable=");
                builder.append(this._updatedTable);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

