/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.role.service.rev150727;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.role.service.rev150727.SetRoleOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetRoleOutputBuilder
implements Builder<SetRoleOutput> {
    private TransactionId _transactionId;
    Map<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTRANSACTIONIDRANGE_RANGES;

    public SetRoleOutputBuilder() {
    }

    public SetRoleOutputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public SetRoleOutputBuilder(SetRoleOutput base) {
        AugmentationHolder casted;
        this._transactionId = base.getTransactionId();
        if (base instanceof SetRoleOutputImpl) {
            SetRoleOutputImpl impl = (SetRoleOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public <E extends Augmentation<SetRoleOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkTransactionIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSACTIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSACTIONIDRANGE_RANGES)));
    }

    public SetRoleOutputBuilder setTransactionId(TransactionId value) {
        if (value != null) {
            SetRoleOutputBuilder.checkTransactionIdRange(value.getValue());
        }
        this._transactionId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _transactionId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public SetRoleOutputBuilder addAugmentation(Class<? extends Augmentation<SetRoleOutput>> augmentationType, Augmentation<SetRoleOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetRoleOutputBuilder removeAugmentation(Class<? extends Augmentation<SetRoleOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetRoleOutput build() {
        return new SetRoleOutputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSACTIONIDRANGE_RANGES = a;
    }

    private static final class SetRoleOutputImpl
    implements SetRoleOutput {
        private final TransactionId _transactionId;
        private Map<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetRoleOutput> getImplementedInterface() {
            return SetRoleOutput.class;
        }

        private SetRoleOutputImpl(SetRoleOutputBuilder base) {
            this._transactionId = base.getTransactionId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        public <E extends Augmentation<SetRoleOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetRoleOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetRoleOutput other = (SetRoleOutput)obj;
            if (this._transactionId == null ? other.getTransactionId() != null : !this._transactionId.equals(other.getTransactionId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetRoleOutputImpl otherImpl = (SetRoleOutputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetRoleOutput>>, Augmentation<SetRoleOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SetRoleOutput [");
            boolean first = true;
            if (this._transactionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

