/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.port.update.OriginalPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.port.update.UpdatedPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdatePortInputBuilder
implements Builder<UpdatePortInput> {
    private NodeRef _node;
    private OriginalPort _originalPort;
    private TransactionId _transactionId;
    private UpdatedPort _updatedPort;
    Map<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTRANSACTIONIDRANGE_RANGES;

    public UpdatePortInputBuilder() {
    }

    public UpdatePortInputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public UpdatePortInputBuilder(PortUpdate arg) {
        this._originalPort = arg.getOriginalPort();
        this._updatedPort = arg.getUpdatedPort();
        this._node = arg.getNode();
    }

    public UpdatePortInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdatePortInputBuilder(UpdatePortInput base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._originalPort = base.getOriginalPort();
        this._transactionId = base.getTransactionId();
        this._updatedPort = base.getUpdatedPort();
        if (base instanceof UpdatePortInputImpl) {
            UpdatePortInputImpl impl = (UpdatePortInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PortUpdate) {
            this._originalPort = ((PortUpdate)arg).getOriginalPort();
            this._updatedPort = ((PortUpdate)arg).getUpdatedPort();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalPort getOriginalPort() {
        return this._originalPort;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public UpdatedPort getUpdatedPort() {
        return this._updatedPort;
    }

    public <E extends Augmentation<UpdatePortInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdatePortInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public UpdatePortInputBuilder setOriginalPort(OriginalPort value) {
        this._originalPort = value;
        return this;
    }

    private static void checkTransactionIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSACTIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSACTIONIDRANGE_RANGES)));
    }

    public UpdatePortInputBuilder setTransactionId(TransactionId value) {
        if (value != null) {
            UpdatePortInputBuilder.checkTransactionIdRange(value.getValue());
        }
        this._transactionId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _transactionId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public UpdatePortInputBuilder setUpdatedPort(UpdatedPort value) {
        this._updatedPort = value;
        return this;
    }

    public UpdatePortInputBuilder addAugmentation(Class<? extends Augmentation<UpdatePortInput>> augmentationType, Augmentation<UpdatePortInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdatePortInputBuilder removeAugmentation(Class<? extends Augmentation<UpdatePortInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdatePortInput build() {
        return new UpdatePortInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSACTIONIDRANGE_RANGES = a;
    }

    private static final class UpdatePortInputImpl
    implements UpdatePortInput {
        private final NodeRef _node;
        private final OriginalPort _originalPort;
        private final TransactionId _transactionId;
        private final UpdatedPort _updatedPort;
        private Map<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdatePortInput> getImplementedInterface() {
            return UpdatePortInput.class;
        }

        private UpdatePortInputImpl(UpdatePortInputBuilder base) {
            this._node = base.getNode();
            this._originalPort = base.getOriginalPort();
            this._transactionId = base.getTransactionId();
            this._updatedPort = base.getUpdatedPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalPort getOriginalPort() {
            return this._originalPort;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public UpdatedPort getUpdatedPort() {
            return this._updatedPort;
        }

        public <E extends Augmentation<UpdatePortInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._originalPort == null ? 0 : this._originalPort.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._updatedPort == null ? 0 : this._updatedPort.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdatePortInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdatePortInput other = (UpdatePortInput)obj;
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._originalPort == null ? other.getOriginalPort() != null : !this._originalPort.equals(other.getOriginalPort())) {
                return false;
            }
            if (this._transactionId == null ? other.getTransactionId() != null : !this._transactionId.equals(other.getTransactionId())) {
                return false;
            }
            if (this._updatedPort == null ? other.getUpdatedPort() != null : !this._updatedPort.equals(other.getUpdatedPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdatePortInputImpl otherImpl = (UpdatePortInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdatePortInput [");
            boolean first = true;
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._originalPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_originalPort=");
                builder.append(this._originalPort);
            }
            if (this._transactionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            if (this._updatedPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_updatedPort=");
                builder.append(this._updatedPort);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

