/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortNumberUni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortRemoved;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortRemovedBuilder
implements Builder<PortRemoved> {
    private PortFeatures _advertisedFeatures;
    private PortConfig _configuration;
    private PortFeatures _currentFeature;
    private Long _currentSpeed;
    private MacAddress _hardwareAddress;
    private Long _maximumSpeed;
    private String _name;
    private NodeRef _node;
    private PortFeatures _peerFeatures;
    private PortNumberUni _portNumber;
    private List<Queue> _queue;
    private PortReason _reason;
    private State _state;
    private PortFeatures _supported;
    Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = Collections.emptyMap();

    public PortRemovedBuilder() {
    }

    public PortRemovedBuilder(FlowPortStatus arg) {
        this._reason = arg.getReason();
        this._name = arg.getName();
        this._state = arg.getState();
        this._currentFeature = arg.getCurrentFeature();
        this._supported = arg.getSupported();
        this._peerFeatures = arg.getPeerFeatures();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(FlowCapablePort arg) {
        this._name = arg.getName();
        this._state = arg.getState();
        this._currentFeature = arg.getCurrentFeature();
        this._supported = arg.getSupported();
        this._peerFeatures = arg.getPeerFeatures();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(CommonPort arg) {
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
    }

    public PortRemovedBuilder(Queues arg) {
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public PortRemovedBuilder(PortRemoved base) {
        AugmentationHolder casted;
        this._advertisedFeatures = base.getAdvertisedFeatures();
        this._configuration = base.getConfiguration();
        this._currentFeature = base.getCurrentFeature();
        this._currentSpeed = base.getCurrentSpeed();
        this._hardwareAddress = base.getHardwareAddress();
        this._maximumSpeed = base.getMaximumSpeed();
        this._name = base.getName();
        this._node = base.getNode();
        this._peerFeatures = base.getPeerFeatures();
        this._portNumber = base.getPortNumber();
        this._queue = base.getQueue();
        this._reason = base.getReason();
        this._state = base.getState();
        this._supported = base.getSupported();
        if (base instanceof PortRemovedImpl) {
            PortRemovedImpl impl = (PortRemovedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonPort) {
            this._portNumber = ((CommonPort)arg).getPortNumber();
            this._hardwareAddress = ((CommonPort)arg).getHardwareAddress();
            this._configuration = ((CommonPort)arg).getConfiguration();
            this._advertisedFeatures = ((CommonPort)arg).getAdvertisedFeatures();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof FlowCapablePort) {
            this._name = ((FlowCapablePort)arg).getName();
            this._state = ((FlowCapablePort)arg).getState();
            this._currentFeature = ((FlowCapablePort)arg).getCurrentFeature();
            this._supported = ((FlowCapablePort)arg).getSupported();
            this._peerFeatures = ((FlowCapablePort)arg).getPeerFeatures();
            this._currentSpeed = ((FlowCapablePort)arg).getCurrentSpeed();
            this._maximumSpeed = ((FlowCapablePort)arg).getMaximumSpeed();
            isValidArg = true;
        }
        if (arg instanceof FlowPortStatus) {
            this._reason = ((FlowPortStatus)arg).getReason();
            isValidArg = true;
        }
        if (arg instanceof Queues) {
            this._queue = ((Queues)arg).getQueue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortConfig getConfiguration() {
        return this._configuration;
    }

    public PortFeatures getCurrentFeature() {
        return this._currentFeature;
    }

    public Long getCurrentSpeed() {
        return this._currentSpeed;
    }

    public MacAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public Long getMaximumSpeed() {
        return this._maximumSpeed;
    }

    public String getName() {
        return this._name;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public PortNumberUni getPortNumber() {
        return this._portNumber;
    }

    public List<Queue> getQueue() {
        return this._queue;
    }

    public PortReason getReason() {
        return this._reason;
    }

    public State getState() {
        return this._state;
    }

    public PortFeatures getSupported() {
        return this._supported;
    }

    public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortRemovedBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortRemovedBuilder setConfiguration(PortConfig value) {
        this._configuration = value;
        return this;
    }

    public PortRemovedBuilder setCurrentFeature(PortFeatures value) {
        this._currentFeature = value;
        return this;
    }

    private static void checkCurrentSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortRemovedBuilder setCurrentSpeed(Long value) {
        if (value != null) {
            PortRemovedBuilder.checkCurrentSpeedRange(value);
        }
        this._currentSpeed = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _currentSpeed_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public PortRemovedBuilder setHardwareAddress(MacAddress value) {
        if (value != null) {
            // empty if block
        }
        this._hardwareAddress = value;
        return this;
    }

    private static void checkMaximumSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortRemovedBuilder setMaximumSpeed(Long value) {
        if (value != null) {
            PortRemovedBuilder.checkMaximumSpeedRange(value);
        }
        this._maximumSpeed = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maximumSpeed_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public PortRemovedBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PortRemovedBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public PortRemovedBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public PortRemovedBuilder setPortNumber(PortNumberUni value) {
        this._portNumber = value;
        return this;
    }

    public PortRemovedBuilder setQueue(List<Queue> value) {
        this._queue = value;
        return this;
    }

    public PortRemovedBuilder setReason(PortReason value) {
        this._reason = value;
        return this;
    }

    public PortRemovedBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public PortRemovedBuilder setSupported(PortFeatures value) {
        this._supported = value;
        return this;
    }

    public PortRemovedBuilder addAugmentation(Class<? extends Augmentation<PortRemoved>> augmentationType, Augmentation<PortRemoved> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortRemovedBuilder removeAugmentation(Class<? extends Augmentation<PortRemoved>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortRemoved build() {
        return new PortRemovedImpl(this);
    }

    private static final class PortRemovedImpl
    implements PortRemoved {
        private final PortFeatures _advertisedFeatures;
        private final PortConfig _configuration;
        private final PortFeatures _currentFeature;
        private final Long _currentSpeed;
        private final MacAddress _hardwareAddress;
        private final Long _maximumSpeed;
        private final String _name;
        private final NodeRef _node;
        private final PortFeatures _peerFeatures;
        private final PortNumberUni _portNumber;
        private final List<Queue> _queue;
        private final PortReason _reason;
        private final State _state;
        private final PortFeatures _supported;
        private Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortRemoved> getImplementedInterface() {
            return PortRemoved.class;
        }

        private PortRemovedImpl(PortRemovedBuilder base) {
            this._advertisedFeatures = base.getAdvertisedFeatures();
            this._configuration = base.getConfiguration();
            this._currentFeature = base.getCurrentFeature();
            this._currentSpeed = base.getCurrentSpeed();
            this._hardwareAddress = base.getHardwareAddress();
            this._maximumSpeed = base.getMaximumSpeed();
            this._name = base.getName();
            this._node = base.getNode();
            this._peerFeatures = base.getPeerFeatures();
            this._portNumber = base.getPortNumber();
            this._queue = base.getQueue();
            this._reason = base.getReason();
            this._state = base.getState();
            this._supported = base.getSupported();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(base.augmentation);
                }
            }
        }

        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        public PortConfig getConfiguration() {
            return this._configuration;
        }

        public PortFeatures getCurrentFeature() {
            return this._currentFeature;
        }

        public Long getCurrentSpeed() {
            return this._currentSpeed;
        }

        public MacAddress getHardwareAddress() {
            return this._hardwareAddress;
        }

        public Long getMaximumSpeed() {
            return this._maximumSpeed;
        }

        public String getName() {
            return this._name;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        public PortNumberUni getPortNumber() {
            return this._portNumber;
        }

        public List<Queue> getQueue() {
            return this._queue;
        }

        public PortReason getReason() {
            return this._reason;
        }

        public State getState() {
            return this._state;
        }

        public PortFeatures getSupported() {
            return this._supported;
        }

        public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._advertisedFeatures == null ? 0 : this._advertisedFeatures.hashCode());
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._currentFeature == null ? 0 : this._currentFeature.hashCode());
            result = 31 * result + (this._currentSpeed == null ? 0 : this._currentSpeed.hashCode());
            result = 31 * result + (this._hardwareAddress == null ? 0 : this._hardwareAddress.hashCode());
            result = 31 * result + (this._maximumSpeed == null ? 0 : this._maximumSpeed.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._peerFeatures == null ? 0 : this._peerFeatures.hashCode());
            result = 31 * result + (this._portNumber == null ? 0 : this._portNumber.hashCode());
            result = 31 * result + (this._queue == null ? 0 : this._queue.hashCode());
            result = 31 * result + (this._reason == null ? 0 : this._reason.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            result = 31 * result + (this._supported == null ? 0 : this._supported.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortRemoved.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortRemoved other = (PortRemoved)obj;
            if (this._advertisedFeatures == null ? other.getAdvertisedFeatures() != null : !this._advertisedFeatures.equals((Object)other.getAdvertisedFeatures())) {
                return false;
            }
            if (this._configuration == null ? other.getConfiguration() != null : !this._configuration.equals((Object)other.getConfiguration())) {
                return false;
            }
            if (this._currentFeature == null ? other.getCurrentFeature() != null : !this._currentFeature.equals((Object)other.getCurrentFeature())) {
                return false;
            }
            if (this._currentSpeed == null ? other.getCurrentSpeed() != null : !this._currentSpeed.equals(other.getCurrentSpeed())) {
                return false;
            }
            if (this._hardwareAddress == null ? other.getHardwareAddress() != null : !this._hardwareAddress.equals((Object)other.getHardwareAddress())) {
                return false;
            }
            if (this._maximumSpeed == null ? other.getMaximumSpeed() != null : !this._maximumSpeed.equals(other.getMaximumSpeed())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._peerFeatures == null ? other.getPeerFeatures() != null : !this._peerFeatures.equals((Object)other.getPeerFeatures())) {
                return false;
            }
            if (this._portNumber == null ? other.getPortNumber() != null : !this._portNumber.equals((Object)other.getPortNumber())) {
                return false;
            }
            if (this._queue == null ? other.getQueue() != null : !this._queue.equals(other.getQueue())) {
                return false;
            }
            if (this._reason == null ? other.getReason() != null : !this._reason.equals((Object)other.getReason())) {
                return false;
            }
            if (this._state == null ? other.getState() != null : !this._state.equals(other.getState())) {
                return false;
            }
            if (this._supported == null ? other.getSupported() != null : !this._supported.equals((Object)other.getSupported())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortRemovedImpl otherImpl = (PortRemovedImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PortRemoved [");
            boolean first = true;
            if (this._advertisedFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertisedFeatures=");
                builder.append(this._advertisedFeatures);
            }
            if (this._configuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configuration=");
                builder.append(this._configuration);
            }
            if (this._currentFeature != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentFeature=");
                builder.append(this._currentFeature);
            }
            if (this._currentSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentSpeed=");
                builder.append(this._currentSpeed);
            }
            if (this._hardwareAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardwareAddress=");
                builder.append(this._hardwareAddress);
            }
            if (this._maximumSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maximumSpeed=");
                builder.append(this._maximumSpeed);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._peerFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_peerFeatures=");
                builder.append(this._peerFeatures);
            }
            if (this._portNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNumber=");
                builder.append(this._portNumber);
            }
            if (this._queue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queue=");
                builder.append(this._queue);
            }
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append(this._reason);
            }
            if (this._state != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_state=");
                builder.append(this._state);
            }
            if (this._supported != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supported=");
                builder.append(this._supported);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

