/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.TcpFlagMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Tunnel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received.Match;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchBuilder
implements Builder<Match> {
    private EthernetMatch _ethernetMatch;
    private Icmpv4Match _icmpv4Match;
    private Icmpv6Match _icmpv6Match;
    private NodeConnectorId _inPhyPort;
    private NodeConnectorId _inPort;
    private IpMatch _ipMatch;
    private Layer3Match _layer3Match;
    private Layer4Match _layer4Match;
    private Metadata _metadata;
    private ProtocolMatchFields _protocolMatchFields;
    private TcpFlagMatch _tcpFlagMatch;
    private Tunnel _tunnel;
    private VlanMatch _vlanMatch;
    Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();

    public MatchBuilder() {
    }

    public MatchBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match arg) {
        this._inPort = arg.getInPort();
        this._inPhyPort = arg.getInPhyPort();
        this._metadata = arg.getMetadata();
        this._tunnel = arg.getTunnel();
        this._ethernetMatch = arg.getEthernetMatch();
        this._vlanMatch = arg.getVlanMatch();
        this._ipMatch = arg.getIpMatch();
        this._layer3Match = arg.getLayer3Match();
        this._layer4Match = arg.getLayer4Match();
        this._icmpv4Match = arg.getIcmpv4Match();
        this._icmpv6Match = arg.getIcmpv6Match();
        this._protocolMatchFields = arg.getProtocolMatchFields();
        this._tcpFlagMatch = arg.getTcpFlagMatch();
    }

    public MatchBuilder(Match base) {
        AugmentationHolder casted;
        this._ethernetMatch = base.getEthernetMatch();
        this._icmpv4Match = base.getIcmpv4Match();
        this._icmpv6Match = base.getIcmpv6Match();
        this._inPhyPort = base.getInPhyPort();
        this._inPort = base.getInPort();
        this._ipMatch = base.getIpMatch();
        this._layer3Match = base.getLayer3Match();
        this._layer4Match = base.getLayer4Match();
        this._metadata = base.getMetadata();
        this._protocolMatchFields = base.getProtocolMatchFields();
        this._tcpFlagMatch = base.getTcpFlagMatch();
        this._tunnel = base.getTunnel();
        this._vlanMatch = base.getVlanMatch();
        if (base instanceof MatchImpl) {
            MatchImpl impl = (MatchImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match) {
            this._inPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPort();
            this._inPhyPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPhyPort();
            this._metadata = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getMetadata();
            this._tunnel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getTunnel();
            this._ethernetMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getEthernetMatch();
            this._vlanMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getVlanMatch();
            this._ipMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIpMatch();
            this._layer3Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer3Match();
            this._layer4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer4Match();
            this._icmpv4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv4Match();
            this._icmpv6Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv6Match();
            this._protocolMatchFields = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getProtocolMatchFields();
            this._tcpFlagMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getTcpFlagMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match] \nbut was: " + arg);
        }
    }

    public EthernetMatch getEthernetMatch() {
        return this._ethernetMatch;
    }

    public Icmpv4Match getIcmpv4Match() {
        return this._icmpv4Match;
    }

    public Icmpv6Match getIcmpv6Match() {
        return this._icmpv6Match;
    }

    public NodeConnectorId getInPhyPort() {
        return this._inPhyPort;
    }

    public NodeConnectorId getInPort() {
        return this._inPort;
    }

    public IpMatch getIpMatch() {
        return this._ipMatch;
    }

    public Layer3Match getLayer3Match() {
        return this._layer3Match;
    }

    public Layer4Match getLayer4Match() {
        return this._layer4Match;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public ProtocolMatchFields getProtocolMatchFields() {
        return this._protocolMatchFields;
    }

    public TcpFlagMatch getTcpFlagMatch() {
        return this._tcpFlagMatch;
    }

    public Tunnel getTunnel() {
        return this._tunnel;
    }

    public VlanMatch getVlanMatch() {
        return this._vlanMatch;
    }

    public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchBuilder setEthernetMatch(EthernetMatch value) {
        this._ethernetMatch = value;
        return this;
    }

    public MatchBuilder setIcmpv4Match(Icmpv4Match value) {
        this._icmpv4Match = value;
        return this;
    }

    public MatchBuilder setIcmpv6Match(Icmpv6Match value) {
        this._icmpv6Match = value;
        return this;
    }

    public MatchBuilder setInPhyPort(NodeConnectorId value) {
        if (value != null) {
            // empty if block
        }
        this._inPhyPort = value;
        return this;
    }

    public MatchBuilder setInPort(NodeConnectorId value) {
        if (value != null) {
            // empty if block
        }
        this._inPort = value;
        return this;
    }

    public MatchBuilder setIpMatch(IpMatch value) {
        this._ipMatch = value;
        return this;
    }

    public MatchBuilder setLayer3Match(Layer3Match value) {
        this._layer3Match = value;
        return this;
    }

    public MatchBuilder setLayer4Match(Layer4Match value) {
        this._layer4Match = value;
        return this;
    }

    public MatchBuilder setMetadata(Metadata value) {
        this._metadata = value;
        return this;
    }

    public MatchBuilder setProtocolMatchFields(ProtocolMatchFields value) {
        this._protocolMatchFields = value;
        return this;
    }

    public MatchBuilder setTcpFlagMatch(TcpFlagMatch value) {
        this._tcpFlagMatch = value;
        return this;
    }

    public MatchBuilder setTunnel(Tunnel value) {
        this._tunnel = value;
        return this;
    }

    public MatchBuilder setVlanMatch(VlanMatch value) {
        this._vlanMatch = value;
        return this;
    }

    public MatchBuilder addAugmentation(Class<? extends Augmentation<Match>> augmentationType, Augmentation<Match> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchBuilder removeAugmentation(Class<? extends Augmentation<Match>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
    implements Match {
        private final EthernetMatch _ethernetMatch;
        private final Icmpv4Match _icmpv4Match;
        private final Icmpv6Match _icmpv6Match;
        private final NodeConnectorId _inPhyPort;
        private final NodeConnectorId _inPort;
        private final IpMatch _ipMatch;
        private final Layer3Match _layer3Match;
        private final Layer4Match _layer4Match;
        private final Metadata _metadata;
        private final ProtocolMatchFields _protocolMatchFields;
        private final TcpFlagMatch _tcpFlagMatch;
        private final Tunnel _tunnel;
        private final VlanMatch _vlanMatch;
        private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Match> getImplementedInterface() {
            return Match.class;
        }

        private MatchImpl(MatchBuilder base) {
            this._ethernetMatch = base.getEthernetMatch();
            this._icmpv4Match = base.getIcmpv4Match();
            this._icmpv6Match = base.getIcmpv6Match();
            this._inPhyPort = base.getInPhyPort();
            this._inPort = base.getInPort();
            this._ipMatch = base.getIpMatch();
            this._layer3Match = base.getLayer3Match();
            this._layer4Match = base.getLayer4Match();
            this._metadata = base.getMetadata();
            this._protocolMatchFields = base.getProtocolMatchFields();
            this._tcpFlagMatch = base.getTcpFlagMatch();
            this._tunnel = base.getTunnel();
            this._vlanMatch = base.getVlanMatch();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(base.augmentation);
                }
            }
        }

        public EthernetMatch getEthernetMatch() {
            return this._ethernetMatch;
        }

        public Icmpv4Match getIcmpv4Match() {
            return this._icmpv4Match;
        }

        public Icmpv6Match getIcmpv6Match() {
            return this._icmpv6Match;
        }

        public NodeConnectorId getInPhyPort() {
            return this._inPhyPort;
        }

        public NodeConnectorId getInPort() {
            return this._inPort;
        }

        public IpMatch getIpMatch() {
            return this._ipMatch;
        }

        public Layer3Match getLayer3Match() {
            return this._layer3Match;
        }

        public Layer4Match getLayer4Match() {
            return this._layer4Match;
        }

        public Metadata getMetadata() {
            return this._metadata;
        }

        public ProtocolMatchFields getProtocolMatchFields() {
            return this._protocolMatchFields;
        }

        public TcpFlagMatch getTcpFlagMatch() {
            return this._tcpFlagMatch;
        }

        public Tunnel getTunnel() {
            return this._tunnel;
        }

        public VlanMatch getVlanMatch() {
            return this._vlanMatch;
        }

        public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ethernetMatch == null ? 0 : this._ethernetMatch.hashCode());
            result = 31 * result + (this._icmpv4Match == null ? 0 : this._icmpv4Match.hashCode());
            result = 31 * result + (this._icmpv6Match == null ? 0 : this._icmpv6Match.hashCode());
            result = 31 * result + (this._inPhyPort == null ? 0 : this._inPhyPort.hashCode());
            result = 31 * result + (this._inPort == null ? 0 : this._inPort.hashCode());
            result = 31 * result + (this._ipMatch == null ? 0 : this._ipMatch.hashCode());
            result = 31 * result + (this._layer3Match == null ? 0 : this._layer3Match.hashCode());
            result = 31 * result + (this._layer4Match == null ? 0 : this._layer4Match.hashCode());
            result = 31 * result + (this._metadata == null ? 0 : this._metadata.hashCode());
            result = 31 * result + (this._protocolMatchFields == null ? 0 : this._protocolMatchFields.hashCode());
            result = 31 * result + (this._tcpFlagMatch == null ? 0 : this._tcpFlagMatch.hashCode());
            result = 31 * result + (this._tunnel == null ? 0 : this._tunnel.hashCode());
            result = 31 * result + (this._vlanMatch == null ? 0 : this._vlanMatch.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Match.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Match other = (Match)obj;
            if (this._ethernetMatch == null ? other.getEthernetMatch() != null : !this._ethernetMatch.equals(other.getEthernetMatch())) {
                return false;
            }
            if (this._icmpv4Match == null ? other.getIcmpv4Match() != null : !this._icmpv4Match.equals(other.getIcmpv4Match())) {
                return false;
            }
            if (this._icmpv6Match == null ? other.getIcmpv6Match() != null : !this._icmpv6Match.equals(other.getIcmpv6Match())) {
                return false;
            }
            if (this._inPhyPort == null ? other.getInPhyPort() != null : !this._inPhyPort.equals((Object)other.getInPhyPort())) {
                return false;
            }
            if (this._inPort == null ? other.getInPort() != null : !this._inPort.equals((Object)other.getInPort())) {
                return false;
            }
            if (this._ipMatch == null ? other.getIpMatch() != null : !this._ipMatch.equals(other.getIpMatch())) {
                return false;
            }
            if (this._layer3Match == null ? other.getLayer3Match() != null : !this._layer3Match.equals(other.getLayer3Match())) {
                return false;
            }
            if (this._layer4Match == null ? other.getLayer4Match() != null : !this._layer4Match.equals(other.getLayer4Match())) {
                return false;
            }
            if (this._metadata == null ? other.getMetadata() != null : !this._metadata.equals(other.getMetadata())) {
                return false;
            }
            if (this._protocolMatchFields == null ? other.getProtocolMatchFields() != null : !this._protocolMatchFields.equals(other.getProtocolMatchFields())) {
                return false;
            }
            if (this._tcpFlagMatch == null ? other.getTcpFlagMatch() != null : !this._tcpFlagMatch.equals(other.getTcpFlagMatch())) {
                return false;
            }
            if (this._tunnel == null ? other.getTunnel() != null : !this._tunnel.equals(other.getTunnel())) {
                return false;
            }
            if (this._vlanMatch == null ? other.getVlanMatch() != null : !this._vlanMatch.equals(other.getVlanMatch())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchImpl otherImpl = (MatchImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Match [");
            boolean first = true;
            if (this._ethernetMatch != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ethernetMatch=");
                builder.append(this._ethernetMatch);
            }
            if (this._icmpv4Match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv4Match=");
                builder.append(this._icmpv4Match);
            }
            if (this._icmpv6Match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv6Match=");
                builder.append(this._icmpv6Match);
            }
            if (this._inPhyPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPhyPort=");
                builder.append(this._inPhyPort);
            }
            if (this._inPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPort=");
                builder.append(this._inPort);
            }
            if (this._ipMatch != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipMatch=");
                builder.append(this._ipMatch);
            }
            if (this._layer3Match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_layer3Match=");
                builder.append(this._layer3Match);
            }
            if (this._layer4Match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_layer4Match=");
                builder.append(this._layer4Match);
            }
            if (this._metadata != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metadata=");
                builder.append(this._metadata);
            }
            if (this._protocolMatchFields != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocolMatchFields=");
                builder.append(this._protocolMatchFields);
            }
            if (this._tcpFlagMatch != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcpFlagMatch=");
                builder.append(this._tcpFlagMatch);
            }
            if (this._tunnel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tunnel=");
                builder.append(this._tunnel);
            }
            if (this._vlanMatch != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vlanMatch=");
                builder.append(this._vlanMatch);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

