/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.ConnectionCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TransmitPacketInputBuilder
implements Builder<TransmitPacketInput> {
    private List<Action> _action;
    private Long _bufferId;
    private ConnectionCookie _connectionCookie;
    private NodeConnectorRef _egress;
    private NodeConnectorRef _ingress;
    private NodeRef _node;
    private byte[] _payload;
    Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = Collections.emptyMap();

    public TransmitPacketInputBuilder() {
    }

    public TransmitPacketInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public TransmitPacketInputBuilder(ActionList arg) {
        this._action = arg.getAction();
    }

    public TransmitPacketInputBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public TransmitPacketInputBuilder(TransmitPacketInput base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._bufferId = base.getBufferId();
        this._connectionCookie = base.getConnectionCookie();
        this._egress = base.getEgress();
        this._ingress = base.getIngress();
        this._node = base.getNode();
        this._payload = base.getPayload();
        if (base instanceof TransmitPacketInputImpl) {
            TransmitPacketInputImpl impl = (TransmitPacketInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof ActionList) {
            this._action = ((ActionList)arg).getAction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public ConnectionCookie getConnectionCookie() {
        return this._connectionCookie;
    }

    public NodeConnectorRef getEgress() {
        return this._egress;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public byte[] getPayload() {
        return this._payload == null ? null : (byte[])this._payload.clone();
    }

    public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TransmitPacketInputBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TransmitPacketInputBuilder setBufferId(Long value) {
        if (value != null) {
            TransmitPacketInputBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _bufferId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkConnectionCookieRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TransmitPacketInputBuilder setConnectionCookie(ConnectionCookie value) {
        if (value != null) {
            TransmitPacketInputBuilder.checkConnectionCookieRange(value.getValue());
        }
        this._connectionCookie = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _connectionCookie_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public TransmitPacketInputBuilder setEgress(NodeConnectorRef value) {
        if (value != null) {
            // empty if block
        }
        this._egress = value;
        return this;
    }

    public TransmitPacketInputBuilder setIngress(NodeConnectorRef value) {
        if (value != null) {
            // empty if block
        }
        this._ingress = value;
        return this;
    }

    public TransmitPacketInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public TransmitPacketInputBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    public TransmitPacketInputBuilder addAugmentation(Class<? extends Augmentation<TransmitPacketInput>> augmentationType, Augmentation<TransmitPacketInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TransmitPacketInputBuilder removeAugmentation(Class<? extends Augmentation<TransmitPacketInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TransmitPacketInput build() {
        return new TransmitPacketInputImpl(this);
    }

    private static final class TransmitPacketInputImpl
    implements TransmitPacketInput {
        private final List<Action> _action;
        private final Long _bufferId;
        private final ConnectionCookie _connectionCookie;
        private final NodeConnectorRef _egress;
        private final NodeConnectorRef _ingress;
        private final NodeRef _node;
        private final byte[] _payload;
        private Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TransmitPacketInput> getImplementedInterface() {
            return TransmitPacketInput.class;
        }

        private TransmitPacketInputImpl(TransmitPacketInputBuilder base) {
            this._action = base.getAction();
            this._bufferId = base.getBufferId();
            this._connectionCookie = base.getConnectionCookie();
            this._egress = base.getEgress();
            this._ingress = base.getIngress();
            this._node = base.getNode();
            this._payload = base.getPayload();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(base.augmentation);
                }
            }
        }

        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public ConnectionCookie getConnectionCookie() {
            return this._connectionCookie;
        }

        @Override
        public NodeConnectorRef getEgress() {
            return this._egress;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public byte[] getPayload() {
            return this._payload == null ? null : (byte[])this._payload.clone();
        }

        public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._action == null ? 0 : this._action.hashCode());
            result = 31 * result + (this._bufferId == null ? 0 : this._bufferId.hashCode());
            result = 31 * result + (this._connectionCookie == null ? 0 : this._connectionCookie.hashCode());
            result = 31 * result + (this._egress == null ? 0 : this._egress.hashCode());
            result = 31 * result + (this._ingress == null ? 0 : this._ingress.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._payload == null ? 0 : Arrays.hashCode(this._payload));
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TransmitPacketInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TransmitPacketInput other = (TransmitPacketInput)obj;
            if (this._action == null ? other.getAction() != null : !this._action.equals(other.getAction())) {
                return false;
            }
            if (this._bufferId == null ? other.getBufferId() != null : !this._bufferId.equals(other.getBufferId())) {
                return false;
            }
            if (this._connectionCookie == null ? other.getConnectionCookie() != null : !this._connectionCookie.equals(other.getConnectionCookie())) {
                return false;
            }
            if (this._egress == null ? other.getEgress() != null : !this._egress.equals((Object)other.getEgress())) {
                return false;
            }
            if (this._ingress == null ? other.getIngress() != null : !this._ingress.equals((Object)other.getIngress())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._payload == null ? other.getPayload() != null : !Arrays.equals(this._payload, other.getPayload())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TransmitPacketInputImpl otherImpl = (TransmitPacketInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TransmitPacketInput [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._bufferId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bufferId=");
                builder.append(this._bufferId);
            }
            if (this._connectionCookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connectionCookie=");
                builder.append(this._connectionCookie);
            }
            if (this._egress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_egress=");
                builder.append(this._egress);
            }
            if (this._ingress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ingress=");
                builder.append(this._ingress);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._payload != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_payload=");
                builder.append(Arrays.toString(this._payload));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

