/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.ConnectionCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketReceivedBuilder
implements Builder<PacketReceived> {
    private ConnectionCookie _connectionCookie;
    private FlowCookie _flowCookie;
    private NodeConnectorRef _ingress;
    private Match _match;
    private Class<? extends PacketInReason> _packetInReason;
    private byte[] _payload;
    private TableId _tableId;
    Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKFLOWCOOKIERANGE_RANGES;

    public PacketReceivedBuilder() {
    }

    public PacketReceivedBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public PacketReceivedBuilder(PacketReceived base) {
        AugmentationHolder casted;
        this._connectionCookie = base.getConnectionCookie();
        this._flowCookie = base.getFlowCookie();
        this._ingress = base.getIngress();
        this._match = base.getMatch();
        this._packetInReason = base.getPacketInReason();
        this._payload = base.getPayload();
        this._tableId = base.getTableId();
        if (base instanceof PacketReceivedImpl) {
            PacketReceivedImpl impl = (PacketReceivedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket] \nbut was: " + arg);
        }
    }

    public ConnectionCookie getConnectionCookie() {
        return this._connectionCookie;
    }

    public FlowCookie getFlowCookie() {
        return this._flowCookie;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public Match getMatch() {
        return this._match;
    }

    public Class<? extends PacketInReason> getPacketInReason() {
        return this._packetInReason;
    }

    public byte[] getPayload() {
        return this._payload == null ? null : (byte[])this._payload.clone();
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkConnectionCookieRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketReceivedBuilder setConnectionCookie(ConnectionCookie value) {
        if (value != null) {
            PacketReceivedBuilder.checkConnectionCookieRange(value.getValue());
        }
        this._connectionCookie = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _connectionCookie_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkFlowCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKFLOWCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKFLOWCOOKIERANGE_RANGES)));
    }

    public PacketReceivedBuilder setFlowCookie(FlowCookie value) {
        if (value != null) {
            PacketReceivedBuilder.checkFlowCookieRange(value.getValue());
        }
        this._flowCookie = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _flowCookie_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public PacketReceivedBuilder setIngress(NodeConnectorRef value) {
        if (value != null) {
            // empty if block
        }
        this._ingress = value;
        return this;
    }

    public PacketReceivedBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public PacketReceivedBuilder setPacketInReason(Class<? extends PacketInReason> value) {
        this._packetInReason = value;
        return this;
    }

    public PacketReceivedBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PacketReceivedBuilder setTableId(TableId value) {
        if (value != null) {
            PacketReceivedBuilder.checkTableIdRange(value.getValue());
        }
        this._tableId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tableId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public PacketReceivedBuilder addAugmentation(Class<? extends Augmentation<PacketReceived>> augmentationType, Augmentation<PacketReceived> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketReceivedBuilder removeAugmentation(Class<? extends Augmentation<PacketReceived>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketReceived build() {
        return new PacketReceivedImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKFLOWCOOKIERANGE_RANGES = a;
    }

    private static final class PacketReceivedImpl
    implements PacketReceived {
        private final ConnectionCookie _connectionCookie;
        private final FlowCookie _flowCookie;
        private final NodeConnectorRef _ingress;
        private final Match _match;
        private final Class<? extends PacketInReason> _packetInReason;
        private final byte[] _payload;
        private final TableId _tableId;
        private Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketReceived> getImplementedInterface() {
            return PacketReceived.class;
        }

        private PacketReceivedImpl(PacketReceivedBuilder base) {
            this._connectionCookie = base.getConnectionCookie();
            this._flowCookie = base.getFlowCookie();
            this._ingress = base.getIngress();
            this._match = base.getMatch();
            this._packetInReason = base.getPacketInReason();
            this._payload = base.getPayload();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(base.augmentation);
                }
            }
        }

        @Override
        public ConnectionCookie getConnectionCookie() {
            return this._connectionCookie;
        }

        @Override
        public FlowCookie getFlowCookie() {
            return this._flowCookie;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Class<? extends PacketInReason> getPacketInReason() {
            return this._packetInReason;
        }

        @Override
        public byte[] getPayload() {
            return this._payload == null ? null : (byte[])this._payload.clone();
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._connectionCookie == null ? 0 : this._connectionCookie.hashCode());
            result = 31 * result + (this._flowCookie == null ? 0 : this._flowCookie.hashCode());
            result = 31 * result + (this._ingress == null ? 0 : this._ingress.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._packetInReason == null ? 0 : this._packetInReason.hashCode());
            result = 31 * result + (this._payload == null ? 0 : Arrays.hashCode(this._payload));
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketReceived.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketReceived other = (PacketReceived)obj;
            if (this._connectionCookie == null ? other.getConnectionCookie() != null : !this._connectionCookie.equals(other.getConnectionCookie())) {
                return false;
            }
            if (this._flowCookie == null ? other.getFlowCookie() != null : !this._flowCookie.equals((Object)other.getFlowCookie())) {
                return false;
            }
            if (this._ingress == null ? other.getIngress() != null : !this._ingress.equals((Object)other.getIngress())) {
                return false;
            }
            if (this._match == null ? other.getMatch() != null : !this._match.equals(other.getMatch())) {
                return false;
            }
            if (this._packetInReason == null ? other.getPacketInReason() != null : !this._packetInReason.equals(other.getPacketInReason())) {
                return false;
            }
            if (this._payload == null ? other.getPayload() != null : !Arrays.equals(this._payload, other.getPayload())) {
                return false;
            }
            if (this._tableId == null ? other.getTableId() != null : !this._tableId.equals((Object)other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketReceivedImpl otherImpl = (PacketReceivedImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PacketReceived [");
            boolean first = true;
            if (this._connectionCookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connectionCookie=");
                builder.append(this._connectionCookie);
            }
            if (this._flowCookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowCookie=");
                builder.append(this._flowCookie);
            }
            if (this._ingress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ingress=");
                builder.append(this._ingress);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._packetInReason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetInReason=");
                builder.append(this._packetInReason);
            }
            if (this._payload != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_payload=");
                builder.append(Arrays.toString(this._payload));
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

