/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.node.error.reference.ObjectReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410.RoleRequestErrorNotification;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoleRequestErrorNotificationBuilder
implements Builder<RoleRequestErrorNotification> {
    private Integer _code;
    private String _data;
    private NodeRef _node;
    private ObjectReference _objectReference;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private ErrorType _type;
    Map<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTRANSACTIONIDRANGE_RANGES;

    public RoleRequestErrorNotificationBuilder() {
    }

    public RoleRequestErrorNotificationBuilder(NodeErrorReference arg) {
        this._objectReference = arg.getObjectReference();
    }

    public RoleRequestErrorNotificationBuilder(BaseNodeErrorNotification arg) {
        this._node = arg.getNode();
    }

    public RoleRequestErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public RoleRequestErrorNotificationBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public RoleRequestErrorNotificationBuilder(ErrorMessage arg) {
        this._type = arg.getType();
        this._code = arg.getCode();
        this._data = arg.getData();
    }

    public RoleRequestErrorNotificationBuilder(RoleRequestErrorNotification base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._data = base.getData();
        this._node = base.getNode();
        this._objectReference = base.getObjectReference();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._type = base.getType();
        if (base instanceof RoleRequestErrorNotificationImpl) {
            RoleRequestErrorNotificationImpl impl = (RoleRequestErrorNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeErrorReference) {
            this._objectReference = ((NodeErrorReference)arg).getObjectReference();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof ErrorMessage) {
            this._type = ((ErrorMessage)arg).getType();
            this._code = ((ErrorMessage)arg).getCode();
            this._data = ((ErrorMessage)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof BaseNodeErrorNotification) {
            this._node = ((BaseNodeErrorNotification)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getData() {
        return this._data;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public ObjectReference getObjectReference() {
        return this._objectReference;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<RoleRequestErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public RoleRequestErrorNotificationBuilder setCode(Integer value) {
        if (value != null) {
            RoleRequestErrorNotificationBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _code_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public RoleRequestErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public RoleRequestErrorNotificationBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public RoleRequestErrorNotificationBuilder setObjectReference(ObjectReference value) {
        this._objectReference = value;
        return this;
    }

    private static void checkTransactionIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSACTIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSACTIONIDRANGE_RANGES)));
    }

    public RoleRequestErrorNotificationBuilder setTransactionId(TransactionId value) {
        if (value != null) {
            RoleRequestErrorNotificationBuilder.checkTransactionIdRange(value.getValue());
        }
        this._transactionId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _transactionId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public RoleRequestErrorNotificationBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public RoleRequestErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public RoleRequestErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<RoleRequestErrorNotification>> augmentationType, Augmentation<RoleRequestErrorNotification> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RoleRequestErrorNotificationBuilder removeAugmentation(Class<? extends Augmentation<RoleRequestErrorNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoleRequestErrorNotification build() {
        return new RoleRequestErrorNotificationImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSACTIONIDRANGE_RANGES = a;
    }

    private static final class RoleRequestErrorNotificationImpl
    implements RoleRequestErrorNotification {
        private final Integer _code;
        private final String _data;
        private final NodeRef _node;
        private final ObjectReference _objectReference;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RoleRequestErrorNotification> getImplementedInterface() {
            return RoleRequestErrorNotification.class;
        }

        private RoleRequestErrorNotificationImpl(RoleRequestErrorNotificationBuilder base) {
            this._code = base.getCode();
            this._data = base.getData();
            this._node = base.getNode();
            this._objectReference = base.getObjectReference();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public ObjectReference getObjectReference() {
            return this._objectReference;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<RoleRequestErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._code == null ? 0 : this._code.hashCode());
            result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._objectReference == null ? 0 : this._objectReference.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RoleRequestErrorNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RoleRequestErrorNotification other = (RoleRequestErrorNotification)obj;
            if (this._code == null ? other.getCode() != null : !this._code.equals(other.getCode())) {
                return false;
            }
            if (this._data == null ? other.getData() != null : !this._data.equals(other.getData())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._objectReference == null ? other.getObjectReference() != null : !this._objectReference.equals(other.getObjectReference())) {
                return false;
            }
            if (this._transactionId == null ? other.getTransactionId() != null : !this._transactionId.equals(other.getTransactionId())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._type == null ? other.getType() != null : !this._type.equals((Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RoleRequestErrorNotificationImpl otherImpl = (RoleRequestErrorNotificationImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RoleRequestErrorNotification>>, Augmentation<RoleRequestErrorNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RoleRequestErrorNotification [");
            boolean first = true;
            if (this._code != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_code=");
                builder.append(this._code);
            }
            if (this._data != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_data=");
                builder.append(this._data);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._objectReference != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_objectReference=");
                builder.append(this._objectReference);
            }
            if (this._transactionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

