/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddMeterInputBuilder
implements Builder<AddMeterInput> {
    private String _containerName;
    private MeterFlags _flags;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private MeterRef _meterRef;
    private NodeRef _node;
    private Uri _transactionUri;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>> augmentation = Collections.emptyMap();

    public AddMeterInputBuilder() {
    }

    public AddMeterInputBuilder(Meter arg) {
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._barrier = arg.isBarrier();
        this._meterName = arg.getMeterName();
        this._containerName = arg.getContainerName();
        this._meterBandHeaders = arg.getMeterBandHeaders();
    }

    public AddMeterInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public AddMeterInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public AddMeterInputBuilder(AddMeterInput base) {
        AugmentationHolder casted;
        this._containerName = base.getContainerName();
        this._flags = base.getFlags();
        this._meterBandHeaders = base.getMeterBandHeaders();
        this._meterId = base.getMeterId();
        this._meterName = base.getMeterName();
        this._meterRef = base.getMeterRef();
        this._node = base.getNode();
        this._transactionUri = base.getTransactionUri();
        this._barrier = base.isBarrier();
        if (base instanceof AddMeterInputImpl) {
            AddMeterInputImpl impl = (AddMeterInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Meter) {
            this._flags = ((Meter)arg).getFlags();
            this._meterId = ((Meter)arg).getMeterId();
            this._barrier = ((Meter)arg).isBarrier();
            this._meterName = ((Meter)arg).getMeterName();
            this._containerName = ((Meter)arg).getContainerName();
            this._meterBandHeaders = ((Meter)arg).getMeterBandHeaders();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<AddMeterInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddMeterInputBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public AddMeterInputBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public AddMeterInputBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    private static void checkMeterIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public AddMeterInputBuilder setMeterId(MeterId value) {
        if (value != null) {
            AddMeterInputBuilder.checkMeterIdRange(value.getValue());
        }
        this._meterId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _meterId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public AddMeterInputBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public AddMeterInputBuilder setMeterRef(MeterRef value) {
        if (value != null) {
            // empty if block
        }
        this._meterRef = value;
        return this;
    }

    public AddMeterInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public AddMeterInputBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public AddMeterInputBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public AddMeterInputBuilder addAugmentation(Class<? extends Augmentation<AddMeterInput>> augmentationType, Augmentation<AddMeterInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AddMeterInputBuilder removeAugmentation(Class<? extends Augmentation<AddMeterInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AddMeterInput build() {
        return new AddMeterInputImpl(this);
    }

    private static final class AddMeterInputImpl
    implements AddMeterInput {
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private final MeterRef _meterRef;
        private final NodeRef _node;
        private final Uri _transactionUri;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AddMeterInput> getImplementedInterface() {
            return AddMeterInput.class;
        }

        private AddMeterInputImpl(AddMeterInputBuilder base) {
            this._containerName = base.getContainerName();
            this._flags = base.getFlags();
            this._meterBandHeaders = base.getMeterBandHeaders();
            this._meterId = base.getMeterId();
            this._meterName = base.getMeterName();
            this._meterRef = base.getMeterRef();
            this._node = base.getNode();
            this._transactionUri = base.getTransactionUri();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>>(base.augmentation);
                }
            }
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<AddMeterInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterBandHeaders == null ? 0 : this._meterBandHeaders.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._meterName == null ? 0 : this._meterName.hashCode());
            result = 31 * result + (this._meterRef == null ? 0 : this._meterRef.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddMeterInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddMeterInput other = (AddMeterInput)obj;
            if (this._containerName == null ? other.getContainerName() != null : !this._containerName.equals(other.getContainerName())) {
                return false;
            }
            if (this._flags == null ? other.getFlags() != null : !this._flags.equals((Object)other.getFlags())) {
                return false;
            }
            if (this._meterBandHeaders == null ? other.getMeterBandHeaders() != null : !this._meterBandHeaders.equals(other.getMeterBandHeaders())) {
                return false;
            }
            if (this._meterId == null ? other.getMeterId() != null : !this._meterId.equals((Object)other.getMeterId())) {
                return false;
            }
            if (this._meterName == null ? other.getMeterName() != null : !this._meterName.equals(other.getMeterName())) {
                return false;
            }
            if (this._meterRef == null ? other.getMeterRef() != null : !this._meterRef.equals((Object)other.getMeterRef())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._barrier == null ? other.isBarrier() != null : !this._barrier.equals(other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddMeterInputImpl otherImpl = (AddMeterInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AddMeterInput>>, Augmentation<AddMeterInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AddMeterInput [");
            boolean first = true;
            if (this._containerName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_containerName=");
                builder.append(this._containerName);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._meterBandHeaders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterBandHeaders=");
                builder.append(this._meterBandHeaders);
            }
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (this._meterName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterName=");
                builder.append(this._meterName);
            }
            if (this._meterRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterRef=");
                builder.append(this._meterRef);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._barrier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

