/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateGroupInputBuilder
implements Builder<UpdateGroupInput> {
    private GroupRef _groupRef;
    private NodeRef _node;
    private OriginalGroup _originalGroup;
    private Uri _transactionUri;
    private UpdatedGroup _updatedGroup;
    Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = Collections.emptyMap();

    public UpdateGroupInputBuilder() {
    }

    public UpdateGroupInputBuilder(GroupUpdate arg) {
        this._originalGroup = arg.getOriginalGroup();
        this._updatedGroup = arg.getUpdatedGroup();
        this._node = arg.getNode();
    }

    public UpdateGroupInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateGroupInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateGroupInputBuilder(UpdateGroupInput base) {
        AugmentationHolder casted;
        this._groupRef = base.getGroupRef();
        this._node = base.getNode();
        this._originalGroup = base.getOriginalGroup();
        this._transactionUri = base.getTransactionUri();
        this._updatedGroup = base.getUpdatedGroup();
        if (base instanceof UpdateGroupInputImpl) {
            UpdateGroupInputImpl impl = (UpdateGroupInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GroupUpdate) {
            this._originalGroup = ((GroupUpdate)arg).getOriginalGroup();
            this._updatedGroup = ((GroupUpdate)arg).getUpdatedGroup();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalGroup getOriginalGroup() {
        return this._originalGroup;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedGroup getUpdatedGroup() {
        return this._updatedGroup;
    }

    public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateGroupInputBuilder setGroupRef(GroupRef value) {
        if (value != null) {
            // empty if block
        }
        this._groupRef = value;
        return this;
    }

    public UpdateGroupInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public UpdateGroupInputBuilder setOriginalGroup(OriginalGroup value) {
        this._originalGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public UpdateGroupInputBuilder setUpdatedGroup(UpdatedGroup value) {
        this._updatedGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder addAugmentation(Class<? extends Augmentation<UpdateGroupInput>> augmentationType, Augmentation<UpdateGroupInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateGroupInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateGroupInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateGroupInput build() {
        return new UpdateGroupInputImpl(this);
    }

    private static final class UpdateGroupInputImpl
    implements UpdateGroupInput {
        private final GroupRef _groupRef;
        private final NodeRef _node;
        private final OriginalGroup _originalGroup;
        private final Uri _transactionUri;
        private final UpdatedGroup _updatedGroup;
        private Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateGroupInput> getImplementedInterface() {
            return UpdateGroupInput.class;
        }

        private UpdateGroupInputImpl(UpdateGroupInputBuilder base) {
            this._groupRef = base.getGroupRef();
            this._node = base.getNode();
            this._originalGroup = base.getOriginalGroup();
            this._transactionUri = base.getTransactionUri();
            this._updatedGroup = base.getUpdatedGroup();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(base.augmentation);
                }
            }
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalGroup getOriginalGroup() {
            return this._originalGroup;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedGroup getUpdatedGroup() {
            return this._updatedGroup;
        }

        public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._groupRef == null ? 0 : this._groupRef.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._originalGroup == null ? 0 : this._originalGroup.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._updatedGroup == null ? 0 : this._updatedGroup.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateGroupInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateGroupInput other = (UpdateGroupInput)obj;
            if (this._groupRef == null ? other.getGroupRef() != null : !this._groupRef.equals((Object)other.getGroupRef())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._originalGroup == null ? other.getOriginalGroup() != null : !this._originalGroup.equals(other.getOriginalGroup())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._updatedGroup == null ? other.getUpdatedGroup() != null : !this._updatedGroup.equals(other.getUpdatedGroup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateGroupInputImpl otherImpl = (UpdateGroupInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdateGroupInput [");
            boolean first = true;
            if (this._groupRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupRef=");
                builder.append(this._groupRef);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._originalGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_originalGroup=");
                builder.append(this._originalGroup);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._updatedGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_updatedGroup=");
                builder.append(this._updatedGroup);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

