/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddGroupInputBuilder
implements Builder<AddGroupInput> {
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupRef _groupRef;
    private GroupTypes _groupType;
    private NodeRef _node;
    private Uri _transactionUri;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>> augmentation = Collections.emptyMap();

    public AddGroupInputBuilder() {
    }

    public AddGroupInputBuilder(Group arg) {
        this._groupType = arg.getGroupType();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._containerName = arg.getContainerName();
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
    }

    public AddGroupInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public AddGroupInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public AddGroupInputBuilder(AddGroupInput base) {
        AugmentationHolder casted;
        this._buckets = base.getBuckets();
        this._containerName = base.getContainerName();
        this._groupId = base.getGroupId();
        this._groupName = base.getGroupName();
        this._groupRef = base.getGroupRef();
        this._groupType = base.getGroupType();
        this._node = base.getNode();
        this._transactionUri = base.getTransactionUri();
        this._barrier = base.isBarrier();
        if (base instanceof AddGroupInputImpl) {
            AddGroupInputImpl impl = (AddGroupInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Group) {
            this._groupType = ((Group)arg).getGroupType();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._containerName = ((Group)arg).getContainerName();
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<AddGroupInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddGroupInputBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public AddGroupInputBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    private static void checkGroupIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public AddGroupInputBuilder setGroupId(GroupId value) {
        if (value != null) {
            AddGroupInputBuilder.checkGroupIdRange(value.getValue());
        }
        this._groupId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _groupId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public AddGroupInputBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public AddGroupInputBuilder setGroupRef(GroupRef value) {
        if (value != null) {
            // empty if block
        }
        this._groupRef = value;
        return this;
    }

    public AddGroupInputBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public AddGroupInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public AddGroupInputBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public AddGroupInputBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public AddGroupInputBuilder addAugmentation(Class<? extends Augmentation<AddGroupInput>> augmentationType, Augmentation<AddGroupInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AddGroupInputBuilder removeAugmentation(Class<? extends Augmentation<AddGroupInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AddGroupInput build() {
        return new AddGroupInputImpl(this);
    }

    private static final class AddGroupInputImpl
    implements AddGroupInput {
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupRef _groupRef;
        private final GroupTypes _groupType;
        private final NodeRef _node;
        private final Uri _transactionUri;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AddGroupInput> getImplementedInterface() {
            return AddGroupInput.class;
        }

        private AddGroupInputImpl(AddGroupInputBuilder base) {
            this._buckets = base.getBuckets();
            this._containerName = base.getContainerName();
            this._groupId = base.getGroupId();
            this._groupName = base.getGroupName();
            this._groupRef = base.getGroupRef();
            this._groupType = base.getGroupType();
            this._node = base.getNode();
            this._transactionUri = base.getTransactionUri();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>>(base.augmentation);
                }
            }
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<AddGroupInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._buckets == null ? 0 : this._buckets.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._groupName == null ? 0 : this._groupName.hashCode());
            result = 31 * result + (this._groupRef == null ? 0 : this._groupRef.hashCode());
            result = 31 * result + (this._groupType == null ? 0 : this._groupType.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddGroupInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddGroupInput other = (AddGroupInput)obj;
            if (this._buckets == null ? other.getBuckets() != null : !this._buckets.equals(other.getBuckets())) {
                return false;
            }
            if (this._containerName == null ? other.getContainerName() != null : !this._containerName.equals(other.getContainerName())) {
                return false;
            }
            if (this._groupId == null ? other.getGroupId() != null : !this._groupId.equals((Object)other.getGroupId())) {
                return false;
            }
            if (this._groupName == null ? other.getGroupName() != null : !this._groupName.equals(other.getGroupName())) {
                return false;
            }
            if (this._groupRef == null ? other.getGroupRef() != null : !this._groupRef.equals((Object)other.getGroupRef())) {
                return false;
            }
            if (this._groupType == null ? other.getGroupType() != null : !this._groupType.equals((Object)other.getGroupType())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._barrier == null ? other.isBarrier() != null : !this._barrier.equals(other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddGroupInputImpl otherImpl = (AddGroupInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AddGroupInput>>, Augmentation<AddGroupInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AddGroupInput [");
            boolean first = true;
            if (this._buckets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_buckets=");
                builder.append(this._buckets);
            }
            if (this._containerName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_containerName=");
                builder.append(this._containerName);
            }
            if (this._groupId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupId=");
                builder.append(this._groupId);
            }
            if (this._groupName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupName=");
                builder.append(this._groupName);
            }
            if (this._groupRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupRef=");
                builder.append(this._groupRef);
            }
            if (this._groupType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupType=");
                builder.append(this._groupType);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._barrier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

