/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransactionId
implements Serializable {
    private static final long serialVersionUID = 7429518709941905255L;
    private final BigInteger _value;
    private static final Range<BigInteger>[] CHECK_VALUERANGE_RANGES;

    private static void check_valueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECK_VALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECK_VALUERANGE_RANGES)));
    }

    @ConstructorProperties(value={"value"})
    public TransactionId(BigInteger _value) {
        if (_value != null) {
            TransactionId.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public TransactionId(TransactionId source) {
        this._value = source._value;
    }

    public static TransactionId getDefaultInstance(String defaultValue) {
        return new TransactionId(new BigInteger(defaultValue));
    }

    public BigInteger getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionId other = (TransactionId)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TransactionId.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    @Deprecated
    public static List<Range<BigInteger>> range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECK_VALUERANGE_RANGES = a;
    }
}

