/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdatedFlowBuilder
implements Builder<UpdatedFlow> {
    private Long _bufferId;
    private String _containerName;
    private FlowCookie _cookie;
    private FlowCookie _cookieMask;
    private FlowModFlags _flags;
    private String _flowName;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Instructions _instructions;
    private Match _match;
    private Long _outGroup;
    private BigInteger _outPort;
    private Integer _priority;
    private Short _tableId;
    private Boolean _barrier;
    private Boolean _installHw;
    private Boolean _strict;
    Map<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKCOOKIEMASKRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKOUTPORTRANGE_RANGES;

    public UpdatedFlowBuilder() {
    }

    public UpdatedFlowBuilder(Flow arg) {
        this._match = arg.getMatch();
        this._instructions = arg.getInstructions();
        this._containerName = arg.getContainerName();
        this._cookieMask = arg.getCookieMask();
        this._bufferId = arg.getBufferId();
        this._outPort = arg.getOutPort();
        this._outGroup = arg.getOutGroup();
        this._flags = arg.getFlags();
        this._flowName = arg.getFlowName();
        this._installHw = arg.isInstallHw();
        this._barrier = arg.isBarrier();
        this._strict = arg.isStrict();
        this._priority = arg.getPriority();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._cookie = arg.getCookie();
        this._tableId = arg.getTableId();
    }

    public UpdatedFlowBuilder(GenericFlowAttributes arg) {
        this._priority = arg.getPriority();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._cookie = arg.getCookie();
        this._tableId = arg.getTableId();
    }

    public UpdatedFlowBuilder(UpdatedFlow base) {
        AugmentationHolder casted;
        this._bufferId = base.getBufferId();
        this._containerName = base.getContainerName();
        this._cookie = base.getCookie();
        this._cookieMask = base.getCookieMask();
        this._flags = base.getFlags();
        this._flowName = base.getFlowName();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._instructions = base.getInstructions();
        this._match = base.getMatch();
        this._outGroup = base.getOutGroup();
        this._outPort = base.getOutPort();
        this._priority = base.getPriority();
        this._tableId = base.getTableId();
        this._barrier = base.isBarrier();
        this._installHw = base.isInstallHw();
        this._strict = base.isStrict();
        if (base instanceof UpdatedFlowImpl) {
            UpdatedFlowImpl impl = (UpdatedFlowImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GenericFlowAttributes) {
            this._priority = ((GenericFlowAttributes)arg).getPriority();
            this._idleTimeout = ((GenericFlowAttributes)arg).getIdleTimeout();
            this._hardTimeout = ((GenericFlowAttributes)arg).getHardTimeout();
            this._cookie = ((GenericFlowAttributes)arg).getCookie();
            this._tableId = ((GenericFlowAttributes)arg).getTableId();
            isValidArg = true;
        }
        if (arg instanceof Flow) {
            this._match = ((Flow)arg).getMatch();
            this._instructions = ((Flow)arg).getInstructions();
            this._containerName = ((Flow)arg).getContainerName();
            this._cookieMask = ((Flow)arg).getCookieMask();
            this._bufferId = ((Flow)arg).getBufferId();
            this._outPort = ((Flow)arg).getOutPort();
            this._outGroup = ((Flow)arg).getOutGroup();
            this._flags = ((Flow)arg).getFlags();
            this._flowName = ((Flow)arg).getFlowName();
            this._installHw = ((Flow)arg).isInstallHw();
            this._barrier = ((Flow)arg).isBarrier();
            this._strict = ((Flow)arg).isStrict();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow] \nbut was: " + arg);
        }
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public FlowCookie getCookie() {
        return this._cookie;
    }

    public FlowCookie getCookieMask() {
        return this._cookieMask;
    }

    public FlowModFlags getFlags() {
        return this._flags;
    }

    public String getFlowName() {
        return this._flowName;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Instructions getInstructions() {
        return this._instructions;
    }

    public Match getMatch() {
        return this._match;
    }

    public Long getOutGroup() {
        return this._outGroup;
    }

    public BigInteger getOutPort() {
        return this._outPort;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public Boolean isInstallHw() {
        return this._installHw;
    }

    public Boolean isStrict() {
        return this._strict;
    }

    public <E extends Augmentation<UpdatedFlow>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UpdatedFlowBuilder setBufferId(Long value) {
        if (value != null) {
            UpdatedFlowBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _bufferId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public UpdatedFlowBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public UpdatedFlowBuilder setCookie(FlowCookie value) {
        if (value != null) {
            UpdatedFlowBuilder.checkCookieRange(value.getValue());
        }
        this._cookie = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _cookie_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    private static void checkCookieMaskRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIEMASKRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIEMASKRANGE_RANGES)));
    }

    public UpdatedFlowBuilder setCookieMask(FlowCookie value) {
        if (value != null) {
            UpdatedFlowBuilder.checkCookieMaskRange(value.getValue());
        }
        this._cookieMask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _cookieMask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public UpdatedFlowBuilder setFlags(FlowModFlags value) {
        this._flags = value;
        return this;
    }

    public UpdatedFlowBuilder setFlowName(String value) {
        this._flowName = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public UpdatedFlowBuilder setHardTimeout(Integer value) {
        if (value != null) {
            UpdatedFlowBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _hardTimeout_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public UpdatedFlowBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            UpdatedFlowBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _idleTimeout_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public UpdatedFlowBuilder setInstructions(Instructions value) {
        this._instructions = value;
        return this;
    }

    public UpdatedFlowBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    private static void checkOutGroupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UpdatedFlowBuilder setOutGroup(Long value) {
        if (value != null) {
            UpdatedFlowBuilder.checkOutGroupRange(value);
        }
        this._outGroup = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _outGroup_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkOutPortRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKOUTPORTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKOUTPORTRANGE_RANGES)));
    }

    public UpdatedFlowBuilder setOutPort(BigInteger value) {
        if (value != null) {
            UpdatedFlowBuilder.checkOutPortRange(value);
        }
        this._outPort = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _outPort_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public UpdatedFlowBuilder setPriority(Integer value) {
        if (value != null) {
            UpdatedFlowBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _priority_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public UpdatedFlowBuilder setTableId(Short value) {
        if (value != null) {
            UpdatedFlowBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tableId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public UpdatedFlowBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public UpdatedFlowBuilder setInstallHw(Boolean value) {
        this._installHw = value;
        return this;
    }

    public UpdatedFlowBuilder setStrict(Boolean value) {
        this._strict = value;
        return this;
    }

    public UpdatedFlowBuilder addAugmentation(Class<? extends Augmentation<UpdatedFlow>> augmentationType, Augmentation<UpdatedFlow> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdatedFlowBuilder removeAugmentation(Class<? extends Augmentation<UpdatedFlow>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdatedFlow build() {
        return new UpdatedFlowImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIEMASKRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKOUTPORTRANGE_RANGES = a;
    }

    private static final class UpdatedFlowImpl
    implements UpdatedFlow {
        private final Long _bufferId;
        private final String _containerName;
        private final FlowCookie _cookie;
        private final FlowCookie _cookieMask;
        private final FlowModFlags _flags;
        private final String _flowName;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Instructions _instructions;
        private final Match _match;
        private final Long _outGroup;
        private final BigInteger _outPort;
        private final Integer _priority;
        private final Short _tableId;
        private final Boolean _barrier;
        private final Boolean _installHw;
        private final Boolean _strict;
        private Map<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdatedFlow> getImplementedInterface() {
            return UpdatedFlow.class;
        }

        private UpdatedFlowImpl(UpdatedFlowBuilder base) {
            this._bufferId = base.getBufferId();
            this._containerName = base.getContainerName();
            this._cookie = base.getCookie();
            this._cookieMask = base.getCookieMask();
            this._flags = base.getFlags();
            this._flowName = base.getFlowName();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._instructions = base.getInstructions();
            this._match = base.getMatch();
            this._outGroup = base.getOutGroup();
            this._outPort = base.getOutPort();
            this._priority = base.getPriority();
            this._tableId = base.getTableId();
            this._barrier = base.isBarrier();
            this._installHw = base.isInstallHw();
            this._strict = base.isStrict();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>>(base.augmentation);
                }
            }
        }

        public Long getBufferId() {
            return this._bufferId;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public FlowCookie getCookie() {
            return this._cookie;
        }

        public FlowCookie getCookieMask() {
            return this._cookieMask;
        }

        public FlowModFlags getFlags() {
            return this._flags;
        }

        public String getFlowName() {
            return this._flowName;
        }

        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        public Instructions getInstructions() {
            return this._instructions;
        }

        public Match getMatch() {
            return this._match;
        }

        public Long getOutGroup() {
            return this._outGroup;
        }

        public BigInteger getOutPort() {
            return this._outPort;
        }

        public Integer getPriority() {
            return this._priority;
        }

        public Short getTableId() {
            return this._tableId;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public Boolean isInstallHw() {
            return this._installHw;
        }

        public Boolean isStrict() {
            return this._strict;
        }

        public <E extends Augmentation<UpdatedFlow>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bufferId == null ? 0 : this._bufferId.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._cookieMask == null ? 0 : this._cookieMask.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._flowName == null ? 0 : this._flowName.hashCode());
            result = 31 * result + (this._hardTimeout == null ? 0 : this._hardTimeout.hashCode());
            result = 31 * result + (this._idleTimeout == null ? 0 : this._idleTimeout.hashCode());
            result = 31 * result + (this._instructions == null ? 0 : this._instructions.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._outGroup == null ? 0 : this._outGroup.hashCode());
            result = 31 * result + (this._outPort == null ? 0 : this._outPort.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._installHw == null ? 0 : this._installHw.hashCode());
            result = 31 * result + (this._strict == null ? 0 : this._strict.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdatedFlow.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdatedFlow other = (UpdatedFlow)obj;
            if (this._bufferId == null ? other.getBufferId() != null : !this._bufferId.equals(other.getBufferId())) {
                return false;
            }
            if (this._containerName == null ? other.getContainerName() != null : !this._containerName.equals(other.getContainerName())) {
                return false;
            }
            if (this._cookie == null ? other.getCookie() != null : !this._cookie.equals((Object)other.getCookie())) {
                return false;
            }
            if (this._cookieMask == null ? other.getCookieMask() != null : !this._cookieMask.equals((Object)other.getCookieMask())) {
                return false;
            }
            if (this._flags == null ? other.getFlags() != null : !this._flags.equals((Object)other.getFlags())) {
                return false;
            }
            if (this._flowName == null ? other.getFlowName() != null : !this._flowName.equals(other.getFlowName())) {
                return false;
            }
            if (this._hardTimeout == null ? other.getHardTimeout() != null : !this._hardTimeout.equals(other.getHardTimeout())) {
                return false;
            }
            if (this._idleTimeout == null ? other.getIdleTimeout() != null : !this._idleTimeout.equals(other.getIdleTimeout())) {
                return false;
            }
            if (this._instructions == null ? other.getInstructions() != null : !this._instructions.equals(other.getInstructions())) {
                return false;
            }
            if (this._match == null ? other.getMatch() != null : !this._match.equals(other.getMatch())) {
                return false;
            }
            if (this._outGroup == null ? other.getOutGroup() != null : !this._outGroup.equals(other.getOutGroup())) {
                return false;
            }
            if (this._outPort == null ? other.getOutPort() != null : !this._outPort.equals(other.getOutPort())) {
                return false;
            }
            if (this._priority == null ? other.getPriority() != null : !this._priority.equals(other.getPriority())) {
                return false;
            }
            if (this._tableId == null ? other.getTableId() != null : !this._tableId.equals(other.getTableId())) {
                return false;
            }
            if (this._barrier == null ? other.isBarrier() != null : !this._barrier.equals(other.isBarrier())) {
                return false;
            }
            if (this._installHw == null ? other.isInstallHw() != null : !this._installHw.equals(other.isInstallHw())) {
                return false;
            }
            if (this._strict == null ? other.isStrict() != null : !this._strict.equals(other.isStrict())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdatedFlowImpl otherImpl = (UpdatedFlowImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdatedFlow>>, Augmentation<UpdatedFlow>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdatedFlow [");
            boolean first = true;
            if (this._bufferId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bufferId=");
                builder.append(this._bufferId);
            }
            if (this._containerName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_containerName=");
                builder.append(this._containerName);
            }
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._cookieMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookieMask=");
                builder.append(this._cookieMask);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._flowName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowName=");
                builder.append(this._flowName);
            }
            if (this._hardTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
            }
            if (this._idleTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
            }
            if (this._instructions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instructions=");
                builder.append(this._instructions);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._outGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outGroup=");
                builder.append(this._outGroup);
            }
            if (this._outPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outPort=");
                builder.append(this._outPort);
            }
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._barrier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            if (this._installHw != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_installHw=");
                builder.append(this._installHw);
            }
            if (this._strict != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_strict=");
                builder.append(this._strict);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

