/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.OriginalFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateFlowInputBuilder
implements Builder<UpdateFlowInput> {
    private FlowRef _flowRef;
    private NodeRef _node;
    private OriginalFlow _originalFlow;
    private Uri _transactionUri;
    private UpdatedFlow _updatedFlow;
    Map<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>> augmentation = Collections.emptyMap();

    public UpdateFlowInputBuilder() {
    }

    public UpdateFlowInputBuilder(FlowUpdate arg) {
        this._originalFlow = arg.getOriginalFlow();
        this._updatedFlow = arg.getUpdatedFlow();
        this._node = arg.getNode();
    }

    public UpdateFlowInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateFlowInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateFlowInputBuilder(UpdateFlowInput base) {
        AugmentationHolder casted;
        this._flowRef = base.getFlowRef();
        this._node = base.getNode();
        this._originalFlow = base.getOriginalFlow();
        this._transactionUri = base.getTransactionUri();
        this._updatedFlow = base.getUpdatedFlow();
        if (base instanceof UpdateFlowInputImpl) {
            UpdateFlowInputImpl impl = (UpdateFlowInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FlowUpdate) {
            this._originalFlow = ((FlowUpdate)arg).getOriginalFlow();
            this._updatedFlow = ((FlowUpdate)arg).getUpdatedFlow();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public FlowRef getFlowRef() {
        return this._flowRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalFlow getOriginalFlow() {
        return this._originalFlow;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedFlow getUpdatedFlow() {
        return this._updatedFlow;
    }

    public <E extends Augmentation<UpdateFlowInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateFlowInputBuilder setFlowRef(FlowRef value) {
        if (value != null) {
            // empty if block
        }
        this._flowRef = value;
        return this;
    }

    public UpdateFlowInputBuilder setNode(NodeRef value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public UpdateFlowInputBuilder setOriginalFlow(OriginalFlow value) {
        this._originalFlow = value;
        return this;
    }

    public UpdateFlowInputBuilder setTransactionUri(Uri value) {
        if (value != null) {
            // empty if block
        }
        this._transactionUri = value;
        return this;
    }

    public UpdateFlowInputBuilder setUpdatedFlow(UpdatedFlow value) {
        this._updatedFlow = value;
        return this;
    }

    public UpdateFlowInputBuilder addAugmentation(Class<? extends Augmentation<UpdateFlowInput>> augmentationType, Augmentation<UpdateFlowInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateFlowInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateFlowInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateFlowInput build() {
        return new UpdateFlowInputImpl(this);
    }

    private static final class UpdateFlowInputImpl
    implements UpdateFlowInput {
        private final FlowRef _flowRef;
        private final NodeRef _node;
        private final OriginalFlow _originalFlow;
        private final Uri _transactionUri;
        private final UpdatedFlow _updatedFlow;
        private Map<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateFlowInput> getImplementedInterface() {
            return UpdateFlowInput.class;
        }

        private UpdateFlowInputImpl(UpdateFlowInputBuilder base) {
            this._flowRef = base.getFlowRef();
            this._node = base.getNode();
            this._originalFlow = base.getOriginalFlow();
            this._transactionUri = base.getTransactionUri();
            this._updatedFlow = base.getUpdatedFlow();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>>(base.augmentation);
                }
            }
        }

        @Override
        public FlowRef getFlowRef() {
            return this._flowRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalFlow getOriginalFlow() {
            return this._originalFlow;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedFlow getUpdatedFlow() {
            return this._updatedFlow;
        }

        public <E extends Augmentation<UpdateFlowInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flowRef == null ? 0 : this._flowRef.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._originalFlow == null ? 0 : this._originalFlow.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._updatedFlow == null ? 0 : this._updatedFlow.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateFlowInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateFlowInput other = (UpdateFlowInput)obj;
            if (this._flowRef == null ? other.getFlowRef() != null : !this._flowRef.equals((Object)other.getFlowRef())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._originalFlow == null ? other.getOriginalFlow() != null : !this._originalFlow.equals(other.getOriginalFlow())) {
                return false;
            }
            if (this._transactionUri == null ? other.getTransactionUri() != null : !this._transactionUri.equals((Object)other.getTransactionUri())) {
                return false;
            }
            if (this._updatedFlow == null ? other.getUpdatedFlow() != null : !this._updatedFlow.equals(other.getUpdatedFlow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateFlowInputImpl otherImpl = (UpdateFlowInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateFlowInput>>, Augmentation<UpdateFlowInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UpdateFlowInput [");
            boolean first = true;
            if (this._flowRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowRef=");
                builder.append(this._flowRef);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._originalFlow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_originalFlow=");
                builder.append(this._originalFlow);
            }
            if (this._transactionUri != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
            }
            if (this._updatedFlow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_updatedFlow=");
                builder.append(this._updatedFlow);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

