/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeatures;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableBuilder
implements Builder<Table> {
    private List<Flow> _flow;
    private Short _id;
    private TableKey _key;
    private List<TableFeatures> _tableFeatures;
    Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = Collections.emptyMap();

    public TableBuilder() {
    }

    public TableBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures arg) {
        this._tableFeatures = arg.getTableFeatures();
    }

    public TableBuilder(Table base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TableKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._flow = base.getFlow();
        this._tableFeatures = base.getTableFeatures();
        if (base instanceof TableImpl) {
            TableImpl impl = (TableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures) {
            this._tableFeatures = ((org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures)arg).getTableFeatures();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures] \nbut was: " + arg);
        }
    }

    public List<Flow> getFlow() {
        return this._flow;
    }

    public Short getId() {
        return this._id;
    }

    public TableKey getKey() {
        return this._key;
    }

    public List<TableFeatures> getTableFeatures() {
        return this._tableFeatures;
    }

    public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableBuilder setFlow(List<Flow> value) {
        this._flow = value;
        return this;
    }

    private static void checkIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableBuilder setId(Short value) {
        if (value != null) {
            TableBuilder.checkIdRange(value);
        }
        this._id = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _id_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public TableBuilder setKey(TableKey value) {
        this._key = value;
        return this;
    }

    public TableBuilder setTableFeatures(List<TableFeatures> value) {
        this._tableFeatures = value;
        return this;
    }

    public TableBuilder addAugmentation(Class<? extends Augmentation<Table>> augmentationType, Augmentation<Table> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableBuilder removeAugmentation(Class<? extends Augmentation<Table>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Table build() {
        return new TableImpl(this);
    }

    private static final class TableImpl
    implements Table {
        private final List<Flow> _flow;
        private final Short _id;
        private final TableKey _key;
        private final List<TableFeatures> _tableFeatures;
        private Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Table> getImplementedInterface() {
            return Table.class;
        }

        private TableImpl(TableBuilder base) {
            if (base.getKey() == null) {
                this._key = new TableKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._flow = base.getFlow();
            this._tableFeatures = base.getTableFeatures();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Table>>, Augmentation<Table>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Flow> getFlow() {
            return this._flow;
        }

        @Override
        public Short getId() {
            return this._id;
        }

        @Override
        public TableKey getKey() {
            return this._key;
        }

        public List<TableFeatures> getTableFeatures() {
            return this._tableFeatures;
        }

        public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flow == null ? 0 : this._flow.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._tableFeatures == null ? 0 : this._tableFeatures.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Table.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Table other = (Table)obj;
            if (this._flow == null ? other.getFlow() != null : !this._flow.equals(other.getFlow())) {
                return false;
            }
            if (this._id == null ? other.getId() != null : !this._id.equals(other.getId())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._tableFeatures == null ? other.getTableFeatures() != null : !this._tableFeatures.equals(other.getTableFeatures())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableImpl otherImpl = (TableImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Table>>, Augmentation<Table>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Table [");
            boolean first = true;
            if (this._flow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flow=");
                builder.append(this._flow);
            }
            if (this._id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(this._id);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._tableFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableFeatures=");
                builder.append(this._tableFeatures);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

