/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.queue;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.queue.Properties;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PropertiesBuilder
implements Builder<Properties> {
    private Long _maximumRate;
    private Long _minimumRate;
    Map<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> augmentation = Collections.emptyMap();

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Properties base) {
        AugmentationHolder casted;
        this._maximumRate = base.getMaximumRate();
        this._minimumRate = base.getMinimumRate();
        if (base instanceof PropertiesImpl) {
            PropertiesImpl impl = (PropertiesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>(casted.augmentations());
        }
    }

    public Long getMaximumRate() {
        return this._maximumRate;
    }

    public Long getMinimumRate() {
        return this._minimumRate;
    }

    public <E extends Augmentation<Properties>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaximumRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PropertiesBuilder setMaximumRate(Long value) {
        if (value != null) {
            PropertiesBuilder.checkMaximumRateRange(value);
        }
        this._maximumRate = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maximumRate_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkMinimumRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PropertiesBuilder setMinimumRate(Long value) {
        if (value != null) {
            PropertiesBuilder.checkMinimumRateRange(value);
        }
        this._minimumRate = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _minimumRate_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public PropertiesBuilder addAugmentation(Class<? extends Augmentation<Properties>> augmentationType, Augmentation<Properties> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PropertiesBuilder removeAugmentation(Class<? extends Augmentation<Properties>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Properties build() {
        return new PropertiesImpl(this);
    }

    private static final class PropertiesImpl
    implements Properties {
        private final Long _maximumRate;
        private final Long _minimumRate;
        private Map<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Properties> getImplementedInterface() {
            return Properties.class;
        }

        private PropertiesImpl(PropertiesBuilder base) {
            this._maximumRate = base.getMaximumRate();
            this._minimumRate = base.getMinimumRate();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getMaximumRate() {
            return this._maximumRate;
        }

        @Override
        public Long getMinimumRate() {
            return this._minimumRate;
        }

        public <E extends Augmentation<Properties>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maximumRate == null ? 0 : this._maximumRate.hashCode());
            result = 31 * result + (this._minimumRate == null ? 0 : this._minimumRate.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Properties.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Properties other = (Properties)obj;
            if (this._maximumRate == null ? other.getMaximumRate() != null : !this._maximumRate.equals(other.getMaximumRate())) {
                return false;
            }
            if (this._minimumRate == null ? other.getMinimumRate() != null : !this._minimumRate.equals(other.getMinimumRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PropertiesImpl otherImpl = (PropertiesImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Properties [");
            boolean first = true;
            if (this._maximumRate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maximumRate=");
                builder.append(this._maximumRate);
            }
            if (this._minimumRate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minimumRate=");
                builder.append(this._minimumRate);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

