/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMapKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowHashIdMapBuilder
implements Builder<FlowHashIdMap> {
    private FlowId _flowId;
    private String _hash;
    private FlowHashIdMapKey _key;
    Map<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> augmentation = Collections.emptyMap();

    public FlowHashIdMapBuilder() {
    }

    public FlowHashIdMapBuilder(FlowHashIdMap base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlowHashIdMapKey(base.getHash());
            this._hash = base.getHash();
        } else {
            this._key = base.getKey();
            this._hash = this._key.getHash();
        }
        this._flowId = base.getFlowId();
        if (base instanceof FlowHashIdMapImpl) {
            FlowHashIdMapImpl impl = (FlowHashIdMapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(casted.augmentations());
        }
    }

    public FlowId getFlowId() {
        return this._flowId;
    }

    public String getHash() {
        return this._hash;
    }

    public FlowHashIdMapKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<FlowHashIdMap>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowHashIdMapBuilder setFlowId(FlowId value) {
        if (value != null) {
            // empty if block
        }
        this._flowId = value;
        return this;
    }

    public FlowHashIdMapBuilder setHash(String value) {
        this._hash = value;
        return this;
    }

    public FlowHashIdMapBuilder setKey(FlowHashIdMapKey value) {
        this._key = value;
        return this;
    }

    public FlowHashIdMapBuilder addAugmentation(Class<? extends Augmentation<FlowHashIdMap>> augmentationType, Augmentation<FlowHashIdMap> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowHashIdMapBuilder removeAugmentation(Class<? extends Augmentation<FlowHashIdMap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowHashIdMap build() {
        return new FlowHashIdMapImpl(this);
    }

    private static final class FlowHashIdMapImpl
    implements FlowHashIdMap {
        private final FlowId _flowId;
        private final String _hash;
        private final FlowHashIdMapKey _key;
        private Map<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowHashIdMap> getImplementedInterface() {
            return FlowHashIdMap.class;
        }

        private FlowHashIdMapImpl(FlowHashIdMapBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlowHashIdMapKey(base.getHash());
                this._hash = base.getHash();
            } else {
                this._key = base.getKey();
                this._hash = this._key.getHash();
            }
            this._flowId = base.getFlowId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(base.augmentation);
                }
            }
        }

        @Override
        public FlowId getFlowId() {
            return this._flowId;
        }

        @Override
        public String getHash() {
            return this._hash;
        }

        @Override
        public FlowHashIdMapKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<FlowHashIdMap>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flowId == null ? 0 : this._flowId.hashCode());
            result = 31 * result + (this._hash == null ? 0 : this._hash.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowHashIdMap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowHashIdMap other = (FlowHashIdMap)obj;
            if (this._flowId == null ? other.getFlowId() != null : !this._flowId.equals(other.getFlowId())) {
                return false;
            }
            if (this._hash == null ? other.getHash() != null : !this._hash.equals(other.getHash())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowHashIdMapImpl otherImpl = (FlowHashIdMapImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FlowHashIdMap [");
            boolean first = true;
            if (this._flowId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowId=");
                builder.append(this._flowId);
            }
            if (this._hash != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hash=");
                builder.append(this._hash);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

