/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBuilder
implements Builder<Meter> {
    private String _containerName;
    private MeterFlags _flags;
    private MeterKey _key;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = Collections.emptyMap();

    public MeterBuilder() {
    }

    public MeterBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter arg) {
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._barrier = arg.isBarrier();
        this._meterName = arg.getMeterName();
        this._containerName = arg.getContainerName();
        this._meterBandHeaders = arg.getMeterBandHeaders();
    }

    public MeterBuilder(Meter base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new MeterKey(base.getMeterId());
            this._meterId = base.getMeterId();
        } else {
            this._key = base.getKey();
            this._meterId = this._key.getMeterId();
        }
        this._containerName = base.getContainerName();
        this._flags = base.getFlags();
        this._meterBandHeaders = base.getMeterBandHeaders();
        this._meterName = base.getMeterName();
        this._barrier = base.isBarrier();
        if (base instanceof MeterImpl) {
            MeterImpl impl = (MeterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter) {
            this._flags = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getFlags();
            this._meterId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterId();
            this._barrier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).isBarrier();
            this._meterName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterName();
            this._containerName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getContainerName();
            this._meterBandHeaders = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterBandHeaders();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter] \nbut was: " + arg);
        }
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterKey getKey() {
        return this._key;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public MeterBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterBuilder setKey(MeterKey value) {
        this._key = value;
        return this;
    }

    public MeterBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    private static void checkMeterIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterBuilder setMeterId(MeterId value) {
        if (value != null) {
            MeterBuilder.checkMeterIdRange(value.getValue());
        }
        this._meterId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _meterId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public MeterBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public MeterBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public MeterBuilder addAugmentation(Class<? extends Augmentation<Meter>> augmentationType, Augmentation<Meter> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBuilder removeAugmentation(Class<? extends Augmentation<Meter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Meter build() {
        return new MeterImpl(this);
    }

    private static final class MeterImpl
    implements Meter {
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterKey _key;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Meter> getImplementedInterface() {
            return Meter.class;
        }

        private MeterImpl(MeterBuilder base) {
            if (base.getKey() == null) {
                this._key = new MeterKey(base.getMeterId());
                this._meterId = base.getMeterId();
            } else {
                this._key = base.getKey();
                this._meterId = this._key.getMeterId();
            }
            this._containerName = base.getContainerName();
            this._flags = base.getFlags();
            this._meterBandHeaders = base.getMeterBandHeaders();
            this._meterName = base.getMeterName();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(base.augmentation);
                }
            }
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public MeterKey getKey() {
            return this._key;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._meterBandHeaders == null ? 0 : this._meterBandHeaders.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._meterName == null ? 0 : this._meterName.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Meter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Meter other = (Meter)obj;
            if (this._containerName == null ? other.getContainerName() != null : !this._containerName.equals(other.getContainerName())) {
                return false;
            }
            if (this._flags == null ? other.getFlags() != null : !this._flags.equals((Object)other.getFlags())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._meterBandHeaders == null ? other.getMeterBandHeaders() != null : !this._meterBandHeaders.equals(other.getMeterBandHeaders())) {
                return false;
            }
            if (this._meterId == null ? other.getMeterId() != null : !this._meterId.equals((Object)other.getMeterId())) {
                return false;
            }
            if (this._meterName == null ? other.getMeterName() != null : !this._meterName.equals(other.getMeterName())) {
                return false;
            }
            if (this._barrier == null ? other.isBarrier() != null : !this._barrier.equals(other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterImpl otherImpl = (MeterImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Meter [");
            boolean first = true;
            if (this._containerName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_containerName=");
                builder.append(this._containerName);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._meterBandHeaders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterBandHeaders=");
                builder.append(this._meterBandHeaders);
            }
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (this._meterName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterName=");
                builder.append(this._meterName);
            }
            if (this._barrier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

