/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.instructions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.instructions.InstructionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.instructions.InstructionTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.SupportType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionTypeBuilder
implements Builder<InstructionType> {
    private String _instruction;
    private InstructionTypeKey _key;
    private SupportType _supportState;
    Map<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>> augmentation = Collections.emptyMap();

    public InstructionTypeBuilder() {
    }

    public InstructionTypeBuilder(Feature arg) {
        this._supportState = arg.getSupportState();
    }

    public InstructionTypeBuilder(InstructionType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InstructionTypeKey(base.getInstruction());
            this._instruction = base.getInstruction();
        } else {
            this._key = base.getKey();
            this._instruction = this._key.getInstruction();
        }
        this._supportState = base.getSupportState();
        if (base instanceof InstructionTypeImpl) {
            InstructionTypeImpl impl = (InstructionTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Feature) {
            this._supportState = ((Feature)arg).getSupportState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature] \nbut was: " + arg);
        }
    }

    public String getInstruction() {
        return this._instruction;
    }

    public InstructionTypeKey getKey() {
        return this._key;
    }

    public SupportType getSupportState() {
        return this._supportState;
    }

    public <E extends Augmentation<InstructionType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionTypeBuilder setInstruction(String value) {
        this._instruction = value;
        return this;
    }

    public InstructionTypeBuilder setKey(InstructionTypeKey value) {
        this._key = value;
        return this;
    }

    public InstructionTypeBuilder setSupportState(SupportType value) {
        this._supportState = value;
        return this;
    }

    public InstructionTypeBuilder addAugmentation(Class<? extends Augmentation<InstructionType>> augmentationType, Augmentation<InstructionType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstructionTypeBuilder removeAugmentation(Class<? extends Augmentation<InstructionType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InstructionType build() {
        return new InstructionTypeImpl(this);
    }

    private static final class InstructionTypeImpl
    implements InstructionType {
        private final String _instruction;
        private final InstructionTypeKey _key;
        private final SupportType _supportState;
        private Map<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InstructionType> getImplementedInterface() {
            return InstructionType.class;
        }

        private InstructionTypeImpl(InstructionTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new InstructionTypeKey(base.getInstruction());
                this._instruction = base.getInstruction();
            } else {
                this._key = base.getKey();
                this._instruction = this._key.getInstruction();
            }
            this._supportState = base.getSupportState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>>(base.augmentation);
                }
            }
        }

        @Override
        public String getInstruction() {
            return this._instruction;
        }

        @Override
        public InstructionTypeKey getKey() {
            return this._key;
        }

        @Override
        public SupportType getSupportState() {
            return this._supportState;
        }

        public <E extends Augmentation<InstructionType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._instruction == null ? 0 : this._instruction.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._supportState == null ? 0 : this._supportState.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InstructionType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InstructionType other = (InstructionType)obj;
            if (this._instruction == null ? other.getInstruction() != null : !this._instruction.equals(other.getInstruction())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._supportState == null ? other.getSupportState() != null : !this._supportState.equals((Object)other.getSupportState())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstructionTypeImpl otherImpl = (InstructionTypeImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InstructionType>>, Augmentation<InstructionType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("InstructionType [");
            boolean first = true;
            if (this._instruction != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instruction=");
                builder.append(this._instruction);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._supportState != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supportState=");
                builder.append(this._supportState);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

