/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions.ActionTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.SupportType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ActionTypeBuilder
implements Builder<ActionType> {
    private String _action;
    private ActionTypeKey _key;
    private SupportType _supportState;
    Map<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> augmentation = Collections.emptyMap();

    public ActionTypeBuilder() {
    }

    public ActionTypeBuilder(Feature arg) {
        this._supportState = arg.getSupportState();
    }

    public ActionTypeBuilder(ActionType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ActionTypeKey(base.getAction());
            this._action = base.getAction();
        } else {
            this._key = base.getKey();
            this._action = this._key.getAction();
        }
        this._supportState = base.getSupportState();
        if (base instanceof ActionTypeImpl) {
            ActionTypeImpl impl = (ActionTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Feature) {
            this._supportState = ((Feature)arg).getSupportState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature] \nbut was: " + arg);
        }
    }

    public String getAction() {
        return this._action;
    }

    public ActionTypeKey getKey() {
        return this._key;
    }

    public SupportType getSupportState() {
        return this._supportState;
    }

    public <E extends Augmentation<ActionType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ActionTypeBuilder setAction(String value) {
        this._action = value;
        return this;
    }

    public ActionTypeBuilder setKey(ActionTypeKey value) {
        this._key = value;
        return this;
    }

    public ActionTypeBuilder setSupportState(SupportType value) {
        this._supportState = value;
        return this;
    }

    public ActionTypeBuilder addAugmentation(Class<? extends Augmentation<ActionType>> augmentationType, Augmentation<ActionType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ActionTypeBuilder removeAugmentation(Class<? extends Augmentation<ActionType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ActionType build() {
        return new ActionTypeImpl(this);
    }

    private static final class ActionTypeImpl
    implements ActionType {
        private final String _action;
        private final ActionTypeKey _key;
        private final SupportType _supportState;
        private Map<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ActionType> getImplementedInterface() {
            return ActionType.class;
        }

        private ActionTypeImpl(ActionTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new ActionTypeKey(base.getAction());
                this._action = base.getAction();
            } else {
                this._key = base.getKey();
                this._action = this._key.getAction();
            }
            this._supportState = base.getSupportState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAction() {
            return this._action;
        }

        @Override
        public ActionTypeKey getKey() {
            return this._key;
        }

        @Override
        public SupportType getSupportState() {
            return this._supportState;
        }

        public <E extends Augmentation<ActionType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._action == null ? 0 : this._action.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._supportState == null ? 0 : this._supportState.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ActionType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ActionType other = (ActionType)obj;
            if (this._action == null ? other.getAction() != null : !this._action.equals(other.getAction())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._supportState == null ? other.getSupportState() != null : !this._supportState.equals((Object)other.getSupportState())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ActionTypeImpl otherImpl = (ActionTypeImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ActionType [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._supportState != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supportState=");
                builder.append(this._supportState);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

