/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FeatureCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SwitchFeaturesBuilder
implements Builder<SwitchFeatures> {
    private List<Class<? extends FeatureCapability>> _capabilities;
    private Long _maxBuffers;
    private Short _maxTables;
    Map<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> augmentation = Collections.emptyMap();

    public SwitchFeaturesBuilder() {
    }

    public SwitchFeaturesBuilder(SwitchFeatures base) {
        AugmentationHolder casted;
        this._capabilities = base.getCapabilities();
        this._maxBuffers = base.getMaxBuffers();
        this._maxTables = base.getMaxTables();
        if (base instanceof SwitchFeaturesImpl) {
            SwitchFeaturesImpl impl = (SwitchFeaturesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>(casted.augmentations());
        }
    }

    public List<Class<? extends FeatureCapability>> getCapabilities() {
        return this._capabilities;
    }

    public Long getMaxBuffers() {
        return this._maxBuffers;
    }

    public Short getMaxTables() {
        return this._maxTables;
    }

    public <E extends Augmentation<SwitchFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SwitchFeaturesBuilder setCapabilities(List<Class<? extends FeatureCapability>> value) {
        this._capabilities = value;
        return this;
    }

    private static void checkMaxBuffersRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SwitchFeaturesBuilder setMaxBuffers(Long value) {
        if (value != null) {
            SwitchFeaturesBuilder.checkMaxBuffersRange(value);
        }
        this._maxBuffers = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxBuffers_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkMaxTablesRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public SwitchFeaturesBuilder setMaxTables(Short value) {
        if (value != null) {
            SwitchFeaturesBuilder.checkMaxTablesRange(value);
        }
        this._maxTables = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxTables_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public SwitchFeaturesBuilder addAugmentation(Class<? extends Augmentation<SwitchFeatures>> augmentationType, Augmentation<SwitchFeatures> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SwitchFeaturesBuilder removeAugmentation(Class<? extends Augmentation<SwitchFeatures>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SwitchFeatures build() {
        return new SwitchFeaturesImpl(this);
    }

    private static final class SwitchFeaturesImpl
    implements SwitchFeatures {
        private final List<Class<? extends FeatureCapability>> _capabilities;
        private final Long _maxBuffers;
        private final Short _maxTables;
        private Map<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SwitchFeatures> getImplementedInterface() {
            return SwitchFeatures.class;
        }

        private SwitchFeaturesImpl(SwitchFeaturesBuilder base) {
            this._capabilities = base.getCapabilities();
            this._maxBuffers = base.getMaxBuffers();
            this._maxTables = base.getMaxTables();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Class<? extends FeatureCapability>> getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Long getMaxBuffers() {
            return this._maxBuffers;
        }

        @Override
        public Short getMaxTables() {
            return this._maxTables;
        }

        public <E extends Augmentation<SwitchFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
            result = 31 * result + (this._maxBuffers == null ? 0 : this._maxBuffers.hashCode());
            result = 31 * result + (this._maxTables == null ? 0 : this._maxTables.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SwitchFeatures.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SwitchFeatures other = (SwitchFeatures)obj;
            if (this._capabilities == null ? other.getCapabilities() != null : !this._capabilities.equals(other.getCapabilities())) {
                return false;
            }
            if (this._maxBuffers == null ? other.getMaxBuffers() != null : !this._maxBuffers.equals(other.getMaxBuffers())) {
                return false;
            }
            if (this._maxTables == null ? other.getMaxTables() != null : !this._maxTables.equals(other.getMaxTables())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SwitchFeaturesImpl otherImpl = (SwitchFeaturesImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SwitchFeatures [");
            boolean first = true;
            if (this._capabilities != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_capabilities=");
                builder.append(this._capabilities);
            }
            if (this._maxBuffers != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxBuffers=");
                builder.append(this._maxBuffers);
            }
            if (this._maxTables != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxTables=");
                builder.append(this._maxTables);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

