/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorUpdateFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortNumberUni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowCapableNodeConnectorUpdateFieldsBuilder
implements Builder<FlowCapableNodeConnectorUpdateFields> {
    private PortFeatures _advertisedFeatures;
    private PortConfig _configuration;
    private PortFeatures _currentFeature;
    private Long _currentSpeed;
    private MacAddress _hardwareAddress;
    private Long _maximumSpeed;
    private String _name;
    private PortFeatures _peerFeatures;
    private PortNumberUni _portNumber;
    private List<Queue> _queue;
    private State _state;
    private PortFeatures _supported;

    public FlowCapableNodeConnectorUpdateFieldsBuilder() {
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder(FlowCapablePort arg) {
        this._name = arg.getName();
        this._state = arg.getState();
        this._currentFeature = arg.getCurrentFeature();
        this._supported = arg.getSupported();
        this._peerFeatures = arg.getPeerFeatures();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._queue = arg.getQueue();
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder(CommonPort arg) {
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder(Queues arg) {
        this._queue = arg.getQueue();
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder(FlowCapableNodeConnectorUpdateFields base) {
        this._advertisedFeatures = base.getAdvertisedFeatures();
        this._configuration = base.getConfiguration();
        this._currentFeature = base.getCurrentFeature();
        this._currentSpeed = base.getCurrentSpeed();
        this._hardwareAddress = base.getHardwareAddress();
        this._maximumSpeed = base.getMaximumSpeed();
        this._name = base.getName();
        this._peerFeatures = base.getPeerFeatures();
        this._portNumber = base.getPortNumber();
        this._queue = base.getQueue();
        this._state = base.getState();
        this._supported = base.getSupported();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonPort) {
            this._portNumber = ((CommonPort)arg).getPortNumber();
            this._hardwareAddress = ((CommonPort)arg).getHardwareAddress();
            this._configuration = ((CommonPort)arg).getConfiguration();
            this._advertisedFeatures = ((CommonPort)arg).getAdvertisedFeatures();
            isValidArg = true;
        }
        if (arg instanceof FlowCapablePort) {
            this._name = ((FlowCapablePort)arg).getName();
            this._state = ((FlowCapablePort)arg).getState();
            this._currentFeature = ((FlowCapablePort)arg).getCurrentFeature();
            this._supported = ((FlowCapablePort)arg).getSupported();
            this._peerFeatures = ((FlowCapablePort)arg).getPeerFeatures();
            this._currentSpeed = ((FlowCapablePort)arg).getCurrentSpeed();
            this._maximumSpeed = ((FlowCapablePort)arg).getMaximumSpeed();
            isValidArg = true;
        }
        if (arg instanceof Queues) {
            this._queue = ((Queues)arg).getQueue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortConfig getConfiguration() {
        return this._configuration;
    }

    public PortFeatures getCurrentFeature() {
        return this._currentFeature;
    }

    public Long getCurrentSpeed() {
        return this._currentSpeed;
    }

    public MacAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public Long getMaximumSpeed() {
        return this._maximumSpeed;
    }

    public String getName() {
        return this._name;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public PortNumberUni getPortNumber() {
        return this._portNumber;
    }

    public List<Queue> getQueue() {
        return this._queue;
    }

    public State getState() {
        return this._state;
    }

    public PortFeatures getSupported() {
        return this._supported;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setConfiguration(PortConfig value) {
        this._configuration = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setCurrentFeature(PortFeatures value) {
        this._currentFeature = value;
        return this;
    }

    private static void checkCurrentSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setCurrentSpeed(Long value) {
        if (value != null) {
            FlowCapableNodeConnectorUpdateFieldsBuilder.checkCurrentSpeedRange(value);
        }
        this._currentSpeed = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _currentSpeed_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setHardwareAddress(MacAddress value) {
        if (value != null) {
            // empty if block
        }
        this._hardwareAddress = value;
        return this;
    }

    private static void checkMaximumSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setMaximumSpeed(Long value) {
        if (value != null) {
            FlowCapableNodeConnectorUpdateFieldsBuilder.checkMaximumSpeedRange(value);
        }
        this._maximumSpeed = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maximumSpeed_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setPortNumber(PortNumberUni value) {
        this._portNumber = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setQueue(List<Queue> value) {
        this._queue = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFieldsBuilder setSupported(PortFeatures value) {
        this._supported = value;
        return this;
    }

    public FlowCapableNodeConnectorUpdateFields build() {
        return new FlowCapableNodeConnectorUpdateFieldsImpl(this);
    }

    private static final class FlowCapableNodeConnectorUpdateFieldsImpl
    implements FlowCapableNodeConnectorUpdateFields {
        private final PortFeatures _advertisedFeatures;
        private final PortConfig _configuration;
        private final PortFeatures _currentFeature;
        private final Long _currentSpeed;
        private final MacAddress _hardwareAddress;
        private final Long _maximumSpeed;
        private final String _name;
        private final PortFeatures _peerFeatures;
        private final PortNumberUni _portNumber;
        private final List<Queue> _queue;
        private final State _state;
        private final PortFeatures _supported;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowCapableNodeConnectorUpdateFields> getImplementedInterface() {
            return FlowCapableNodeConnectorUpdateFields.class;
        }

        private FlowCapableNodeConnectorUpdateFieldsImpl(FlowCapableNodeConnectorUpdateFieldsBuilder base) {
            this._advertisedFeatures = base.getAdvertisedFeatures();
            this._configuration = base.getConfiguration();
            this._currentFeature = base.getCurrentFeature();
            this._currentSpeed = base.getCurrentSpeed();
            this._hardwareAddress = base.getHardwareAddress();
            this._maximumSpeed = base.getMaximumSpeed();
            this._name = base.getName();
            this._peerFeatures = base.getPeerFeatures();
            this._portNumber = base.getPortNumber();
            this._queue = base.getQueue();
            this._state = base.getState();
            this._supported = base.getSupported();
        }

        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        public PortConfig getConfiguration() {
            return this._configuration;
        }

        public PortFeatures getCurrentFeature() {
            return this._currentFeature;
        }

        public Long getCurrentSpeed() {
            return this._currentSpeed;
        }

        public MacAddress getHardwareAddress() {
            return this._hardwareAddress;
        }

        public Long getMaximumSpeed() {
            return this._maximumSpeed;
        }

        public String getName() {
            return this._name;
        }

        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        public PortNumberUni getPortNumber() {
            return this._portNumber;
        }

        public List<Queue> getQueue() {
            return this._queue;
        }

        public State getState() {
            return this._state;
        }

        public PortFeatures getSupported() {
            return this._supported;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._advertisedFeatures == null ? 0 : this._advertisedFeatures.hashCode());
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._currentFeature == null ? 0 : this._currentFeature.hashCode());
            result = 31 * result + (this._currentSpeed == null ? 0 : this._currentSpeed.hashCode());
            result = 31 * result + (this._hardwareAddress == null ? 0 : this._hardwareAddress.hashCode());
            result = 31 * result + (this._maximumSpeed == null ? 0 : this._maximumSpeed.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._peerFeatures == null ? 0 : this._peerFeatures.hashCode());
            result = 31 * result + (this._portNumber == null ? 0 : this._portNumber.hashCode());
            result = 31 * result + (this._queue == null ? 0 : this._queue.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            this.hash = result = 31 * result + (this._supported == null ? 0 : this._supported.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowCapableNodeConnectorUpdateFields.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowCapableNodeConnectorUpdateFields other = (FlowCapableNodeConnectorUpdateFields)obj;
            if (this._advertisedFeatures == null ? other.getAdvertisedFeatures() != null : !this._advertisedFeatures.equals((Object)other.getAdvertisedFeatures())) {
                return false;
            }
            if (this._configuration == null ? other.getConfiguration() != null : !this._configuration.equals((Object)other.getConfiguration())) {
                return false;
            }
            if (this._currentFeature == null ? other.getCurrentFeature() != null : !this._currentFeature.equals((Object)other.getCurrentFeature())) {
                return false;
            }
            if (this._currentSpeed == null ? other.getCurrentSpeed() != null : !this._currentSpeed.equals(other.getCurrentSpeed())) {
                return false;
            }
            if (this._hardwareAddress == null ? other.getHardwareAddress() != null : !this._hardwareAddress.equals((Object)other.getHardwareAddress())) {
                return false;
            }
            if (this._maximumSpeed == null ? other.getMaximumSpeed() != null : !this._maximumSpeed.equals(other.getMaximumSpeed())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._peerFeatures == null ? other.getPeerFeatures() != null : !this._peerFeatures.equals((Object)other.getPeerFeatures())) {
                return false;
            }
            if (this._portNumber == null ? other.getPortNumber() != null : !this._portNumber.equals((Object)other.getPortNumber())) {
                return false;
            }
            if (this._queue == null ? other.getQueue() != null : !this._queue.equals(other.getQueue())) {
                return false;
            }
            if (this._state == null ? other.getState() != null : !this._state.equals(other.getState())) {
                return false;
            }
            return !(this._supported == null ? other.getSupported() != null : !this._supported.equals((Object)other.getSupported()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FlowCapableNodeConnectorUpdateFields [");
            boolean first = true;
            if (this._advertisedFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertisedFeatures=");
                builder.append(this._advertisedFeatures);
            }
            if (this._configuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configuration=");
                builder.append(this._configuration);
            }
            if (this._currentFeature != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentFeature=");
                builder.append(this._currentFeature);
            }
            if (this._currentSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentSpeed=");
                builder.append(this._currentSpeed);
            }
            if (this._hardwareAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardwareAddress=");
                builder.append(this._hardwareAddress);
            }
            if (this._maximumSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maximumSpeed=");
                builder.append(this._maximumSpeed);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._peerFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_peerFeatures=");
                builder.append(this._peerFeatures);
            }
            if (this._portNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNumber=");
                builder.append(this._portNumber);
            }
            if (this._queue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queue=");
                builder.append(this._queue);
            }
            if (this._state != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_state=");
                builder.append(this._state);
            }
            if (this._supported != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supported=");
                builder.append(this._supported);
            }
            return builder.append(']').toString();
        }
    }
}

