/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch.multi;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;

public class PacketInDispatcherImpl
implements NotificationService.Listener<PacketReceived> {
    private final Map<InstanceIdentifier<Node>, NotificationService.Listener<PacketReceived>> handlerMapping = new HashMap<InstanceIdentifier<Node>, NotificationService.Listener<PacketReceived>>();

    public void onNotification(PacketReceived notification) {
        InstanceIdentifier ingressPort = notification.getIngress().getValue();
        InstanceIdentifier nodeOfPacket = ingressPort.firstIdentifierOf(Node.class);
        NotificationService.Listener<PacketReceived> nodeHandler = this.handlerMapping.get(nodeOfPacket);
        if (nodeHandler != null) {
            nodeHandler.onNotification((Notification)notification);
        }
    }

    public Map<InstanceIdentifier<Node>, NotificationService.Listener<PacketReceived>> getHandlerMapping() {
        return this.handlerMapping;
    }
}

