/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch.multi;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.openflowplugin.learningswitch.DataTreeChangeListenerRegistrationHolder;
import org.opendaylight.openflowplugin.learningswitch.FlowCommitWrapperImpl;
import org.opendaylight.openflowplugin.learningswitch.WakeupOnNode;
import org.opendaylight.openflowplugin.learningswitch.multi.MultipleLearningSwitchHandlerFacadeImpl;
import org.opendaylight.openflowplugin.learningswitch.multi.PacketInDispatcherImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacket;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
public final class LearningSwitchManagerMultiImpl
implements DataTreeChangeListenerRegistrationHolder,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LearningSwitchManagerMultiImpl.class);
    private final Registration dataTreeChangeListenerRegistration;
    private final Registration packetInRegistration;

    @Inject
    @Activate
    public LearningSwitchManagerMultiImpl(@Reference DataBroker dataBroker, @Reference NotificationService notificationService, @Reference RpcService rpcService) {
        LOG.debug("start() -->");
        FlowCommitWrapperImpl dataStoreAccessor = new FlowCommitWrapperImpl(dataBroker);
        PacketInDispatcherImpl packetInDispatcher = new PacketInDispatcherImpl();
        MultipleLearningSwitchHandlerFacadeImpl learningSwitchHandler = new MultipleLearningSwitchHandlerFacadeImpl(dataStoreAccessor, (TransmitPacket)rpcService.getRpc(TransmitPacket.class), packetInDispatcher);
        this.packetInRegistration = notificationService.registerListener(PacketReceived.class, (NotificationService.Listener)packetInDispatcher);
        this.dataTreeChangeListenerRegistration = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Table.class)), (DataTreeChangeListener)new WakeupOnNode(learningSwitchHandler));
        LOG.debug("start() <--");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        LOG.debug("stop() -->");
        this.packetInRegistration.close();
        this.dataTreeChangeListenerRegistration.close();
        LOG.debug("stop() <--");
    }

    @Override
    public Registration getDataTreeChangeListenerRegistration() {
        return this.dataTreeChangeListenerRegistration;
    }
}

