/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import java.util.Map;
import org.opendaylight.openflowplugin.api.OFConstants;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.OutputPortValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.InstructionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.apply.actions._case.ApplyActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetDestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ethernet.match.fields.EthernetSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatchBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class FlowUtils {
    private FlowUtils() {
    }

    public static FlowBuilder createDirectMacToMacFlow(Uint8 tableId, Uint16 priority, MacAddress srcMac, MacAddress dstMac, NodeConnectorRef dstPort) {
        FlowBuilder macToMacFlow = new FlowBuilder().setTableId(tableId).setFlowName("mac2mac");
        macToMacFlow.setId(new FlowId(Long.toString(macToMacFlow.hashCode())));
        EthernetMatch ethernetMatch = new EthernetMatchBuilder().setEthernetSource(new EthernetSourceBuilder().setAddress(srcMac).build()).setEthernetDestination(new EthernetDestinationBuilder().setAddress(dstMac).build()).build();
        NodeConnectorId outputPort = ((NodeConnectorKey)dstPort.getValue().firstKeyOf(NodeConnector.class)).getId();
        org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action outputToControllerAction = new ActionBuilder().setOrder(Integer.valueOf(0)).setAction((Action)new OutputActionCaseBuilder().setOutputAction(new OutputActionBuilder().setMaxLength(Uint16.MAX_VALUE).setOutputNodeConnector((Uri)outputPort).build()).build()).build();
        ApplyActions applyActions = new ApplyActionsBuilder().setAction(Map.of(outputToControllerAction.key(), outputToControllerAction)).build();
        org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction applyActionsInstruction = new InstructionBuilder().setOrder(Integer.valueOf(0)).setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(applyActions).build()).build();
        macToMacFlow.setMatch(new MatchBuilder().setEthernetMatch(ethernetMatch).build()).setInstructions(new InstructionsBuilder().setInstruction(Map.of(applyActionsInstruction.key(), applyActionsInstruction)).build()).setPriority(priority).setBufferId(OFConstants.OFP_NO_BUFFER).setHardTimeout(Uint16.ZERO).setIdleTimeout(Uint16.ZERO).setFlags(new FlowModFlags(false, false, false, false, false));
        return macToMacFlow;
    }

    public static FlowBuilder createFwdAllToControllerFlow(Uint8 tableId, Uint16 priority, FlowId flowId) {
        OutputActionBuilder output = new OutputActionBuilder();
        output.setMaxLength(Uint16.MAX_VALUE);
        Uri controllerPort = new Uri(OutputPortValues.CONTROLLER.toString());
        output.setOutputNodeConnector(controllerPort);
        org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action action = new ActionBuilder().setAction((Action)new OutputActionCaseBuilder().setOutputAction(output.build()).build()).withKey(new ActionKey(Integer.valueOf(0))).build();
        ApplyActionsBuilder aab = new ApplyActionsBuilder().setAction(Map.of(action.key(), action));
        org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction instruction = new InstructionBuilder().setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build()).withKey(new InstructionKey(Integer.valueOf(0))).build();
        InstructionsBuilder isb = new InstructionsBuilder().setInstruction(Map.of(instruction.key(), instruction));
        MatchBuilder matchBuilder = new MatchBuilder();
        FlowBuilder allToCtrlFlow = new FlowBuilder().setTableId(tableId).setFlowName("allPacketsToCtrl").setId(flowId).withKey(new FlowKey(flowId));
        allToCtrlFlow.setMatch(matchBuilder.build()).setInstructions(isb.build()).setPriority(priority).setBufferId(OFConstants.OFP_NO_BUFFER).setHardTimeout(Uint16.ZERO).setIdleTimeout(Uint16.ZERO).setFlags(new FlowModFlags(false, false, false, false, false));
        return allToCtrlFlow;
    }
}

