/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.IntegerIpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DottedQuad;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.MacAddressFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4MatchArbitraryBitMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6MatchArbitraryBitMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.opendaylight.ipv6.arbitrary.bitmask.fields.rev160224.Ipv6ArbitraryMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchComparatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MatchComparatorHelper.class);
    private static final int DEFAULT_SUBNET = 32;
    private static final int IPV4_MASK_LENGTH = 32;
    private static final int SHIFT_OCTET_1 = 24;
    private static final int SHIFT_OCTET_2 = 16;
    private static final int SHIFT_OCTET_3 = 8;
    private static final int SHIFT_OCTET_4 = 0;
    private static final int POSITION_OCTET_1 = 0;
    private static final int POSITION_OCTET_2 = 1;
    private static final int POSITION_OCTET_3 = 2;
    private static final int POSITION_OCTET_4 = 3;
    private static final String DEFAULT_ARBITRARY_BIT_MASK = "255.255.255.255";
    private static final String DEFAULT_IPV6_ARBITRARY_BIT_MASK = "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff";
    private static final String PREFIX_SEPARATOR = "/";
    private static final int IPV4_ADDRESS_LENGTH = 32;
    private static final int IPV6_ADDRESS_LENGTH = 128;
    private static final int BYTE_SIZE = 8;

    @VisibleForTesting
    static boolean ethernetMatchEquals(EthernetMatch statsEthernetMatch, EthernetMatch storedEthernetMatch) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsEthernetMatch, storedEthernetMatch);
        if (checkNullValues != null) {
            verdict = checkNullValues;
        } else {
            verdict = MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsEthernetMatch.getEthernetSource(), (MacAddressFilter)storedEthernetMatch.getEthernetSource());
            if (verdict) {
                verdict = MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsEthernetMatch.getEthernetDestination(), (MacAddressFilter)storedEthernetMatch.getEthernetDestination());
            }
            if (verdict) {
                if (statsEthernetMatch.getEthernetType() == null) {
                    if (storedEthernetMatch.getEthernetType() != null) {
                        verdict = false;
                    }
                } else {
                    verdict = statsEthernetMatch.getEthernetType().equals(storedEthernetMatch.getEthernetType());
                }
            }
        }
        return verdict;
    }

    static boolean ethernetMatchFieldsEquals(MacAddressFilter statsEthernetMatchFields, MacAddressFilter storedEthernetMatchFields) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsEthernetMatchFields, storedEthernetMatchFields);
        if (checkNullValues != null) {
            verdict = checkNullValues;
        } else {
            verdict = MatchComparatorHelper.macAddressEquals(statsEthernetMatchFields.getAddress(), storedEthernetMatchFields.getAddress());
            if (verdict) {
                verdict = MatchComparatorHelper.macAddressEquals(statsEthernetMatchFields.getMask(), storedEthernetMatchFields.getMask());
            }
        }
        return verdict;
    }

    static boolean macAddressEquals(MacAddress statsMacAddress, MacAddress storedMacAddress) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsMacAddress, storedMacAddress);
        verdict = checkNullValues != null ? checkNullValues.booleanValue() : statsMacAddress.getValue().equalsIgnoreCase(storedMacAddress.getValue());
        return verdict;
    }

    @VisibleForTesting
    static boolean layer3MatchEquals(Layer3Match statsLayer3Match, Layer3Match storedLayer3Match) {
        boolean verdict = true;
        if (statsLayer3Match instanceof Ipv4Match && storedLayer3Match instanceof Ipv4Match) {
            Ipv4Match statsIpv4Match = (Ipv4Match)statsLayer3Match;
            Ipv4Match storedIpv4Match = (Ipv4Match)storedLayer3Match;
            verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(storedIpv4Match.getIpv4Destination(), statsIpv4Match.getIpv4Destination());
            if (verdict) {
                verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(statsIpv4Match.getIpv4Source(), storedIpv4Match.getIpv4Source());
            }
        } else if (statsLayer3Match instanceof Ipv6Match && storedLayer3Match instanceof Ipv6Match) {
            Ipv6Match statsIpv6Match = (Ipv6Match)statsLayer3Match;
            Ipv6Match storedIpv6Match = (Ipv6Match)storedLayer3Match;
            verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(storedIpv6Match.getIpv6Destination(), statsIpv6Match.getIpv6Destination());
            if (verdict) {
                verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(statsIpv6Match.getIpv6Source(), storedIpv6Match.getIpv6Source());
            }
        } else if (statsLayer3Match instanceof Ipv4MatchArbitraryBitMask && storedLayer3Match instanceof Ipv4MatchArbitraryBitMask) {
            Ipv4MatchArbitraryBitMask statsIpv4MatchArbitraryBitMask = (Ipv4MatchArbitraryBitMask)statsLayer3Match;
            Ipv4MatchArbitraryBitMask storedIpv4MatchArbitraryBitMask = (Ipv4MatchArbitraryBitMask)storedLayer3Match;
            if (storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask() != null | storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask() != null) {
                if (storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask() != null) {
                    String storedDstIpAddress = MatchComparatorHelper.normalizeIpv4Address(storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask(), storedIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask());
                    String statsDstIpAddress = MatchComparatorHelper.normalizeIpv4Address(statsIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask(), statsIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask());
                    if (MatchComparatorHelper.compareStringNullSafe(storedIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask().getValue(), statsIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask().getValue())) {
                        verdict = MatchComparatorHelper.compareStringNullSafe(storedDstIpAddress, statsDstIpAddress);
                    } else {
                        verdict = false;
                        return verdict;
                    }
                }
                if (storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask() != null) {
                    String storedSrcIpAddress = MatchComparatorHelper.normalizeIpv4Address(storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask(), storedIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask());
                    String statsSrcIpAddress = MatchComparatorHelper.normalizeIpv4Address(statsIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask(), statsIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask());
                    verdict = MatchComparatorHelper.compareStringNullSafe(storedIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask().getValue(), statsIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask().getValue()) ? MatchComparatorHelper.compareStringNullSafe(storedSrcIpAddress, statsSrcIpAddress) : false;
                }
            } else {
                Boolean nullCheckOut = MatchComparatorHelper.checkNullValues(storedLayer3Match, statsLayer3Match);
                verdict = nullCheckOut != null ? nullCheckOut.booleanValue() : storedLayer3Match.equals(statsLayer3Match);
            }
        } else if (statsLayer3Match instanceof Ipv4Match && storedLayer3Match instanceof Ipv4MatchArbitraryBitMask) {
            Ipv4Match statsIpv4Match = (Ipv4Match)statsLayer3Match;
            Ipv4MatchArbitraryBitMask storedIpv4MatchArbitraryBitMask = (Ipv4MatchArbitraryBitMask)storedLayer3Match;
            if (storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask() != null) {
                Ipv4Prefix ipv4PrefixDestination;
                if (storedIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask() != null) {
                    byte[] destByteMask = MatchComparatorHelper.convertArbitraryMaskToByteArray(storedIpv4MatchArbitraryBitMask.getIpv4DestinationArbitraryBitmask());
                    ipv4PrefixDestination = MatchComparatorHelper.createPrefix(storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask(), destByteMask);
                } else {
                    ipv4PrefixDestination = MatchComparatorHelper.createPrefix(storedIpv4MatchArbitraryBitMask.getIpv4DestinationAddressNoMask());
                }
                verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(ipv4PrefixDestination, statsIpv4Match.getIpv4Destination());
                if (!verdict) {
                    return verdict;
                }
            }
            if (storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask() != null) {
                Ipv4Prefix ipv4PrefixSource;
                if (storedIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask() != null) {
                    byte[] srcByteMask = MatchComparatorHelper.convertArbitraryMaskToByteArray(storedIpv4MatchArbitraryBitMask.getIpv4SourceArbitraryBitmask());
                    ipv4PrefixSource = MatchComparatorHelper.createPrefix(storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask(), srcByteMask);
                } else {
                    ipv4PrefixSource = MatchComparatorHelper.createPrefix(storedIpv4MatchArbitraryBitMask.getIpv4SourceAddressNoMask());
                }
                verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(ipv4PrefixSource, statsIpv4Match.getIpv4Source());
            }
        } else if (statsLayer3Match instanceof Ipv6MatchArbitraryBitMask && storedLayer3Match instanceof Ipv6MatchArbitraryBitMask) {
            Ipv6MatchArbitraryBitMask statsIpv6MatchArbitraryBitMask = (Ipv6MatchArbitraryBitMask)statsLayer3Match;
            Ipv6MatchArbitraryBitMask storedIpv6MatchArbitraryBitMask = (Ipv6MatchArbitraryBitMask)storedLayer3Match;
            if (storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask() != null | storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask() != null) {
                if (storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask() != null) {
                    String statsDstMask;
                    String storedDstIpAddress = MatchComparatorHelper.normalizeIpv6Address(storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask(), storedIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask());
                    String statsDstIpAddress = MatchComparatorHelper.normalizeIpv6Address(statsIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask(), statsIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask());
                    String storedDstMask = MatchComparatorHelper.extractIpv6CanonicalForm(storedIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask().getValue()).getHostAddress();
                    if (MatchComparatorHelper.compareStringNullSafe(storedDstMask, statsDstMask = MatchComparatorHelper.extractIpv6CanonicalForm(statsIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask().getValue()).getHostAddress())) {
                        verdict = MatchComparatorHelper.compareStringNullSafe(storedDstIpAddress, statsDstIpAddress);
                    } else {
                        verdict = false;
                        return verdict;
                    }
                }
                if (storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask() != null) {
                    String statsSrcMask;
                    String storedSrcIpAddress = MatchComparatorHelper.normalizeIpv6Address(storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask(), storedIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask());
                    String statsSrcIpAddress = MatchComparatorHelper.normalizeIpv6Address(statsIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask(), statsIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask());
                    String storedSrcMask = MatchComparatorHelper.extractIpv6CanonicalForm(storedIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask().getValue()).getHostAddress();
                    verdict = MatchComparatorHelper.compareStringNullSafe(storedSrcMask, statsSrcMask = MatchComparatorHelper.extractIpv6CanonicalForm(statsIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask().getValue()).getHostAddress()) ? MatchComparatorHelper.compareStringNullSafe(storedSrcIpAddress, statsSrcIpAddress) : false;
                }
            } else {
                Boolean nullCheckOut = MatchComparatorHelper.checkNullValues(storedLayer3Match, statsLayer3Match);
                verdict = nullCheckOut != null ? nullCheckOut.booleanValue() : storedLayer3Match.equals(statsLayer3Match);
            }
        } else if (statsLayer3Match instanceof Ipv6Match && storedLayer3Match instanceof Ipv6MatchArbitraryBitMask) {
            Ipv6Match statsIpv6Match = (Ipv6Match)statsLayer3Match;
            Ipv6MatchArbitraryBitMask storedIpv6MatchArbitraryBitMask = (Ipv6MatchArbitraryBitMask)storedLayer3Match;
            if (storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask() != null) {
                Ipv6Prefix ipv6PrefixDestination;
                if (storedIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask() != null) {
                    byte[] destByteMask = MatchComparatorHelper.convertIpv6ArbitraryMaskToByteArray(storedIpv6MatchArbitraryBitMask.getIpv6DestinationArbitraryBitmask());
                    ipv6PrefixDestination = MatchComparatorHelper.createPrefix(storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask(), destByteMask);
                } else {
                    ipv6PrefixDestination = MatchComparatorHelper.createPrefix(storedIpv6MatchArbitraryBitMask.getIpv6DestinationAddressNoMask());
                }
                verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(ipv6PrefixDestination, statsIpv6Match.getIpv6Destination());
                if (!verdict) {
                    return verdict;
                }
            }
            if (storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask() != null) {
                Ipv6Prefix ipv6PrefixSource;
                if (storedIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask() != null) {
                    byte[] srcByteMask = MatchComparatorHelper.convertIpv6ArbitraryMaskToByteArray(storedIpv6MatchArbitraryBitMask.getIpv6SourceArbitraryBitmask());
                    ipv6PrefixSource = MatchComparatorHelper.createPrefix(storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask(), srcByteMask);
                } else {
                    ipv6PrefixSource = MatchComparatorHelper.createPrefix(storedIpv6MatchArbitraryBitMask.getIpv6SourceAddressNoMask());
                }
                verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(ipv6PrefixSource, statsIpv6Match.getIpv6Source());
            }
        } else {
            Boolean nullCheckOut;
            verdict = statsLayer3Match instanceof ArpMatch && storedLayer3Match instanceof ArpMatch ? MatchComparatorHelper.arpMatchEquals((ArpMatch)statsLayer3Match, (ArpMatch)storedLayer3Match) : ((nullCheckOut = MatchComparatorHelper.checkNullValues(storedLayer3Match, statsLayer3Match)) != null ? nullCheckOut.booleanValue() : storedLayer3Match.equals(statsLayer3Match));
        }
        return verdict;
    }

    static boolean arpMatchEquals(ArpMatch statsArpMatch, ArpMatch storedArpMatch) {
        ArpSourceHardwareAddress storedMac;
        Ipv4Prefix storedIp;
        Integer storedOp;
        Integer statsOp = statsArpMatch.getArpOp();
        Boolean nullCheck = MatchComparatorHelper.checkNullValues(statsOp, storedOp = storedArpMatch.getArpOp());
        if (nullCheck != null ? nullCheck == false : !statsOp.equals(storedOp)) {
            return false;
        }
        Ipv4Prefix statsIp = statsArpMatch.getArpSourceTransportAddress();
        if (!MatchComparatorHelper.compareIpv4PrefixNullSafe(statsIp, storedIp = storedArpMatch.getArpSourceTransportAddress())) {
            return false;
        }
        statsIp = statsArpMatch.getArpTargetTransportAddress();
        if (!MatchComparatorHelper.compareIpv4PrefixNullSafe(statsIp, storedIp = storedArpMatch.getArpTargetTransportAddress())) {
            return false;
        }
        ArpSourceHardwareAddress statsMac = statsArpMatch.getArpSourceHardwareAddress();
        if (!MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsMac, (MacAddressFilter)(storedMac = storedArpMatch.getArpSourceHardwareAddress()))) {
            return false;
        }
        statsMac = statsArpMatch.getArpTargetHardwareAddress();
        return MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsMac, (MacAddressFilter)(storedMac = storedArpMatch.getArpTargetHardwareAddress()));
    }

    static boolean IpAddressEquals(Ipv4Prefix statsIpAddress, Ipv4Prefix storedIpAddress) {
        IntegerIpAddress storedIpAddressInt;
        IntegerIpAddress statsIpAddressInt = MatchComparatorHelper.strIpToIntIp(statsIpAddress.getValue());
        if (MatchComparatorHelper.ipAndMaskBasedMatch(statsIpAddressInt, storedIpAddressInt = MatchComparatorHelper.strIpToIntIp(storedIpAddress.getValue()))) {
            return true;
        }
        return MatchComparatorHelper.ipBasedMatch(statsIpAddressInt, storedIpAddressInt);
    }

    static boolean ipAndMaskBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return (statsIpAddressInt.getIp() & statsIpAddressInt.getMask()) == (storedIpAddressInt.getIp() & storedIpAddressInt.getMask());
    }

    static boolean ipBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return statsIpAddressInt.getIp() == storedIpAddressInt.getIp();
    }

    private static boolean IpAddressEquals(Ipv6Prefix statsIpv6, Ipv6Prefix storedIpv6) {
        String[] statsIpMask = statsIpv6.getValue().split(PREFIX_SEPARATOR);
        String[] storedIpMask = storedIpv6.getValue().split(PREFIX_SEPARATOR);
        if (statsIpMask.length <= 1 || storedIpMask.length <= 1 || !statsIpMask[1].equals(storedIpMask[1])) {
            return false;
        }
        int prefix = Integer.parseInt(statsIpMask[1]);
        int byteIndex = prefix / 8;
        int lastByteBits = 8 - prefix % 8;
        InetAddress statsIp = InetAddresses.forString((String)statsIpMask[0]);
        InetAddress storedIp = InetAddresses.forString((String)storedIpMask[0]);
        byte[] statsIpArr = Arrays.copyOfRange(statsIp.getAddress(), 0, byteIndex + 1);
        byte[] storedIpArr = Arrays.copyOfRange(storedIp.getAddress(), 0, byteIndex + 1);
        statsIpArr[byteIndex] = (byte)(statsIpArr[byteIndex] & 255 << lastByteBits);
        storedIpArr[byteIndex] = (byte)(storedIpArr[byteIndex] & 255 << lastByteBits);
        return Arrays.equals(statsIpArr, storedIpArr);
    }

    static Boolean checkNullValues(Object v1, Object v2) {
        Boolean verdict = null;
        if (v1 == null && v2 != null) {
            verdict = Boolean.FALSE;
        } else if (v1 != null && v2 == null) {
            verdict = Boolean.FALSE;
        } else if (v1 == null && v2 == null) {
            verdict = Boolean.TRUE;
        }
        return verdict;
    }

    static boolean compareIpv4PrefixNullSafe(Ipv4Prefix statsIpv4, Ipv4Prefix storedIpv4) {
        boolean verdict = true;
        Boolean checkDestNullValuesOut = MatchComparatorHelper.checkNullValues(storedIpv4, statsIpv4);
        if (checkDestNullValuesOut != null) {
            verdict = checkDestNullValuesOut;
        } else if (!MatchComparatorHelper.IpAddressEquals(statsIpv4, storedIpv4)) {
            verdict = false;
        }
        return verdict;
    }

    static boolean compareStringNullSafe(String stringA, String stringB) {
        boolean verdict = true;
        Boolean checkDestNullValuesOut = MatchComparatorHelper.checkNullValues(stringA, stringB);
        if (checkDestNullValuesOut != null) {
            verdict = checkDestNullValuesOut;
        } else if (!stringA.equals(stringB)) {
            verdict = false;
        }
        return verdict;
    }

    private static boolean compareIpv6PrefixNullSafe(Ipv6Prefix statsIpv6, Ipv6Prefix storedIpv6) {
        boolean verdict = true;
        Boolean checkDestNullValuesOut = MatchComparatorHelper.checkNullValues(statsIpv6, storedIpv6);
        if (checkDestNullValuesOut != null) {
            verdict = checkDestNullValuesOut;
        } else if (!MatchComparatorHelper.IpAddressEquals(statsIpv6, storedIpv6)) {
            verdict = false;
        }
        return verdict;
    }

    static IntegerIpAddress strIpToIntIp(String ipAddresss) {
        int prefix;
        String[] parts = ipAddresss.split(PREFIX_SEPARATOR);
        String ip = parts[0];
        if (parts.length < 2) {
            prefix = 32;
        } else {
            prefix = Integer.parseInt(parts[1]);
            if (prefix < 0 || prefix > 32) {
                StringBuilder stringBuilder = new StringBuilder("Valid values for mask are from range 0 - 32. Value ");
                stringBuilder.append(prefix);
                stringBuilder.append(" is invalid.");
                throw new IllegalStateException(stringBuilder.toString());
            }
        }
        IntegerIpAddress integerIpAddress = null;
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)ip);
        byte[] addrBytes = addr.getAddress();
        int ipInt = (addrBytes[0] & 0xFF) << 24 | (addrBytes[1] & 0xFF) << 16 | (addrBytes[2] & 0xFF) << 8 | (addrBytes[3] & 0xFF) << 0;
        int mask = -1 << 32 - prefix;
        integerIpAddress = new IntegerIpAddress(ipInt, mask);
        return integerIpAddress;
    }

    static boolean isArbitraryBitMask(byte[] byteMask) {
        if (byteMask == null) {
            return false;
        }
        ArrayList<Integer> integerMaskArrayList = new ArrayList<Integer>();
        String maskInBits = new BigInteger(1, byteMask).toString(2);
        ArrayList<String> stringMaskArrayList = new ArrayList<String>(Arrays.asList(maskInBits.split("(?!^)")));
        for (String string : stringMaskArrayList) {
            integerMaskArrayList.add(Integer.parseInt(string));
        }
        return MatchComparatorHelper.checkArbitraryBitMask(integerMaskArrayList);
    }

    static boolean checkArbitraryBitMask(ArrayList<Integer> arrayList) {
        if (arrayList.size() > 0 && arrayList.size() < 32) {
            return true;
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            if (arrayList.get(i) != 0 || arrayList.get(i + 1) != 1) continue;
            return true;
        }
        return false;
    }

    static final byte[] convertArbitraryMaskToByteArray(DottedQuad mask) {
        String maskValue = mask.getValue() != null ? mask.getValue() : DEFAULT_ARBITRARY_BIT_MASK;
        InetAddress maskInIpFormat = null;
        try {
            maskInIpFormat = InetAddress.getByName(maskValue);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to recognize the host while converting mask ", (Throwable)e);
        }
        byte[] bytes = maskInIpFormat.getAddress();
        return bytes;
    }

    private static final byte[] convertIpv6ArbitraryMaskToByteArray(Ipv6ArbitraryMask mask) {
        String maskValue = mask.getValue() != null ? mask.getValue() : DEFAULT_IPV6_ARBITRARY_BIT_MASK;
        InetAddress maskInIpv6Format = null;
        try {
            maskInIpv6Format = InetAddress.getByName(maskValue);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to convert string mask value to ipv6 format ", (Throwable)e);
        }
        return maskInIpv6Format.getAddress();
    }

    static String normalizeIpv4Address(Ipv4Address ipAddress, DottedQuad netMask) {
        String actualIpAddress = "";
        String[] netMaskParts = netMask.getValue().split("\\.");
        String[] ipAddressParts = ipAddress.getValue().split("\\.");
        for (int i = 0; i < ipAddressParts.length; ++i) {
            int integerFormatIpAddress = Integer.parseInt(ipAddressParts[i]);
            int integerFormatNetMask = Integer.parseInt(netMaskParts[i]);
            int ipAddressPart = integerFormatIpAddress & integerFormatNetMask;
            actualIpAddress = actualIpAddress + ipAddressPart;
            if (i == ipAddressParts.length - 1) continue;
            actualIpAddress = actualIpAddress + ".";
        }
        return actualIpAddress;
    }

    private static String normalizeIpv6Address(Ipv6Address ipAddress, Ipv6ArbitraryMask netMask) {
        byte[] ipAddressParts = MatchComparatorHelper.convertIpv6ToBytes(ipAddress.getValue());
        byte[] netMaskParts = MatchComparatorHelper.convertIpv6ToBytes(netMask.getValue());
        byte[] actualIpv6Bytes = new byte[16];
        for (int i = 0; i < ipAddressParts.length; ++i) {
            byte ipAddressPart;
            actualIpv6Bytes[i] = ipAddressPart = (byte)(ipAddressParts[i] & netMaskParts[i]);
        }
        InetAddress ipv6Address = null;
        try {
            ipv6Address = InetAddress.getByAddress(actualIpv6Bytes);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to recognize the host while normalizing IPv6 address from bytes ", (Throwable)e);
        }
        return ipv6Address.getHostAddress();
    }

    private static byte[] convertIpv6ToBytes(String ipv6Address) {
        return MatchComparatorHelper.extractIpv6CanonicalForm(ipv6Address).getAddress();
    }

    private static InetAddress extractIpv6CanonicalForm(String ipv6Address) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ipv6Address);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to recognize the host while converting IPv6 to bytes ", (Throwable)e);
        }
        return address;
    }

    static Ipv4Prefix createPrefix(Ipv4Address ipv4Address, byte[] bytemask) {
        return MatchComparatorHelper.createPrefix(ipv4Address, String.valueOf(MatchComparatorHelper.countBits(bytemask)));
    }

    private static Ipv6Prefix createPrefix(Ipv6Address ipv6Address, byte[] bytemask) {
        return MatchComparatorHelper.createPrefix(ipv6Address, String.valueOf(MatchComparatorHelper.countBits(bytemask)));
    }

    private static Ipv6Prefix createPrefix(Ipv6Address ipv6Address, String mask) {
        if (mask != null && !mask.isEmpty()) {
            return new Ipv6Prefix(ipv6Address.getValue() + PREFIX_SEPARATOR + mask);
        }
        return new Ipv6Prefix(ipv6Address.getValue() + PREFIX_SEPARATOR + 128);
    }

    private static Ipv6Prefix createPrefix(Ipv6Address ipv6Address) {
        return new Ipv6Prefix(ipv6Address.getValue() + PREFIX_SEPARATOR + 128);
    }

    static int countBits(byte[] mask) {
        int netmask = 0;
        for (byte b : mask) {
            netmask += Integer.bitCount(UnsignedBytes.toInt((byte)b));
        }
        return netmask;
    }

    static Ipv4Prefix createPrefix(Ipv4Address ipv4Address) {
        return new Ipv4Prefix(ipv4Address.getValue() + PREFIX_SEPARATOR + 32);
    }

    static Ipv4Prefix createPrefix(Ipv4Address ipv4Address, String mask) {
        if (null != mask && !mask.isEmpty()) {
            return new Ipv4Prefix(ipv4Address.getValue() + PREFIX_SEPARATOR + mask);
        }
        return new Ipv4Prefix(ipv4Address.getValue() + PREFIX_SEPARATOR + 32);
    }
}

