/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.MatchComparatorFactory;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.SimpleComparator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;

public final class FlowComparatorFactory {
    private static final Collection<SimpleComparator<Match>> MATCH_COMPARATORS = new ArrayList<SimpleComparator<Match>>();

    private FlowComparatorFactory() {
    }

    public static SimpleComparator<Flow> createContainerName() {
        return new SimpleComparator<Flow>(){

            @Override
            public boolean areObjectsEqual(Flow statsFlow, Flow storedFlow) {
                return !(statsFlow.getContainerName() == null ? storedFlow.getContainerName() != null : !statsFlow.getContainerName().equals(storedFlow.getContainerName()));
            }
        };
    }

    public static SimpleComparator<Flow> createPriority() {
        return new SimpleComparator<Flow>(){

            @Override
            public boolean areObjectsEqual(Flow statsFlow, Flow storedFlow) {
                return !(storedFlow.getPriority() == null ? statsFlow.getPriority() != null && statsFlow.getPriority() != 32768 : !statsFlow.getPriority().equals(storedFlow.getPriority()));
            }
        };
    }

    public static SimpleComparator<Flow> createTableId() {
        return new SimpleComparator<Flow>(){

            @Override
            public boolean areObjectsEqual(Flow statsFlow, Flow storedFlow) {
                return !(statsFlow.getTableId() == null ? storedFlow.getTableId() != null : !statsFlow.getTableId().equals(storedFlow.getTableId()));
            }
        };
    }

    public static SimpleComparator<Flow> createCookie() {
        return new SimpleComparator<Flow>(){

            @Override
            public boolean areObjectsEqual(Flow statsFlow, Flow storedFlow) {
                if (storedFlow.getCookie() == null) {
                    return true;
                }
                return !(statsFlow.getCookie() == null ? storedFlow.getCookie() != null : !statsFlow.getCookie().equals((Object)storedFlow.getCookie()));
            }
        };
    }

    public static SimpleComparator<Flow> createMatch() {
        return new SimpleComparator<Flow>(){

            @Override
            public boolean areObjectsEqual(Flow statsFlow, Flow storedFlow) {
                return !(statsFlow.getMatch() == null ? storedFlow.getMatch() != null : !FlowComparatorFactory.compareMatches(statsFlow.getMatch(), storedFlow.getMatch()));
            }
        };
    }

    private static boolean compareMatches(Match statsMatch, Match storedMatch) {
        if (statsMatch == storedMatch) {
            return true;
        }
        for (SimpleComparator<Match> matchComp : MATCH_COMPARATORS) {
            if (matchComp.areObjectsEqual(statsMatch, storedMatch)) continue;
            return false;
        }
        return true;
    }

    static {
        MATCH_COMPARATORS.add(MatchComparatorFactory.createEthernet());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createIcmpv4());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createInPhyPort());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createInPort());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createIp());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createL3());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createL4());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createProtocolMatchFields());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createMetadata());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createNull());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createTunnel());
        MATCH_COMPARATORS.add(MatchComparatorFactory.createVlan());
    }
}

