/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupFeaturesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterFeaturesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatRpcMsgManagerImpl
implements StatRpcMsgManager {
    private static final Logger LOG = LoggerFactory.getLogger(StatRpcMsgManagerImpl.class);
    private final Cache<String, StatRpcMsgManager.TransactionCacheContainer<? super TransactionAware>> txCache;
    private static final int MAX_CACHE_SIZE = 10000;
    private static final int QUEUE_CAPACITY = 5000;
    private static final String MSG_TRANS_ID_NOT_NULL = "TransactionId can not be null!";
    private static final String MSG_NODE_ID_NOT_NULL = "NodeId can not be null!";
    private static final String MSG_NODE_REF_NOT_NULL = "NodeRef can not be null!";
    private static final long POSSIBLE_STAT_WAIT_FOR_NOTIFICATION = 7L;
    private final OpendaylightGroupStatisticsService groupStatsService;
    private final OpendaylightMeterStatisticsService meterStatsService;
    private final OpendaylightFlowStatisticsService flowStatsService;
    private final OpendaylightPortStatisticsService portStatsService;
    private final OpendaylightFlowTableStatisticsService flowTableStatsService;
    private final OpendaylightQueueStatisticsService queueStatsService;
    private BlockingQueue<StatRpcMsgManager.RpcJobsQueue> statsRpcJobQueue;
    private volatile boolean finishing = false;

    public StatRpcMsgManagerImpl(StatisticsManager manager, RpcConsumerRegistry rpcRegistry, long maxNodeForCollector) {
        Preconditions.checkArgument((manager != null ? 1 : 0) != 0, (Object)"StatisticManager can not be null!");
        Preconditions.checkArgument((rpcRegistry != null ? 1 : 0) != 0, (Object)"RpcConsumerRegistry can not be null !");
        this.groupStatsService = (OpendaylightGroupStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightGroupStatisticsService.class), (Object)"OpendaylightGroupStatisticsService can not be null!");
        this.meterStatsService = (OpendaylightMeterStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightMeterStatisticsService.class), (Object)"OpendaylightMeterStatisticsService can not be null!");
        this.flowStatsService = (OpendaylightFlowStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightFlowStatisticsService.class), (Object)"OpendaylightFlowStatisticsService can not be null!");
        this.portStatsService = (OpendaylightPortStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightPortStatisticsService.class), (Object)"OpendaylightPortStatisticsService can not be null!");
        this.flowTableStatsService = (OpendaylightFlowTableStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightFlowTableStatisticsService.class), (Object)"OpendaylightFlowTableStatisticsService can not be null!");
        this.queueStatsService = (OpendaylightQueueStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightQueueStatisticsService.class), (Object)"OpendaylightQueueStatisticsService can not be null!");
        this.statsRpcJobQueue = new LinkedBlockingQueue<StatRpcMsgManager.RpcJobsQueue>(5000);
        this.txCache = CacheBuilder.newBuilder().expireAfterWrite(maxNodeForCollector * 7L, TimeUnit.SECONDS).maximumSize(10000L).build();
    }

    @Override
    public void close() {
        this.finishing = true;
        this.statsRpcJobQueue = null;
    }

    @Override
    public void run() {
        while (!this.finishing) {
            try {
                this.statsRpcJobQueue.take().call();
            }
            catch (Exception e) {
                LOG.warn("Stat Element RPC executor fail!", (Throwable)e);
            }
        }
        while (!this.statsRpcJobQueue.isEmpty()) {
            this.statsRpcJobQueue.poll();
        }
    }

    private void addGetAllStatJob(StatRpcMsgManager.RpcJobsQueue getAllStatJob) {
        boolean success = this.statsRpcJobQueue.offer(getAllStatJob);
        if (!success) {
            LOG.warn("Put RPC request getAllStat fail! Queue is full.");
        }
    }

    private void addStatJob(StatRpcMsgManager.RpcJobsQueue getStatJob) {
        boolean success = this.statsRpcJobQueue.offer(getStatJob);
        if (!success) {
            LOG.debug("Put RPC request for getStat fail! Queue is full.");
        }
    }

    @Override
    public <T extends TransactionAware, D extends DataObject> void registrationRpcFutureCallBack(Future<RpcResult<T>> future, final D inputObj, final NodeRef nodeRef, final SettableFuture<TransactionId> resultTransId) {
        class FutureCallbackImpl
        implements FutureCallback<RpcResult<? extends TransactionAware>> {
            FutureCallbackImpl() {
            }

            public void onSuccess(RpcResult<? extends TransactionAware> result) {
                TransactionId id = ((TransactionAware)result.getResult()).getTransactionId();
                NodeKey nodeKey = (NodeKey)nodeRef.getValue().firstKeyOf(Node.class, NodeKey.class);
                if (id == null) {
                    String[] multipartRequestName = ((TransactionAware)result.getResult()).getClass().getSimpleName().split("(?=\\p{Upper})");
                    LOG.warn("Node [{}] does not support statistics request type : {}", (Object)nodeKey.getId(), (Object)Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(multipartRequestName, 2, multipartRequestName.length - 2)));
                    if (resultTransId != null) {
                        resultTransId.setException((Throwable)new UnsupportedOperationException());
                    }
                } else {
                    if (resultTransId != null) {
                        resultTransId.set((Object)id);
                    }
                    String cacheKey = StatRpcMsgManagerImpl.this.buildCacheKey(id, nodeKey.getId());
                    TransactionCacheContainerImpl container = new TransactionCacheContainerImpl(id, inputObj, nodeKey.getId());
                    StatRpcMsgManagerImpl.this.txCache.put((Object)cacheKey, container);
                }
            }

            public void onFailure(Throwable t) {
                LOG.warn("Response Registration for Statistics RPC call fail!", t);
                if (resultTransId != null) {
                    resultTransId.setException(t);
                }
            }
        }
        Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread(future), (FutureCallback)new FutureCallbackImpl());
    }

    private String buildCacheKey(TransactionId id, NodeId nodeId) {
        return String.valueOf(id.getValue()) + "-" + nodeId.getValue();
    }

    @Override
    public Future<Optional<StatRpcMsgManager.TransactionCacheContainer<?>>> getTransactionCacheContainer(TransactionId id, NodeId nodeId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_TRANS_ID_NOT_NULL);
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        final String key = this.buildCacheKey(id, nodeId);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getTransactionCacheContainer = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                Optional resultContainer = Optional.fromNullable((Object)StatRpcMsgManagerImpl.this.txCache.getIfPresent((Object)key));
                if (resultContainer.isPresent()) {
                    StatRpcMsgManagerImpl.this.txCache.invalidate((Object)key);
                }
                result.set((Object)resultContainer);
                return null;
            }
        };
        this.addStatJob(getTransactionCacheContainer);
        return result;
    }

    @Override
    public Future<Boolean> isExpectedStatistics(TransactionId id, NodeId nodeId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_TRANS_ID_NOT_NULL);
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        final String key = this.buildCacheKey(id, nodeId);
        final SettableFuture checkStatId = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue isExpecedStatistics = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                Optional result = Optional.fromNullable((Object)StatRpcMsgManagerImpl.this.txCache.getIfPresent((Object)key));
                checkStatId.set((Object)result.isPresent());
                return null;
            }
        };
        this.addStatJob(isExpecedStatistics);
        return checkStatId;
    }

    public void addNotification(final TransactionAware notification, final NodeId nodeId) {
        Preconditions.checkArgument((notification != null ? 1 : 0) != 0, (Object)"TransactionAware can not be null!");
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        StatRpcMsgManager.RpcJobsQueue addNotification = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                TransactionId txId = notification.getTransactionId();
                String key = StatRpcMsgManagerImpl.this.buildCacheKey(txId, nodeId);
                StatRpcMsgManager.TransactionCacheContainer container = (StatRpcMsgManager.TransactionCacheContainer)StatRpcMsgManagerImpl.this.txCache.getIfPresent((Object)key);
                if (container != null) {
                    container.addNotif(notification);
                }
                return null;
            }
        };
        this.addStatJob(addNotification);
    }

    @Override
    public Future<TransactionId> getAllGroupsStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllGroupStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllGroupStatisticsInputBuilder builder = new GetAllGroupStatisticsInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.groupStatsService.getAllGroupStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllGroupStat);
        return result;
    }

    @Override
    public Future<TransactionId> getAllMetersStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllMeterStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllMeterStatisticsInputBuilder builder = new GetAllMeterStatisticsInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.meterStatsService.getAllMeterStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllMeterStat);
        return result;
    }

    @Override
    public Future<TransactionId> getAllFlowsStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllFlowStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllFlowsStatisticsFromAllFlowTablesInputBuilder builder = new GetAllFlowsStatisticsFromAllFlowTablesInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.flowStatsService.getAllFlowsStatisticsFromAllFlowTables(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllFlowStat);
        return result;
    }

    @Override
    public void getAggregateFlowStat(final NodeRef nodeRef, final TableId tableId) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"TableId can not be null!");
        StatRpcMsgManager.RpcJobsQueue getAggregateFlowStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder builder = new GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder();
                builder.setNode(nodeRef);
                builder.setTableId(tableId);
                TableBuilder tbuilder = new TableBuilder();
                tbuilder.setId(tableId.getValue());
                tbuilder.setKey(new TableKey(tableId.getValue()));
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.flowStatsService.getAggregateFlowStatisticsFromFlowTableForAllFlows(builder.build()), tbuilder.build(), nodeRef, null);
                return null;
            }
        };
        this.addGetAllStatJob(getAggregateFlowStat);
    }

    @Override
    public Future<TransactionId> getAllPortsStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllPortsStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllNodeConnectorsStatisticsInputBuilder builder = new GetAllNodeConnectorsStatisticsInputBuilder();
                builder.setNode(nodeRef);
                Future rpc = StatRpcMsgManagerImpl.this.portStatsService.getAllNodeConnectorsStatistics(builder.build());
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(rpc, null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllPortsStat);
        return result;
    }

    @Override
    public Future<TransactionId> getAllTablesStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllTableStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetFlowTablesStatisticsInputBuilder builder = new GetFlowTablesStatisticsInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.flowTableStatsService.getFlowTablesStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllTableStat);
        return result;
    }

    @Override
    public Future<TransactionId> getAllQueueStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllQueueStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllQueuesStatisticsFromAllPortsInputBuilder builder = new GetAllQueuesStatisticsFromAllPortsInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.queueStatsService.getAllQueuesStatisticsFromAllPorts(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllQueueStat);
        return result;
    }

    @Override
    public Future<TransactionId> getAllMeterConfigStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue qetAllMeterConfStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetAllMeterConfigStatisticsInputBuilder builder = new GetAllMeterConfigStatisticsInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.meterStatsService.getAllMeterConfigStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(qetAllMeterConfStat);
        return result;
    }

    @Override
    public void getGroupFeaturesStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        StatRpcMsgManager.RpcJobsQueue getGroupFeaturesStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetGroupFeaturesInputBuilder input = new GetGroupFeaturesInputBuilder();
                input.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.groupStatsService.getGroupFeatures(input.build()), null, nodeRef, null);
                return null;
            }
        };
        this.addStatJob(getGroupFeaturesStat);
    }

    @Override
    public void getMeterFeaturesStat(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        StatRpcMsgManager.RpcJobsQueue getMeterFeaturesStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetMeterFeaturesInputBuilder input = new GetMeterFeaturesInputBuilder();
                input.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.meterStatsService.getMeterFeatures(input.build()), null, nodeRef, null);
                return null;
            }
        };
        this.addStatJob(getMeterFeaturesStat);
    }

    @Override
    public Future<TransactionId> getAllGroupsConfStats(final NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        final SettableFuture result = SettableFuture.create();
        StatRpcMsgManager.RpcJobsQueue getAllGropConfStat = new StatRpcMsgManager.RpcJobsQueue(){

            @Override
            public Void call() throws Exception {
                GetGroupDescriptionInputBuilder builder = new GetGroupDescriptionInputBuilder();
                builder.setNode(nodeRef);
                StatRpcMsgManagerImpl.this.registrationRpcFutureCallBack(StatRpcMsgManagerImpl.this.groupStatsService.getGroupDescription(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
                return null;
            }
        };
        this.addGetAllStatJob(getAllGropConfStat);
        return result;
    }

    public class TransactionCacheContainerImpl<T extends TransactionAware>
    implements StatRpcMsgManager.TransactionCacheContainer<T> {
        private final TransactionId id;
        private final NodeId nId;
        private final List<T> notifications;
        private final Optional<? extends DataObject> confInput;

        public <D extends DataObject> TransactionCacheContainerImpl(TransactionId id, D input, NodeId nodeId) {
            this.id = (TransactionId)Preconditions.checkNotNull((Object)id, (Object)StatRpcMsgManagerImpl.MSG_TRANS_ID_NOT_NULL);
            this.notifications = new CopyOnWriteArrayList<T>();
            this.confInput = Optional.fromNullable(input);
            this.nId = nodeId;
        }

        @Override
        public void addNotif(T notif) {
            this.notifications.add(notif);
        }

        @Override
        public TransactionId getId() {
            return this.id;
        }

        @Override
        public NodeId getNodeId() {
            return this.nId;
        }

        @Override
        public List<T> getNotifications() {
            return this.notifications;
        }

        @Override
        public Optional<? extends DataObject> getConfInput() {
            return this.confInput;
        }
    }
}

