/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractListenCommit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.GenericQueueStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.QueueStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.flow.capable.node.connector.queue.statistics.FlowCapableNodeConnectorQueueStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.flow.capable.node.connector.queue.statistics.FlowCapableNodeConnectorQueueStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.queue.id.and.statistics.map.QueueIdAndStatisticsMap;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatListenCommitQueue
extends StatAbstractListenCommit<Queue, OpendaylightQueueStatisticsListener>
implements OpendaylightQueueStatisticsListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatListenCommitQueue.class);

    public StatListenCommitQueue(StatisticsManager manager, DataBroker db, NotificationProviderService nps, StatNodeRegistration nrm) {
        super(manager, db, nps, Queue.class, nrm);
    }

    @Override
    protected OpendaylightQueueStatisticsListener getStatNotificationListener() {
        return this;
    }

    @Override
    protected InstanceIdentifier<Queue> getWildCardedRegistrationPath() {
        return InstanceIdentifier.create(Nodes.class).child(Node.class).child(NodeConnector.class).augmentation(FlowCapableNodeConnector.class).child(Queue.class);
    }

    public void onQueueStatisticsUpdate(QueueStatisticsUpdate notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - QueueStatisticsUpdate: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                Optional fNode = Optional.absent();
                try {
                    fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIdent).checkedGet();
                }
                catch (ReadFailedException e) {
                    LOG.debug("Read Operational/DS for Node fail! {}", (Object)nodeIdent, (Object)e);
                }
                if (!fNode.isPresent()) {
                    LOG.trace("Read Operational/DS for Node fail! Node {} doesn't exist.", (Object)nodeIdent);
                    return;
                }
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitQueue.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitQueue.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitQueue.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List existConnectors = ((Node)fNode.get()).getNodeConnector() != null ? ((Node)fNode.get()).getNodeConnector() : Collections.emptyList();
                HashMap<QueueKey, NodeConnectorKey> existQueueKeys = new HashMap<QueueKey, NodeConnectorKey>();
                for (NodeConnector connect : existConnectors) {
                    List listQueues;
                    if (connect.getAugmentation(FlowCapableNodeConnector.class) == null || (listQueues = ((FlowCapableNodeConnector)connect.getAugmentation(FlowCapableNodeConnector.class)).getQueue()) == null) continue;
                    for (Queue queue : listQueues) {
                        existQueueKeys.put(queue.getKey(), connect.getKey());
                    }
                }
                StatListenCommitQueue.this.statQueueCommit(txContainer, tx, (InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), existQueueKeys);
                StatListenCommitQueue.this.deleteAllNotPresentedNodes((InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), tx, Collections.unmodifiableMap(existQueueKeys));
                StatListenCommitQueue.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitQueue.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statQueueCommit(Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer, ReadWriteTransaction tx, InstanceIdentifier<Node> nodeIdent, Map<QueueKey, NodeConnectorKey> existQueueKeys) {
        List queueStats;
        TransactionAware notif;
        Preconditions.checkNotNull(existQueueKeys);
        Preconditions.checkNotNull(txContainer);
        Preconditions.checkNotNull(nodeIdent);
        Preconditions.checkNotNull((Object)tx);
        List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
        Iterator iterator = cacheNotifs.iterator();
        while (iterator.hasNext() && (notif = (TransactionAware)iterator.next()) instanceof QueueStatisticsUpdate && (queueStats = ((QueueStatisticsUpdate)notif).getQueueIdAndStatisticsMap()) != null) {
            for (QueueIdAndStatisticsMap queueStat : queueStats) {
                if (queueStat.getQueueId() == null) continue;
                FlowCapableNodeConnectorQueueStatistics statChild = new FlowCapableNodeConnectorQueueStatisticsBuilder((GenericQueueStatistics)queueStat).build();
                FlowCapableNodeConnectorQueueStatisticsDataBuilder statBuild = new FlowCapableNodeConnectorQueueStatisticsDataBuilder();
                statBuild.setFlowCapableNodeConnectorQueueStatistics(statChild);
                QueueKey qKey = new QueueKey(queueStat.getQueueId());
                KeyedInstanceIdentifier queueIdent = nodeIdent.child(NodeConnector.class, (Identifier)new NodeConnectorKey(queueStat.getNodeConnectorId())).augmentation(FlowCapableNodeConnector.class).child(Queue.class, (Identifier)qKey);
                InstanceIdentifier queueStatIdent = queueIdent.augmentation(FlowCapableNodeConnectorQueueStatisticsData.class);
                existQueueKeys.remove(qKey);
                tx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)queueIdent, (DataObject)new QueueBuilder().setKey(qKey).build());
                tx.put(LogicalDatastoreType.OPERATIONAL, queueStatIdent, (DataObject)statBuild.build());
            }
        }
    }

    private void deleteAllNotPresentedNodes(InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction tx, Map<QueueKey, NodeConnectorKey> existQueueKeys) {
        Preconditions.checkNotNull(nodeIdent);
        Preconditions.checkNotNull((Object)tx);
        if (existQueueKeys == null) {
            return;
        }
        for (Map.Entry<QueueKey, NodeConnectorKey> entry : existQueueKeys.entrySet()) {
            KeyedInstanceIdentifier queueIdent = nodeIdent.child(NodeConnector.class, (Identifier)entry.getValue()).augmentation(FlowCapableNodeConnector.class).child(Queue.class, (Identifier)entry.getKey());
            LOG.trace("Queue {} has to removed.", (Object)queueIdent);
            Optional delQueue = Optional.absent();
            try {
                delQueue = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)queueIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Queue {} was probably deleted via another transaction. Exception {}", (Object)queueIdent, (Object)e);
            }
            if (!delQueue.isPresent()) continue;
            tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)queueIdent);
        }
    }
}

