/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractListenCommit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterConfigStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.MeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.MeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterConfigStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.config.stats.reply.MeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.reply.MeterStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatListenCommitMeter
extends StatAbstractListenCommit<org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter, OpendaylightMeterStatisticsListener>
implements OpendaylightMeterStatisticsListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatListenCommitMeter.class);

    public StatListenCommitMeter(StatisticsManager manager, DataBroker db, NotificationProviderService nps, StatNodeRegistration nrm) {
        super(manager, db, nps, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter.class, nrm);
    }

    @Override
    protected InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter> getWildCardedRegistrationPath() {
        return InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter.class);
    }

    @Override
    protected OpendaylightMeterStatisticsListener getStatNotificationListener() {
        return this;
    }

    public void onMeterConfigStatsUpdated(MeterConfigStatsUpdated notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - MeterConfigStatsUpdated: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
                Optional fNode = Optional.absent();
                try {
                    fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, fNodeIdent).checkedGet();
                }
                catch (ReadFailedException e) {
                    LOG.debug("Read Operational/DS for FlowCapableNode fail! {}", (Object)fNodeIdent, (Object)e);
                }
                if (!fNode.isPresent()) {
                    return;
                }
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitMeter.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitMeter.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitMeter.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List existMeters = ((FlowCapableNode)fNode.get()).getMeter() != null ? ((FlowCapableNode)fNode.get()).getMeter() : Collections.emptyList();
                ArrayList<MeterKey> existMeterKeys = new ArrayList<MeterKey>();
                for (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter meter : existMeters) {
                    existMeterKeys.add(meter.getKey());
                }
                StatListenCommitMeter.this.comitConfMeterStats(txContainer, tx, (InstanceIdentifier<FlowCapableNode>)fNodeIdent, existMeterKeys);
                StatListenCommitMeter.this.deleteAllNotPresentedNodes((InstanceIdentifier<FlowCapableNode>)fNodeIdent, tx, Collections.unmodifiableList(existMeterKeys));
                StatListenCommitMeter.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitMeter.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    public void onMeterFeaturesUpdated(MeterFeaturesUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        final TransactionId transId = notification.getTransactionId();
        final NodeId nodeId = notification.getId();
        if (!this.isExpectedStatistics(transId, nodeId)) {
            LOG.debug("STAT-MANAGER - MeterFeaturesUpdated: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                TransactionAware notif;
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitMeter.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitMeter.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                StatListenCommitMeter.this.manager.registerAdditionalNodeFeature((InstanceIdentifier<Node>)nodeIdent, StatPermCollector.StatCapabTypes.METER_STATS);
                if (!StatListenCommitMeter.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                Iterator iterator = cacheNotifs.iterator();
                while (iterator.hasNext() && (notif = (TransactionAware)iterator.next()) instanceof MeterFeaturesUpdated) {
                    MeterFeatures stats = new MeterFeaturesBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)((MeterFeaturesUpdated)notif)).build();
                    InstanceIdentifier nodeMeterFeatureIdent = nodeIdent.augmentation(NodeMeterFeatures.class);
                    InstanceIdentifier meterFeatureIdent = nodeMeterFeatureIdent.child(MeterFeatures.class);
                    Optional node = Optional.absent();
                    try {
                        node = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIdent).checkedGet();
                    }
                    catch (ReadFailedException e) {
                        LOG.debug("Read Operational/DS for Node fail! {}", (Object)nodeIdent, (Object)e);
                    }
                    if (node.isPresent()) {
                        tx.merge(LogicalDatastoreType.OPERATIONAL, nodeMeterFeatureIdent, (DataObject)new NodeMeterFeaturesBuilder().build(), true);
                        tx.put(LogicalDatastoreType.OPERATIONAL, meterFeatureIdent, (DataObject)stats);
                        StatListenCommitMeter.this.manager.unregisterNodeStats((InstanceIdentifier<Node>)nodeIdent, StatPermCollector.StatCapabTypes.METER_FEATURE_STATS);
                        continue;
                    }
                    LOG.debug("Node {} is NOT present in the operational data store", (Object)nodeId);
                }
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitMeter.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    public void onMeterStatisticsUpdated(MeterStatisticsUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        final TransactionId transId = notification.getTransactionId();
        final NodeId nodeId = notification.getId();
        if (!this.isExpectedStatistics(transId, nodeId)) {
            LOG.debug("STAT-MANAGER - MeterStatisticsUpdated: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                TransactionAware notif;
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                Optional node = Optional.absent();
                try {
                    node = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIdent).checkedGet();
                }
                catch (ReadFailedException e) {
                    LOG.debug("Read Operational/DS for Node fail! {}", (Object)nodeIdent, (Object)e);
                }
                if (!node.isPresent()) {
                    return;
                }
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitMeter.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitMeter.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitMeter.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                Optional notifMeter = Optional.absent();
                Optional<DataObject> inputObj = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getConfInput();
                if (inputObj.isPresent() && inputObj.get() instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter) {
                    notifMeter = Optional.of((Object)((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter)inputObj.get()));
                }
                Iterator iterator = cacheNotifs.iterator();
                while (iterator.hasNext() && (notif = (TransactionAware)iterator.next()) instanceof MeterStatisticsUpdated) {
                    StatListenCommitMeter.this.statMeterCommit(((MeterStatisticsUpdated)notif).getMeterStats(), (InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), tx);
                }
                if (!notifMeter.isPresent()) {
                    StatListenCommitMeter.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
                }
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitMeter.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statMeterCommit(List<MeterStats> meterStats, InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction tx) {
        Preconditions.checkNotNull(meterStats);
        Preconditions.checkNotNull(nodeIdent);
        Preconditions.checkNotNull((Object)tx);
        InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
        for (MeterStats mStat : meterStats) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterStatistics stats = new MeterStatisticsBuilder((MeterStatistics)mStat).build();
            KeyedInstanceIdentifier meterIdent = fNodeIdent.child(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter.class, (Identifier)new MeterKey(mStat.getMeterId()));
            InstanceIdentifier nodeMeterStatIdent = meterIdent.augmentation(NodeMeterStatistics.class);
            InstanceIdentifier msIdent = nodeMeterStatIdent.child(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterStatistics.class);
            Optional meter = Optional.absent();
            try {
                meter = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)meterIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Read Operational/DS for FlowCapableNode fail! {}", (Object)fNodeIdent, (Object)e);
            }
            if (!meter.isPresent()) continue;
            tx.merge(LogicalDatastoreType.OPERATIONAL, nodeMeterStatIdent, (DataObject)new NodeMeterStatisticsBuilder().build(), true);
            tx.put(LogicalDatastoreType.OPERATIONAL, msIdent, (DataObject)stats);
        }
    }

    private void comitConfMeterStats(Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer, ReadWriteTransaction tx, InstanceIdentifier<FlowCapableNode> fNodeIdent, List<MeterKey> existMeterKeys) {
        List meterStats;
        TransactionAware notif;
        Preconditions.checkNotNull(existMeterKeys);
        Preconditions.checkNotNull(txContainer);
        Preconditions.checkNotNull(fNodeIdent);
        Preconditions.checkNotNull((Object)tx);
        List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
        Iterator iterator = cacheNotifs.iterator();
        while (iterator.hasNext() && (notif = (TransactionAware)iterator.next()) instanceof MeterConfigStatsUpdated && (meterStats = ((MeterConfigStatsUpdated)notif).getMeterConfigStats()) != null) {
            for (MeterConfigStats meterStat : meterStats) {
                if (meterStat.getMeterId() == null) continue;
                MeterBuilder meterBuilder = new MeterBuilder((Meter)meterStat);
                MeterKey meterKey = new MeterKey(meterStat.getMeterId());
                KeyedInstanceIdentifier meterRef = fNodeIdent.child(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter.class, (Identifier)meterKey);
                NodeMeterConfigStatsBuilder meterConfig = new NodeMeterConfigStatsBuilder();
                meterConfig.setMeterConfigStats(new MeterConfigStatsBuilder((Meter)meterStat).build());
                meterBuilder.addAugmentation(NodeMeterConfigStats.class, (Augmentation)meterConfig.build());
                existMeterKeys.remove(meterKey);
                tx.put(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)meterRef, (DataObject)meterBuilder.build());
            }
        }
    }

    private void deleteAllNotPresentedNodes(InstanceIdentifier<FlowCapableNode> fNodeIdent, ReadWriteTransaction tx, List<MeterKey> deviceMeterKeys) {
        Preconditions.checkNotNull(fNodeIdent);
        Preconditions.checkNotNull((Object)tx);
        if (deviceMeterKeys == null) {
            return;
        }
        for (MeterKey key : deviceMeterKeys) {
            KeyedInstanceIdentifier delMeterIdent = fNodeIdent.child(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter.class, (Identifier)key);
            LOG.trace("Meter {} has to removed.", (Object)key);
            Optional delMeter = Optional.absent();
            try {
                delMeter = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)delMeterIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Meter {} was probably deleted via other transaction. Exception {}", (Object)delMeterIdent, (Object)e);
            }
            if (!delMeter.isPresent()) continue;
            tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)delMeterIdent);
        }
    }
}

