/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager;

import java.util.List;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipService;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatListeningCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNotifyCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatisticsManagerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsListener;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public interface StatisticsManager
extends AutoCloseable,
TransactionChainListener {
    public void start(NotificationProviderService var1, RpcConsumerRegistry var2);

    public void enqueue(StatDataStoreOperation var1);

    public boolean isProvidedFlowNodeActive(InstanceIdentifier<Node> var1);

    public void collectNextStatistics(InstanceIdentifier<Node> var1, TransactionId var2);

    public void connectedNodeRegistration(InstanceIdentifier<Node> var1, List<StatPermCollector.StatCapabTypes> var2, Short var3);

    public void disconnectedNodeUnregistration(InstanceIdentifier<Node> var1);

    public void registerAdditionalNodeFeature(InstanceIdentifier<Node> var1, StatPermCollector.StatCapabTypes var2);

    public void unregisterNodeStats(InstanceIdentifier<Node> var1, StatPermCollector.StatCapabTypes var2);

    public StatRpcMsgManager getRpcMsgManager();

    public StatNodeRegistration getNodeRegistrator();

    public StatListeningCommiter<Flow, OpendaylightFlowStatisticsListener> getFlowListenComit();

    public StatListeningCommiter<Meter, OpendaylightMeterStatisticsListener> getMeterListenCommit();

    public StatListeningCommiter<Group, OpendaylightGroupStatisticsListener> getGroupListenCommit();

    public StatListeningCommiter<Queue, OpendaylightQueueStatisticsListener> getQueueNotifyCommit();

    public StatNotifyCommiter<OpendaylightFlowTableStatisticsListener> getTableNotifCommit();

    public StatNotifyCommiter<OpendaylightPortStatisticsListener> getPortNotifyCommit();

    public StatisticsManagerConfig getConfiguration();

    public UUID getGeneratedUUIDForNode(InstanceIdentifier<Node> var1);

    public void setOwnershipService(EntityOwnershipService var1);

    public EntityOwnershipService getOwnershipService();

    public static class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair pairo = (Pair)o;
            return this.left.equals(pairo.getLeft()) && this.right.equals(pairo.getRight());
        }
    }

    public static abstract class StatDataStoreOperation {
        private NodeId nodeId;
        private StatsManagerOperationType operationType = StatsManagerOperationType.DATA_COMMIT_OPER_DS;
        private UUID nodeUUID;

        public StatDataStoreOperation(StatsManagerOperationType operType, NodeId id) {
            if (operType != null) {
                this.operationType = operType;
            }
            this.nodeId = id;
            this.nodeUUID = this.generatedUUIDForNode();
        }

        public final StatsManagerOperationType getType() {
            return this.operationType;
        }

        public final NodeId getNodeId() {
            return this.nodeId;
        }

        public UUID getNodeUUID() {
            return this.nodeUUID;
        }

        public abstract void applyOperation(ReadWriteTransaction var1);

        protected abstract UUID generatedUUIDForNode();

        public InstanceIdentifier<Node> getNodeIdentifier() {
            KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(this.nodeId));
            return nodeIdent;
        }

        public static enum StatsManagerOperationType {
            NODE_UPDATE,
            NODE_REMOVAL,
            DATA_COMMIT_OPER_DS;

        }
    }
}

