/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatListeningCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNotifyCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatListenCommitFlow;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatListenCommitGroup;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatListenCommitMeter;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatListenCommitQueue;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatNodeRegistrationImpl;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatNotifyCommitPort;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatNotifyCommitTable;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatPermCollectorImpl;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatRpcMsgManagerImpl;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatisticsManagerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsListener;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsManagerImpl
implements StatisticsManager,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsManagerImpl.class);
    private static final int QUEUE_DEPTH = 5000;
    private static final int MAX_BATCH = 100;
    private final BlockingQueue<StatisticsManager.StatDataStoreOperation> dataStoreOperQueue = new LinkedBlockingDeque<StatisticsManager.StatDataStoreOperation>(5000);
    private final Map<InstanceIdentifier<Node>, StatisticsManager.Pair<StatPermCollector, UUID>> nodeCollectorMap = new ConcurrentHashMap<InstanceIdentifier<Node>, StatisticsManager.Pair<StatPermCollector, UUID>>();
    private AtomicInteger numNodesBeingCollected = new AtomicInteger(0);
    private final DataBroker dataBroker;
    private final ExecutorService statRpcMsgManagerExecutor;
    private final ExecutorService statDataStoreOperationServ;
    private StatRpcMsgManager rpcMsgManager;
    private List<StatPermCollector> statCollectors;
    private final Object statCollectorLock = new Object();
    private BindingTransactionChain txChain;
    private volatile boolean finishing = false;
    private StatNodeRegistration nodeRegistrator;
    private StatListeningCommiter<Flow, OpendaylightFlowStatisticsListener> flowListeningCommiter;
    private StatListeningCommiter<Meter, OpendaylightMeterStatisticsListener> meterListeningCommiter;
    private StatListeningCommiter<Group, OpendaylightGroupStatisticsListener> groupListeningCommiter;
    private StatListeningCommiter<Queue, OpendaylightQueueStatisticsListener> queueNotifyCommiter;
    private StatNotifyCommiter<OpendaylightFlowTableStatisticsListener> tableNotifCommiter;
    private StatNotifyCommiter<OpendaylightPortStatisticsListener> portNotifyCommiter;
    private final StatisticsManagerConfig statManagerConfig;

    public StatisticsManagerImpl(DataBroker dataBroker, StatisticsManagerConfig statManagerconfig) {
        this.statManagerConfig = (StatisticsManagerConfig)Preconditions.checkNotNull((Object)statManagerconfig);
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker, (Object)"DataBroker can not be null!");
        ThreadFactory threadFact = new ThreadFactoryBuilder().setNameFormat("odl-stat-rpc-oper-thread-%d").build();
        this.statRpcMsgManagerExecutor = Executors.newSingleThreadExecutor(threadFact);
        threadFact = new ThreadFactoryBuilder().setNameFormat("odl-stat-ds-oper-thread-%d").build();
        this.statDataStoreOperationServ = Executors.newSingleThreadExecutor(threadFact);
        this.txChain = dataBroker.createTransactionChain((TransactionChainListener)this);
    }

    @Override
    public void start(NotificationProviderService notifService, RpcConsumerRegistry rpcRegistry) {
        Preconditions.checkArgument((rpcRegistry != null ? 1 : 0) != 0, (Object)"RpcConsumerRegistry can not be null !");
        this.rpcMsgManager = new StatRpcMsgManagerImpl(this, rpcRegistry, this.statManagerConfig.getMaxNodesForCollector());
        this.statCollectors = Collections.emptyList();
        this.nodeRegistrator = new StatNodeRegistrationImpl(this, this.dataBroker, notifService);
        this.flowListeningCommiter = new StatListenCommitFlow(this, this.dataBroker, notifService);
        this.meterListeningCommiter = new StatListenCommitMeter(this, this.dataBroker, notifService);
        this.groupListeningCommiter = new StatListenCommitGroup(this, this.dataBroker, notifService);
        this.tableNotifCommiter = new StatNotifyCommitTable(this, notifService);
        this.portNotifyCommiter = new StatNotifyCommitPort(this, notifService);
        this.queueNotifyCommiter = new StatListenCommitQueue(this, this.dataBroker, notifService);
        this.statRpcMsgManagerExecutor.execute(this.rpcMsgManager);
        this.statDataStoreOperationServ.execute(this);
        LOG.info("Statistics Manager started successfully!");
    }

    private <T extends AutoCloseable> T close(T closeable) throws Exception {
        if (closeable != null) {
            closeable.close();
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        LOG.info("StatisticsManager close called");
        this.finishing = true;
        this.nodeRegistrator = this.close(this.nodeRegistrator);
        this.flowListeningCommiter = this.close(this.flowListeningCommiter);
        this.meterListeningCommiter = this.close(this.meterListeningCommiter);
        this.groupListeningCommiter = this.close(this.groupListeningCommiter);
        this.tableNotifCommiter = this.close(this.tableNotifCommiter);
        this.portNotifyCommiter = this.close(this.portNotifyCommiter);
        this.queueNotifyCommiter = this.close(this.queueNotifyCommiter);
        if (this.statCollectors != null) {
            for (StatPermCollector collector : this.statCollectors) {
                StatPermCollector statPermCollector = this.close(collector);
            }
            this.statCollectors = null;
        }
        this.rpcMsgManager = this.close(this.rpcMsgManager);
        this.statRpcMsgManagerExecutor.shutdown();
        this.statDataStoreOperationServ.shutdown();
        this.txChain = this.close(this.txChain);
    }

    @Override
    public void enqueue(StatisticsManager.StatDataStoreOperation op) {
        boolean success = this.dataStoreOperQueue.offer(op);
        if (!success) {
            LOG.debug("Stat DS/Operational submitter Queue is full!");
        }
    }

    @Override
    public void run() {
        while (!this.finishing) {
            StatisticsManager.StatDataStoreOperation op = null;
            try {
                op = this.dataStoreOperQueue.take();
                ReadWriteTransaction tx = this.txChain.newReadWriteTransaction();
                LOG.trace("New operations available, starting transaction {}", tx.getIdentifier());
                int ops = 0;
                do {
                    StatisticsManager.Pair<StatPermCollector, UUID> statPermCollectorUUIDPair;
                    if ((statPermCollectorUUIDPair = this.nodeCollectorMap.get(op.getNodeIdentifier())) != null && statPermCollectorUUIDPair.getRight().equals(op.getNodeUUID())) {
                        op.applyOperation(tx);
                        ++ops;
                        continue;
                    }
                    LOG.debug("{} not found or UUID mismatch for statistics datastore operation", op.getNodeIdentifier());
                } while ((op = ops < 100 ? (StatisticsManager.StatDataStoreOperation)this.dataStoreOperQueue.poll() : null) != null);
                LOG.trace("Processed {} operations, submitting transaction {}", (Object)ops, tx.getIdentifier());
                tx.submit().checkedGet();
            }
            catch (InterruptedException e) {
                LOG.warn("Stat Manager DS Operation thread interrupted, while waiting for StatDataStore Operation task!", (Throwable)e);
                this.finishing = true;
            }
            catch (Exception e) {
                LOG.warn("Unhandled exception during processing statistics for {}. Restarting transaction chain.", (Object)(op != null ? op.getNodeId().getValue() : ""), (Object)e);
                this.txChain.close();
                this.txChain = this.dataBroker.createTransactionChain((TransactionChainListener)this);
                this.cleanDataStoreOperQueue();
            }
        }
        this.cleanDataStoreOperQueue();
    }

    private synchronized void cleanDataStoreOperQueue() {
        while (!this.dataStoreOperQueue.isEmpty()) {
            this.dataStoreOperQueue.poll();
        }
    }

    public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
        LOG.warn("Failed to export Flow Capable Statistics, Transaction {} failed.", transaction.getIdentifier(), (Object)cause);
    }

    public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
    }

    @Override
    public boolean isProvidedFlowNodeActive(InstanceIdentifier<Node> nodeIdent) {
        for (StatPermCollector collector : this.statCollectors) {
            if (!collector.isProvidedFlowNodeActive(nodeIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collectNextStatistics(InstanceIdentifier<Node> nodeIdent, TransactionId xid) {
        for (StatPermCollector collector : this.statCollectors) {
            if (!collector.isProvidedFlowNodeActive(nodeIdent)) continue;
            collector.collectNextStatistics(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectedNodeRegistration(InstanceIdentifier<Node> nodeIdent, List<StatPermCollector.StatCapabTypes> statTypes, Short nrOfSwitchTables) {
        StatisticsManager.Pair<StatPermCollector, UUID> collectorUUIDPair = this.nodeCollectorMap.get(nodeIdent);
        if (collectorUUIDPair == null) {
            Object object = this.statCollectorLock;
            synchronized (object) {
                for (int i = this.statCollectors.size() - 1; i >= 0; --i) {
                    StatPermCollector aCollector = this.statCollectors.get(i);
                    if (!aCollector.connectedNodeRegistration(nodeIdent, statTypes, nrOfSwitchTables)) continue;
                    this.nodeCollectorMap.put(nodeIdent, new StatisticsManager.Pair<StatPermCollector, UUID>(aCollector, UUID.randomUUID()));
                    LOG.debug("NodeAdded: Num Nodes Registered with StatisticsManager:{}", (Object)this.numNodesBeingCollected.incrementAndGet());
                    return;
                }
                LOG.info("No existing collector found for new node. Creating a new collector for {}", nodeIdent);
                StatPermCollectorImpl newCollector = new StatPermCollectorImpl(this, this.statManagerConfig.getMinRequestNetMonitorInterval(), this.statCollectors.size() + 1, this.statManagerConfig.getMaxNodesForCollector());
                ArrayList<StatPermCollector> statCollectorsNew = new ArrayList<StatPermCollector>(this.statCollectors);
                statCollectorsNew.add(newCollector);
                this.statCollectors = Collections.unmodifiableList(statCollectorsNew);
                this.nodeCollectorMap.put(nodeIdent, new StatisticsManager.Pair<StatPermCollectorImpl, UUID>(newCollector, UUID.randomUUID()));
                LOG.debug("NodeAdded: Num Nodes Registered with StatisticsManager:{}", (Object)this.numNodesBeingCollected.incrementAndGet());
                newCollector.connectedNodeRegistration(nodeIdent, statTypes, nrOfSwitchTables);
            }
        } else {
            collectorUUIDPair.getLeft().connectedNodeRegistration(nodeIdent, statTypes, nrOfSwitchTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectedNodeUnregistration(InstanceIdentifier<Node> nodeIdent) {
        this.flowListeningCommiter.cleanForDisconnect(nodeIdent);
        StatisticsManager.Pair<StatPermCollector, UUID> collectorUUIDPair = this.nodeCollectorMap.get(nodeIdent);
        if (collectorUUIDPair != null) {
            StatPermCollector collector = collectorUUIDPair.getLeft();
            if (collector != null) {
                this.nodeCollectorMap.remove(nodeIdent);
                LOG.debug("NodeRemoved: Num Nodes Registered with StatisticsManager:{}", (Object)this.numNodesBeingCollected.decrementAndGet());
                if (collector.disconnectedNodeUnregistration(nodeIdent)) {
                    if (!collector.hasActiveNodes()) {
                        Object object = this.statCollectorLock;
                        synchronized (object) {
                            if (collector.hasActiveNodes()) {
                                return;
                            }
                            ArrayList<StatPermCollector> newStatColl = new ArrayList<StatPermCollector>(this.statCollectors);
                            newStatColl.remove(collector);
                            this.statCollectors = Collections.unmodifiableList(newStatColl);
                        }
                    }
                    LOG.info("Node:{} successfully removed by StatisticsManager ", nodeIdent);
                } else {
                    LOG.error("Collector not disconnecting for node, no operations will be committed for this node:{}", nodeIdent);
                }
            } else {
                LOG.error("Unexpected error, collector not found in collectorUUIDPair for node:{}, UUID:{}", nodeIdent, (Object)collectorUUIDPair.getRight());
            }
        } else {
            LOG.error("Received node removed for {}, but unable to find it in nodeCollectorMap", nodeIdent);
        }
    }

    @Override
    public void registerAdditionalNodeFeature(InstanceIdentifier<Node> nodeIdent, StatPermCollector.StatCapabTypes statCapab) {
        for (StatPermCollector collector : this.statCollectors) {
            if (!collector.registerAdditionalNodeFeature(nodeIdent, statCapab)) continue;
            return;
        }
        LOG.debug("Node {} has not been extended for feature {}!", nodeIdent, (Object)statCapab);
    }

    @Override
    public StatRpcMsgManager getRpcMsgManager() {
        return this.rpcMsgManager;
    }

    @Override
    public StatNodeRegistration getNodeRegistrator() {
        return this.nodeRegistrator;
    }

    @Override
    public StatListeningCommiter<Flow, OpendaylightFlowStatisticsListener> getFlowListenComit() {
        return this.flowListeningCommiter;
    }

    @Override
    public StatListeningCommiter<Meter, OpendaylightMeterStatisticsListener> getMeterListenCommit() {
        return this.meterListeningCommiter;
    }

    @Override
    public StatListeningCommiter<Group, OpendaylightGroupStatisticsListener> getGroupListenCommit() {
        return this.groupListeningCommiter;
    }

    @Override
    public StatListeningCommiter<Queue, OpendaylightQueueStatisticsListener> getQueueNotifyCommit() {
        return this.queueNotifyCommiter;
    }

    @Override
    public StatNotifyCommiter<OpendaylightFlowTableStatisticsListener> getTableNotifCommit() {
        return this.tableNotifCommiter;
    }

    @Override
    public StatNotifyCommiter<OpendaylightPortStatisticsListener> getPortNotifyCommit() {
        return this.portNotifyCommiter;
    }

    @Override
    public StatisticsManagerConfig getConfiguration() {
        return this.statManagerConfig;
    }

    @Override
    public UUID getGeneratedUUIDForNode(InstanceIdentifier<Node> nodeInstanceIdentifier) {
        StatisticsManager.Pair<StatPermCollector, UUID> permCollectorUUIDPair = this.nodeCollectorMap.get(nodeInstanceIdentifier);
        if (permCollectorUUIDPair != null) {
            return permCollectorUUIDPair.getRight();
        }
        return UUID.fromString("invalid-uuid");
    }
}

