/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatPermCollectorImpl
implements StatPermCollector {
    private static final Logger LOG = LoggerFactory.getLogger(StatPermCollectorImpl.class);
    private static final long STAT_COLLECT_TIME_OUT = 3000L;
    private static final long WAIT_BEFORE_COLLECTING_STATS = 5000L;
    private final ExecutorService statNetCollectorServ;
    private final StatisticsManager manager;
    private final int maxNodeForCollector;
    private final long minReqNetInterval;
    private final String name;
    private final Object statCollectorLock = new Object();
    private final Object statNodeHolderLock = new Object();
    private final Object transNotifyLock = new Object();
    private Map<InstanceIdentifier<Node>, StatNodeInfoHolder> statNodeHolder = Collections.emptyMap();
    private volatile boolean wakeMe = false;
    private volatile boolean finishing = false;
    private TransactionId actualTransactionId;

    public StatPermCollectorImpl(StatisticsManager manager, long minReqNetInterv, int nr, int maxNodeForCollectors) {
        this.manager = (StatisticsManager)Preconditions.checkNotNull((Object)manager, (Object)"StatisticsManager can not be null!");
        this.name = "odl-stat-collector-" + nr;
        this.minReqNetInterval = minReqNetInterv;
        ThreadFactory threadFact = new ThreadFactoryBuilder().setNameFormat(this.name + "-thread-%d").build();
        this.statNetCollectorServ = Executors.newSingleThreadExecutor(threadFact);
        this.maxNodeForCollector = maxNodeForCollectors;
        LOG.trace("StatCollector {} start successfull!", (Object)this.name);
    }

    @Override
    public void close() {
        this.statNodeHolder = Collections.emptyMap();
        this.finishing = true;
        this.collectNextStatistics(this.actualTransactionId);
        this.statNetCollectorServ.shutdown();
    }

    @Override
    public boolean hasActiveNodes() {
        return !this.statNodeHolder.isEmpty();
    }

    @Override
    public boolean isProvidedFlowNodeActive(InstanceIdentifier<Node> flowNode) {
        return this.statNodeHolder.containsKey(flowNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectedNodeRegistration(InstanceIdentifier<Node> ident, List<StatPermCollector.StatCapabTypes> statTypes, Short nrOfSwitchTables) {
        if (this.isNodeIdentValidForUse(ident) && !this.statNodeHolder.containsKey(ident)) {
            Object object = this.statNodeHolderLock;
            synchronized (object) {
                boolean startStatCollecting;
                boolean bl = startStatCollecting = this.statNodeHolder.size() == 0;
                if (!this.statNodeHolder.containsKey(ident)) {
                    if (this.statNodeHolder.size() >= this.maxNodeForCollector) {
                        return false;
                    }
                    HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder> statNode = new HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder>(this.statNodeHolder);
                    NodeRef nodeRef = new NodeRef(ident);
                    StatNodeInfoHolder nodeInfoHolder = new StatNodeInfoHolder(nodeRef, statTypes, nrOfSwitchTables);
                    statNode.put(ident, nodeInfoHolder);
                    this.statNodeHolder = Collections.unmodifiableMap(statNode);
                }
                if (startStatCollecting) {
                    this.finishing = false;
                    this.statNetCollectorServ.execute(this);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnectedNodeUnregistration(InstanceIdentifier<Node> ident) {
        if (this.isNodeIdentValidForUse(ident) && this.statNodeHolder.containsKey(ident)) {
            Object object = this.statNodeHolderLock;
            synchronized (object) {
                if (this.statNodeHolder.containsKey(ident)) {
                    HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder> statNode = new HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder>(this.statNodeHolder);
                    statNode.remove(ident);
                    this.statNodeHolder = Collections.unmodifiableMap(statNode);
                }
                if (this.statNodeHolder.isEmpty()) {
                    this.finishing = true;
                    this.collectNextStatistics(this.actualTransactionId);
                    this.statNetCollectorServ.shutdown();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerAdditionalNodeFeature(InstanceIdentifier<Node> ident, StatPermCollector.StatCapabTypes statCapab) {
        if (this.isNodeIdentValidForUse(ident)) {
            if (!this.statNodeHolder.containsKey(ident)) {
                return false;
            }
            StatNodeInfoHolder statNode = this.statNodeHolder.get(ident);
            if (!statNode.getStatMarkers().contains((Object)statCapab)) {
                Object object = this.statNodeHolderLock;
                synchronized (object) {
                    if (!statNode.getStatMarkers().contains((Object)statCapab)) {
                        ArrayList<StatPermCollector.StatCapabTypes> statCapabForEdit = new ArrayList<StatPermCollector.StatCapabTypes>(statNode.getStatMarkers());
                        statCapabForEdit.add(statCapab);
                        StatNodeInfoHolder nodeInfoHolder = new StatNodeInfoHolder(statNode.getNodeRef(), Collections.unmodifiableList(statCapabForEdit), statNode.getMaxTables());
                        HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder> statNodes = new HashMap<InstanceIdentifier<Node>, StatNodeInfoHolder>(this.statNodeHolder);
                        statNodes.put(ident, nodeInfoHolder);
                        this.statNodeHolder = Collections.unmodifiableMap(statNodes);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectNextStatistics(TransactionId xid) {
        if (this.checkTransactionId(xid) && this.wakeMe) {
            Object object = this.statCollectorLock;
            synchronized (object) {
                if (this.wakeMe) {
                    LOG.trace("STAT-COLLECTOR is notified to conntinue");
                    this.statCollectorLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("StatCollector {} Start collecting!", (Object)this.name);
        while (!this.finishing) {
            boolean collecting = false;
            long startTime = System.currentTimeMillis();
            if (!this.statNodeHolder.isEmpty()) {
                collecting = true;
                this.collectStatCrossNetwork();
                collecting = false;
            }
            if (collecting) continue;
            long statFinalTime = System.currentTimeMillis() - startTime;
            LOG.debug("STAT-MANAGER {}: last all NET statistics collection cost {} ms", (Object)this.name, (Object)statFinalTime);
            if (statFinalTime >= this.minReqNetInterval) continue;
            LOG.trace("statCollector is about to make a collecting sleep");
            Object object = this.statCollectorLock;
            synchronized (object) {
                this.wakeMe = true;
                try {
                    long waitTime = this.minReqNetInterval - statFinalTime;
                    this.statCollectorLock.wait(waitTime);
                    LOG.trace("STAT-MANAGER : statCollector {} is waking up from a collecting sleep for {} ms", (Object)this.name, (Object)waitTime);
                }
                catch (InterruptedException e) {
                    LOG.warn("statCollector has been interrupted during collecting sleep", (Throwable)e);
                }
                finally {
                    this.wakeMe = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitingForNotification() {
        Object object = this.statCollectorLock;
        synchronized (object) {
            this.wakeMe = true;
            try {
                this.statCollectorLock.wait(3000L);
                LOG.trace("statCollector is waking up from a wait stat Response sleep");
            }
            catch (InterruptedException e) {
                LOG.warn("statCollector has been interrupted waiting stat Response sleep", (Throwable)e);
            }
            finally {
                this.setActualTransactionId(null);
                this.wakeMe = false;
            }
        }
    }

    private void collectStatCrossNetwork() {
        block10: for (Map.Entry<InstanceIdentifier<Node>, StatNodeInfoHolder> nodeEntity : this.statNodeHolder.entrySet()) {
            List<StatPermCollector.StatCapabTypes> listNeededStat = nodeEntity.getValue().getStatMarkers();
            NodeRef actualNodeRef = nodeEntity.getValue().getNodeRef();
            Short maxTables = nodeEntity.getValue().getMaxTables();
            block11: for (StatPermCollector.StatCapabTypes statMarker : listNeededStat) {
                if (!this.isProvidedFlowNodeActive(nodeEntity.getKey())) continue block10;
                try {
                    switch (statMarker) {
                        case PORT_STATS: {
                            LOG.trace("STAT-MANAGER-collecting PORT-STATS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllPortsStat(actualNodeRef).get());
                            this.waitingForNotification();
                            break;
                        }
                        case QUEUE_STATS: {
                            LOG.trace("STAT-MANAGER-collecting QUEUE-STATS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllQueueStat(actualNodeRef).get());
                            this.waitingForNotification();
                            break;
                        }
                        case TABLE_STATS: {
                            LOG.trace("STAT-MANAGER-collecting TABLE-STATS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllTablesStat(actualNodeRef).get());
                            this.waitingForNotification();
                            break;
                        }
                        case GROUP_STATS: {
                            LOG.trace("STAT-MANAGER-collecting GROUP-STATS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllGroupsConfStats(actualNodeRef).get());
                            this.waitingForNotification();
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllGroupsStat(actualNodeRef).get());
                            this.waitingForNotification();
                            break;
                        }
                        case METER_STATS: {
                            LOG.trace("STAT-MANAGER-collecting METER-STATS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllMeterConfigStat(actualNodeRef).get());
                            this.waitingForNotification();
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllMetersStat(actualNodeRef).get());
                            this.waitingForNotification();
                            break;
                        }
                        case FLOW_STATS: {
                            LOG.trace("STAT-MANAGER-collecting FLOW-STATS-ALL_FLOWS for NodeRef {}", (Object)actualNodeRef);
                            this.setActualTransactionId(this.manager.getRpcMsgManager().getAllFlowsStat(actualNodeRef).get());
                            this.waitingForNotification();
                            LOG.trace("STAT-MANAGER-collecting FLOW-AGGREGATE-STATS for NodeRef {}", (Object)actualNodeRef);
                            for (short i = 0; i < maxTables; i = (short)(i + 1)) {
                                TableId tableId = new TableId(Short.valueOf(i));
                                this.manager.getRpcMsgManager().getAggregateFlowStat(actualNodeRef, tableId);
                            }
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException("Not implemented ASK for " + (Object)((Object)statMarker));
                        }
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.warn("Unexpected RPC exception by call RPC Future!", (Throwable)ex);
                }
            }
        }
    }

    private boolean isNodeIdentValidForUse(InstanceIdentifier<Node> ident) {
        if (ident == null) {
            LOG.warn("FlowCapableNode InstanceIdentifier {} can not be null!");
            return false;
        }
        if (ident.isWildcarded()) {
            LOG.warn("FlowCapableNode InstanceIdentifier {} can not be wildcarded!", ident);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTransactionId(TransactionId xid) {
        Object object = this.transNotifyLock;
        synchronized (object) {
            return this.actualTransactionId != null && this.actualTransactionId.equals((Object)xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActualTransactionId(TransactionId transactionId) {
        Object object = this.transNotifyLock;
        synchronized (object) {
            this.actualTransactionId = transactionId;
        }
    }

    private class StatNodeInfoHolder {
        private final NodeRef nodeRef;
        private final List<StatPermCollector.StatCapabTypes> statMarkers;
        private final Short maxTables;

        public StatNodeInfoHolder(NodeRef nodeRef, List<StatPermCollector.StatCapabTypes> statMarkers, Short maxTables) {
            this.nodeRef = nodeRef;
            this.maxTables = maxTables;
            this.statMarkers = statMarkers;
        }

        public final NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public final List<StatPermCollector.StatCapabTypes> getStatMarkers() {
            return this.statMarkers;
        }

        public final Short getMaxTables() {
            return this.maxTables;
        }
    }
}

