/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.info.PrefixList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.info.PrefixListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.info.prefix.list.Prefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PrefixListBuilder
implements Builder<PrefixList> {
    private PrefixListKey _key;
    private Short _order;
    private Prefix _prefix;
    Map<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>> augmentation = Collections.emptyMap();

    public PrefixListBuilder() {
    }

    public PrefixListBuilder(PrefixList base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PrefixListKey(base.getOrder());
            this._order = base.getOrder();
        } else {
            this._key = base.getKey();
            this._order = this._key.getOrder();
        }
        this._prefix = base.getPrefix();
        if (base instanceof PrefixListImpl) {
            PrefixListImpl impl = (PrefixListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>>(casted.augmentations());
        }
    }

    public PrefixListKey getKey() {
        return this._key;
    }

    public Short getOrder() {
        return this._order;
    }

    public Prefix getPrefix() {
        return this._prefix;
    }

    public <E extends Augmentation<PrefixList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PrefixListBuilder setKey(PrefixListKey value) {
        this._key = value;
        return this;
    }

    private static void checkOrderRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public PrefixListBuilder setOrder(Short value) {
        if (value != null) {
            PrefixListBuilder.checkOrderRange(value);
        }
        this._order = value;
        return this;
    }

    public PrefixListBuilder setPrefix(Prefix value) {
        this._prefix = value;
        return this;
    }

    public PrefixListBuilder addAugmentation(Class<? extends Augmentation<PrefixList>> augmentationType, Augmentation<PrefixList> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PrefixListBuilder removeAugmentation(Class<? extends Augmentation<PrefixList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PrefixList build() {
        return new PrefixListImpl(this);
    }

    private static final class PrefixListImpl
    implements PrefixList {
        private final PrefixListKey _key;
        private final Short _order;
        private final Prefix _prefix;
        private Map<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PrefixList> getImplementedInterface() {
            return PrefixList.class;
        }

        private PrefixListImpl(PrefixListBuilder base) {
            if (base.getKey() == null) {
                this._key = new PrefixListKey(base.getOrder());
                this._order = base.getOrder();
            } else {
                this._key = base.getKey();
                this._order = this._key.getOrder();
            }
            this._prefix = base.getPrefix();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>>(base.augmentation);
                }
            }
        }

        @Override
        public PrefixListKey getKey() {
            return this._key;
        }

        @Override
        public Short getOrder() {
            return this._order;
        }

        @Override
        public Prefix getPrefix() {
            return this._prefix;
        }

        public <E extends Augmentation<PrefixList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._order);
            result = 31 * result + Objects.hashCode(this._prefix);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PrefixList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PrefixList other = (PrefixList)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._order, other.getOrder())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PrefixListImpl otherImpl = (PrefixListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PrefixList>>, Augmentation<PrefixList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PrefixList [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._order != null) {
                builder.append("_order=");
                builder.append(this._order);
                builder.append(", ");
            }
            if (this._prefix != null) {
                builder.append("_prefix=");
                builder.append(this._prefix);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

