/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.nic.compiler;

import java.util.Set;
import org.opendaylight.nic.compiler.api.Action;
import org.opendaylight.nic.compiler.api.Endpoint;
import org.opendaylight.nic.compiler.api.Policy;

public class PolicyImpl
implements Policy {
    private Set<Endpoint> src;
    private Set<Endpoint> dst;
    Action action;

    public PolicyImpl(Set<Endpoint> src, Set<Endpoint> dst, Action action) {
        this.src = src;
        this.dst = dst;
        this.action = action;
    }

    @Override
    public Set<Endpoint> src() {
        return this.src;
    }

    @Override
    public Set<Endpoint> dst() {
        return this.dst;
    }

    @Override
    public Action action() {
        return this.action;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PolicyImpl policy = (PolicyImpl)object;
        if (this.src != null ? !this.src.equals(policy.src) : policy.src != null) {
            return false;
        }
        if (this.dst != null ? !this.dst.equals(policy.dst) : policy.dst != null) {
            return false;
        }
        return this.action == policy.action;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.src != null ? this.src.hashCode() : 0;
        result = 31 * result + (this.dst != null ? this.dst.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("from %s to %s apply %s", new Object[]{this.src, this.dst, this.action});
    }
}

