/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.CheckedFuture;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.netvirt.openstack.netvirt.providers.ConfigInterface;
import org.opendaylight.netvirt.openstack.netvirt.providers.openflow13.AbstractServiceInstance;
import org.opendaylight.netvirt.openstack.netvirt.providers.openflow13.Service;
import org.opendaylight.netvirt.openstack.netvirt.sfc.ISfcClassifierService;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NshUtils;
import org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services.AclMatches;
import org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services.FlowCache;
import org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services.FlowNames;
import org.opendaylight.netvirt.utils.mdsal.openflow.ActionUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.FlowUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.InstructionUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.MatchUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.OutputPortValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.InstructionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.DstChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice.DstNxRegCaseBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcClassifierService
extends AbstractServiceInstance
implements ConfigInterface,
ISfcClassifierService {
    private static final Logger LOG = LoggerFactory.getLogger(SfcClassifierService.class);
    private static final short UDP_SHORT = 17;
    static int cookieIndex = 0;
    private FlowCache flowCache = new FlowCache();
    private static FlowID[] flowSet = new FlowID[]{FlowID.FLOW_INGRESSCLASS, FlowID.FLOW_EGRESSCLASS, FlowID.FLOW_EGRESSCLASSBYPASS, FlowID.FLOW_SFARP, FlowID.FLOW_SFINGRESS, FlowID.FLOW_SFEGRESS};

    private BigInteger getCookie(FlowID flowID) {
        String cookieString = String.format("1110%02d%010d", flowID.value, cookieIndex++);
        return new BigInteger(cookieString, 16);
    }

    private BigInteger getCookie(FlowID flowID, short nsp, short nsi) {
        String cookieString = String.format("1110%02d%03d%03d0%03d", flowID.value, 0, nsp, nsi);
        return new BigInteger(cookieString, 16);
    }

    public SfcClassifierService(Service service) {
        super(service);
    }

    public SfcClassifierService() {
        super(Service.SFC_CLASSIFIER);
    }

    public void setDependencies(BundleContext bundleContext, ServiceReference serviceReference) {
        super.setDependencies(bundleContext.getServiceReference(ISfcClassifierService.class.getName()), (AbstractServiceInstance)this);
    }

    public void setDependencies(Object impl) {
    }

    private FlowBuilder initFlowBuilder(FlowBuilder flowBuilder, String flowName, short table, FlowID flowID) {
        FlowUtils.initFlowBuilder((FlowBuilder)flowBuilder, (String)flowName, (short)table).setCookie(new FlowCookie(this.getCookie(flowID))).setCookieMask(new FlowCookie(this.getCookie(flowID)));
        return flowBuilder;
    }

    private FlowBuilder initFlowBuilder(FlowBuilder flowBuilder, String flowName, short table, FlowID flowID, short nsp, short nsi) {
        FlowUtils.initFlowBuilder((FlowBuilder)flowBuilder, (String)flowName, (short)table).setCookie(new FlowCookie(this.getCookie(flowID, nsp, nsi))).setCookieMask(new FlowCookie(this.getCookie(flowID, nsp, nsi)));
        return flowBuilder;
    }

    private void writeFlow(FlowBuilder flowBuilder, NodeBuilder nodeBuilder, String rspName, FlowID flowID) {
        this.flowCache.addFlow(flowBuilder, nodeBuilder, rspName, flowID.value);
        this.writeFlow(flowBuilder, nodeBuilder);
    }

    private void removeFlow(FlowBuilder flowBuilder, NodeBuilder nodeBuilder, String rspName, FlowID flowID) {
        this.flowCache.removeFlow(rspName, flowID.value);
        this.removeFlow(flowBuilder, nodeBuilder);
    }

    @Override
    public void programIngressClassifier(long dataPathId, String ruleName, Matches matches, long nsp, short nsi, NshUtils nshHeader, long vxGpeOfPort, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfcIngressClass(ruleName, nsp, nsi);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(), FlowID.FLOW_INGRESSCLASS, (short)nshHeader.getNshNsp(), nshHeader.getNshNsi());
        MatchBuilder matchBuilder = new AclMatches(matches).buildMatch();
        MatchUtils.addNxRegMatch((MatchBuilder)matchBuilder, (MatchUtils.RegMatch[])new MatchUtils.RegMatch[]{MatchUtils.RegMatch.of((Class)FlowUtils.REG_FIELD, (Long)1L)});
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            ActionBuilder ab = new ActionBuilder();
            ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action>();
            ab.setAction(ActionUtils.nxMoveTunIdtoNshc2());
            ab.setOrder(Integer.valueOf(actionList.size()));
            ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
            actionList.add(ab.build());
            this.getNshAction(nshHeader, actionList);
            if (vxGpeOfPort != 0L) {
                ab.setAction(ActionUtils.outputAction((NodeConnectorId)FlowUtils.getNodeConnectorId((long)dataPathId, (long)vxGpeOfPort)));
                ab.setOrder(Integer.valueOf(actionList.size()));
                ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
                actionList.add(ab.build());
            } else {
                ab.setAction(ActionUtils.nxResubmitAction(null, (Short)Service.CLASSIFIER.getTable()));
                ab.setOrder(Integer.valueOf(actionList.size()));
                ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
                actionList.add(ab.build());
            }
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            aab.setAction(actionList);
            InstructionBuilder ib = new InstructionBuilder();
            ib.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            ArrayList instructions = Lists.newArrayList();
            instructions.add(ib.build());
            InstructionsBuilder isb = new InstructionsBuilder();
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_INGRESSCLASS);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_INGRESSCLASS);
        }
    }

    @Override
    public void programSfcTable(long dataPathId, long vxGpeOfPort, short goToTableId, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfcTable(vxGpeOfPort);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(Service.CLASSIFIER), FlowID.FLOW_SFCTABLE).setPriority(Integer.valueOf(1000));
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dataPathId, (Long)vxGpeOfPort);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            InstructionBuilder ib = InstructionUtils.createGotoTableInstructions((InstructionBuilder)new InstructionBuilder(), (short)goToTableId);
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder);
        }
    }

    @Override
    public void programEgressClassifier1(long dataPathId, long vxGpeOfPort, long nsp, short nsi, int tunnelOfPort, int tunnelId, short gotoTableId, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfcEgressClass1(vxGpeOfPort);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(Service.CLASSIFIER), FlowID.FLOW_EGRESSCLASSUNUSED, (short)nsp, nsi);
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dataPathId, (Long)vxGpeOfPort);
        MatchUtils.addNxNspMatch((MatchBuilder)matchBuilder, (long)nsp);
        MatchUtils.addNxNsiMatch((MatchBuilder)matchBuilder, (short)nsi);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            InstructionBuilder ib = InstructionUtils.createGotoTableInstructions((InstructionBuilder)new InstructionBuilder(), (short)this.getTable());
            ib.setOrder(Integer.valueOf(instructions.size()));
            ib.setKey(new InstructionKey(Integer.valueOf(instructions.size())));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder);
        }
    }

    @Override
    public void programEgressClassifier(long dataPathId, long vxGpeOfPort, long nsp, short nsi, long sfOfPort, int tunnelId, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfcEgressClass(vxGpeOfPort, nsp, nsi);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(Service.SFC_CLASSIFIER), FlowID.FLOW_EGRESSCLASS, (short)nsp, nsi);
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dataPathId, (Long)vxGpeOfPort);
        MatchUtils.addNxNspMatch((MatchBuilder)matchBuilder, (long)nsp);
        MatchUtils.addNxNsiMatch((MatchBuilder)matchBuilder, (short)nsi);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            ArrayList actionList = Lists.newArrayList();
            ActionBuilder ab = new ActionBuilder();
            ab.setAction(ActionUtils.nxLoadRegAction((DstChoice)new DstNxRegCaseBuilder().setNxReg(FlowUtils.REG_FIELD).build(), (BigInteger)BigInteger.valueOf(1L)));
            ab.setOrder(Integer.valueOf(actionList.size()));
            ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxMoveNshc2ToTunId());
            ab.setOrder(Integer.valueOf(actionList.size()));
            ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxResubmitAction((Integer)((int)sfOfPort), (Short)this.getTable(Service.CLASSIFIER)));
            ab.setOrder(Integer.valueOf(actionList.size()));
            ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
            actionList.add(ab.build());
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            aab.setAction((List)actionList);
            InstructionBuilder ib = new InstructionBuilder();
            ib.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_EGRESSCLASS);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_EGRESSCLASS);
        }
    }

    @Override
    public void programEgressClassifierBypass(long dataPathId, long vxGpeOfPort, long nsp, short nsi, long sfOfPort, int tunnelId, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfcEgressClassBypass(nsp, nsi, sfOfPort);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(Service.CLASSIFIER), FlowID.FLOW_EGRESSCLASSBYPASS, (short)nsp, nsi).setPriority(Integer.valueOf(40000));
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dataPathId, (Long)sfOfPort);
        MatchUtils.addNxRegMatch((MatchBuilder)matchBuilder, (MatchUtils.RegMatch[])new MatchUtils.RegMatch[]{MatchUtils.RegMatch.of((Class)FlowUtils.REG_FIELD, (Long)1L)});
        MatchUtils.addNxNspMatch((MatchBuilder)matchBuilder, (long)nsp);
        MatchUtils.addNxNsiMatch((MatchBuilder)matchBuilder, (short)nsi);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            ActionBuilder ab = new ActionBuilder();
            Action popNshAction = ActionUtils.nxPopNshAction();
            ab.setAction(popNshAction);
            ab.setOrder(Integer.valueOf(0));
            ab.setKey(new ActionKey(Integer.valueOf(0)));
            ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action>();
            actionList.add(ab.build());
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            aab.setAction(actionList);
            InstructionBuilder popNshIb = new InstructionBuilder();
            popNshIb.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            popNshIb.setOrder(Integer.valueOf(0));
            popNshIb.setKey(new InstructionKey(Integer.valueOf(0)));
            InstructionBuilder mutableIb = this.getMutablePipelineInstructionBuilder();
            mutableIb.setOrder(Integer.valueOf(1));
            mutableIb.setKey(new InstructionKey(Integer.valueOf(1)));
            ArrayList instructions = Lists.newArrayList();
            instructions.add(popNshIb.build());
            instructions.add(mutableIb.build());
            InstructionsBuilder isb = new InstructionsBuilder();
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_EGRESSCLASSBYPASS);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_EGRESSCLASSBYPASS);
        }
    }

    @Override
    public void program_sfEgress(long dataPathId, int dstPort, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfEgress(dstPort);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(), FlowID.FLOW_SFEGRESS);
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createIpProtocolMatch((MatchBuilder)matchBuilder, (short)17);
        MatchUtils.addLayer4Match((MatchBuilder)matchBuilder, (int)17, (int)0, (int)dstPort);
        MatchUtils.addNxRegMatch((MatchBuilder)matchBuilder, (MatchUtils.RegMatch[])new MatchUtils.RegMatch[]{MatchUtils.RegMatch.of((Class)FlowUtils.REG_FIELD, (Long)1L)});
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionBuilder ib = new InstructionBuilder();
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            InstructionUtils.createLocalInstructions((InstructionBuilder)ib, (long)dataPathId);
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFEGRESS);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFEGRESS);
        }
    }

    @Override
    public void program_sfIngress(long dataPathId, int dstPort, long sfOfPort, String ipAddress, String sfDplName, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getSfIngress(dstPort, ipAddress);
        this.initFlowBuilder(flowBuilder, flowName, Service.CLASSIFIER.getTable(), FlowID.FLOW_SFINGRESS);
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createIpProtocolMatch((MatchBuilder)matchBuilder, (short)17);
        Ipv4Prefix ipCidr = MatchUtils.iPv4PrefixFromIPv4Address((String)ipAddress);
        MatchUtils.createDstL3IPv4Match((MatchBuilder)matchBuilder, (Ipv4Prefix)new Ipv4Prefix(ipCidr));
        MatchUtils.addLayer4Match((MatchBuilder)matchBuilder, (int)17, (int)0, (int)dstPort);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionBuilder ib = new InstructionBuilder();
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            InstructionUtils.createOutputPortInstructions((InstructionBuilder)ib, (Long)dataPathId, (Long)sfOfPort);
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFINGRESS);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFINGRESS);
        }
    }

    @Override
    public void programStaticArpEntry(long dataPathId, long ofPort, String macAddressStr, String ipAddress, String rspName, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dataPathId);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = FlowNames.getArpResponder(ipAddress);
        this.initFlowBuilder(flowBuilder, flowName, this.getTable(Service.ARP_RESPONDER), FlowID.FLOW_SFARP).setPriority(Integer.valueOf(1024));
        MacAddress macAddress = new MacAddress(macAddressStr);
        MatchBuilder matchBuilder = new MatchBuilder();
        MatchUtils.createInPortReservedMatch((MatchBuilder)matchBuilder, (Long)dataPathId, (String)OutputPortValues.LOCAL.toString());
        MatchUtils.createEtherTypeMatch((MatchBuilder)matchBuilder, (EtherType)new EtherType(Long.valueOf(2054L)));
        MatchUtils.createArpDstIpv4Match((MatchBuilder)matchBuilder, (Ipv4Prefix)MatchUtils.iPv4PrefixFromIPv4Address((String)ipAddress));
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            InstructionBuilder ib = new InstructionBuilder();
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            ActionBuilder ab = new ActionBuilder();
            ArrayList actionList = Lists.newArrayList();
            ab.setAction(ActionUtils.nxMoveEthSrcToEthDstAction());
            ab.setOrder(Integer.valueOf(0));
            ab.setKey(new ActionKey(Integer.valueOf(0)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.setDlSrcAction((MacAddress)new MacAddress(macAddress)));
            ab.setOrder(Integer.valueOf(1));
            ab.setKey(new ActionKey(Integer.valueOf(1)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxLoadArpOpAction((BigInteger)BigInteger.valueOf(2L)));
            ab.setOrder(Integer.valueOf(2));
            ab.setKey(new ActionKey(Integer.valueOf(2)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxMoveArpShaToArpThaAction());
            ab.setOrder(Integer.valueOf(3));
            ab.setKey(new ActionKey(Integer.valueOf(3)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxMoveArpSpaToArpTpaAction());
            ab.setOrder(Integer.valueOf(4));
            ab.setKey(new ActionKey(Integer.valueOf(4)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxLoadArpShaAction((MacAddress)macAddress));
            ab.setOrder(Integer.valueOf(5));
            ab.setKey(new ActionKey(Integer.valueOf(5)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.nxLoadArpSpaAction((String)ipAddress));
            ab.setOrder(Integer.valueOf(6));
            ab.setKey(new ActionKey(Integer.valueOf(6)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.outputAction((NodeConnectorId)FlowUtils.getSpecialNodeConnectorId((long)dataPathId, (String)OutputPortValues.INPORT.toString())));
            ab.setOrder(Integer.valueOf(7));
            ab.setKey(new ActionKey(Integer.valueOf(7)));
            actionList.add(ab.build());
            aab.setAction((List)actionList);
            ib.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFARP);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder, rspName, FlowID.FLOW_SFARP);
        }
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> getNshAction(NshUtils header, List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList) {
        Action pushNsh = ActionUtils.nxPushNshAction();
        Action nshMdtypeLoad = ActionUtils.nxLoadNshMdtypeAction((Short)1);
        Action nshNpLoad = ActionUtils.nxLoadNshNpAction((Short)3);
        Action nshC1Load = ActionUtils.nxLoadNshc1RegAction((Long)header.getNshMetaC1());
        Action nspLoad = ActionUtils.nxSetNspAction((Long)header.getNshNsp());
        Action nsiLoad = ActionUtils.nxSetNsiAction((Short)header.getNshNsi());
        Action loadChainTunVnid = ActionUtils.nxLoadTunIdAction((BigInteger)BigInteger.valueOf(header.getNshNsp()), (boolean)false);
        Action loadChainTunDest = ActionUtils.nxLoadTunIPv4Action((String)header.getNshTunIpDst().getValue(), (boolean)false);
        int count = actionList.size();
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(pushNsh).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(nshMdtypeLoad).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(nshNpLoad).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(nshC1Load).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(nspLoad).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(nsiLoad).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count++)).setAction(loadChainTunDest).build());
        actionList.add(new ActionBuilder().setKey(new ActionKey(Integer.valueOf(count))).setOrder(Integer.valueOf(count)).setAction(loadChainTunVnid).build());
        return actionList;
    }

    @Override
    public void clearFlows(DataBroker dataBroker, String rspName) {
        Map<Integer, InstanceIdentifier<Flow>> flowMap = this.flowCache.getFlows(rspName);
        if (flowMap != null) {
            for (FlowID flowID : flowSet) {
                InstanceIdentifier<Flow> path = flowMap.get(flowID.value);
                if (path == null) continue;
                this.flowCache.removeFlow(rspName, flowID.value);
                this.removeFlow(dataBroker, path);
            }
        }
    }

    private void removeFlow(DataBroker dataBroker, InstanceIdentifier<Flow> path) {
        WriteTransaction modification = dataBroker.newWriteOnlyTransaction();
        modification.delete(LogicalDatastoreType.CONFIGURATION, path);
        CheckedFuture commitFuture = modification.submit();
        try {
            commitFuture.get();
            LOG.debug("Transaction success for deletion of Flow {}", path);
        }
        catch (Exception e) {
            LOG.error("Failed to remove flow {}", path, (Object)e);
            modification.cancel();
        }
    }

    private static enum FlowID {
        FLOW_INGRESSCLASS(1),
        FLOW_SFINGRESS(2),
        FLOW_SFEGRESS(3),
        FLOW_SFARP(4),
        FLOW_EGRESSCLASSUNUSED(5),
        FLOW_EGRESSCLASS(6),
        FLOW_EGRESSCLASSBYPASS(7),
        FLOW_SFCTABLE(8);

        private int value;

        private FlowID(int value) {
            this.value = value;
        }
    }
}

