/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.netvirt.openstack.netvirt.api.Southbound;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NshUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.ActionUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.FlowUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.InstructionUtils;
import org.opendaylight.netvirt.utils.mdsal.openflow.MatchUtils;
import org.opendaylight.netvirt.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceEth;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceIp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version.AceIpv4;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.InstructionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.InstructionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg0;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.DstChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice.DstNxRegCaseBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(SfcClassifier.class);
    private DataBroker dataBroker;
    private Southbound southbound;
    private MdsalUtils mdsalUtils;
    public static final long REG_VALUE_FROM_LOCAL = 1L;
    public static final long REG_VALUE_FROM_REMOTE = 2L;
    public static final Class<? extends NxmNxReg> REG_FIELD = NxmNxReg0.class;
    private static final String OPENFLOW = "openflow:";

    public SfcClassifier(DataBroker dataBroker, Southbound southbound, MdsalUtils mdsalUtils) {
        this.dataBroker = dataBroker;
        this.southbound = southbound;
        this.mdsalUtils = mdsalUtils;
    }

    public void programSfcClassiferFlows(Long dpidLong, short writeTable, String ruleName, Matches match, NshUtils nshHeader, long tunnelOfPort, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dpidLong);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = "sfcClass_" + ruleName + "_" + nshHeader.getNshNsp();
        FlowUtils.initFlowBuilder((FlowBuilder)flowBuilder, (String)flowName, (short)writeTable);
        MatchBuilder matchBuilder = this.buildMatch(match);
        flowBuilder.setMatch(matchBuilder.build());
        if (write) {
            List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList = this.getNshAction(nshHeader);
            ActionBuilder ab = new ActionBuilder();
            ab.setAction(ActionUtils.outputAction((NodeConnectorId)FlowUtils.getNodeConnectorId((long)dpidLong, (long)tunnelOfPort)));
            ab.setOrder(Integer.valueOf(actionList.size()));
            ab.setKey(new ActionKey(Integer.valueOf(actionList.size())));
            actionList.add(ab.build());
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            aab.setAction(actionList);
            InstructionBuilder ib = new InstructionBuilder();
            ib.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            ArrayList instructions = Lists.newArrayList();
            instructions.add(ib.build());
            InstructionsBuilder isb = new InstructionsBuilder();
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder);
        }
    }

    public void programEgressSfcClassiferFlows(Long dpidLong, short writeTable, String ruleName, Matches match, NshUtils nshHeader, long tunnelOfPort, long outOfPort, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dpidLong);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = "egressSfcClass_" + ruleName + "_" + nshHeader.getNshNsp() + "_" + nshHeader.getNshNsi();
        FlowUtils.initFlowBuilder((FlowBuilder)flowBuilder, (String)flowName, (short)writeTable);
        MatchBuilder matchBuilder = new MatchBuilder();
        flowBuilder.setMatch(MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dpidLong, (Long)tunnelOfPort).build());
        flowBuilder.setMatch(MatchUtils.createTunnelIDMatch((MatchBuilder)matchBuilder, (BigInteger)BigInteger.valueOf(nshHeader.getNshMetaC2())).build());
        flowBuilder.setMatch(MatchUtils.addNxNspMatch((MatchBuilder)matchBuilder, (long)nshHeader.getNshNsp()).build());
        flowBuilder.setMatch(MatchUtils.addNxNsiMatch((MatchBuilder)matchBuilder, (short)nshHeader.getNshNsi()).build());
        if (write) {
            ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actionList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action>();
            ActionBuilder ab = new ActionBuilder();
            ab.setAction(ActionUtils.nxLoadRegAction((DstChoice)new DstNxRegCaseBuilder().setNxReg(REG_FIELD).build(), (BigInteger)BigInteger.valueOf(2L)));
            ab.setOrder(Integer.valueOf(0));
            ab.setKey(new ActionKey(Integer.valueOf(0)));
            actionList.add(ab.build());
            ab.setAction(ActionUtils.outputAction((NodeConnectorId)FlowUtils.getNodeConnectorId((long)dpidLong, (long)outOfPort)));
            ab.setOrder(Integer.valueOf(1));
            ab.setKey(new ActionKey(Integer.valueOf(1)));
            actionList.add(ab.build());
            ApplyActionsBuilder aab = new ApplyActionsBuilder();
            aab.setAction(actionList);
            InstructionBuilder ib = new InstructionBuilder();
            ib.setInstruction((Instruction)new ApplyActionsCaseBuilder().setApplyActions(aab.build()).build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction> instructions = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction>();
            instructions.add(ib.build());
            InstructionsBuilder isb = new InstructionsBuilder();
            isb.setInstruction(instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder);
        }
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> getNshAction(NshUtils header) {
        Action pushNsh = ActionUtils.nxPushNshAction();
        Action nshMdtypeLoad = ActionUtils.nxLoadNshMdtypeAction((Short)1);
        Action nshNpLoad = ActionUtils.nxLoadNshNpAction((Short)3);
        Action nshC1Load = ActionUtils.nxLoadNshc1RegAction((Long)header.getNshMetaC1());
        Action nshC2Load = ActionUtils.nxLoadNshc2RegAction((Long)header.getNshMetaC2());
        Action nspLoad = ActionUtils.nxSetNspAction((Long)header.getNshNsp());
        Action nsiLoad = ActionUtils.nxSetNsiAction((Short)header.getNshNsi());
        Action loadChainTunVnid = ActionUtils.nxLoadTunIdAction((BigInteger)BigInteger.valueOf(header.getNshNsp()), (boolean)false);
        Action loadChainTunDest = ActionUtils.nxLoadTunIPv4Action((String)header.getNshTunIpDst().getValue(), (boolean)false);
        int count = 0;
        ArrayList actionList = Lists.newArrayList();
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(pushNsh).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nshMdtypeLoad).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nshNpLoad).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nshC1Load).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nshC2Load).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nspLoad).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(nsiLoad).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(loadChainTunDest).build());
        actionList.add(new ActionBuilder().setOrder(Integer.valueOf(count++)).setAction(loadChainTunVnid).build());
        return actionList;
    }

    public void programLocalInPort(Long dpidLong, String segmentationId, Long inPort, short writeTable, short goToTableId, Matches match, boolean write) {
        NodeBuilder nodeBuilder = FlowUtils.createNodeBuilder((long)dpidLong);
        FlowBuilder flowBuilder = new FlowBuilder();
        String flowName = "sfcIngress_" + segmentationId + "_" + inPort;
        FlowUtils.initFlowBuilder((FlowBuilder)flowBuilder, (String)flowName, (short)writeTable);
        MatchBuilder matchBuilder = this.buildMatch(match);
        flowBuilder.setMatch(matchBuilder.build());
        flowBuilder.setMatch(MatchUtils.createInPortMatch((MatchBuilder)matchBuilder, (Long)dpidLong, (Long)inPort).build());
        if (write) {
            InstructionBuilder ib = new InstructionBuilder();
            InstructionsBuilder isb = new InstructionsBuilder();
            ArrayList instructions = Lists.newArrayList();
            InstructionUtils.createSetTunnelIdInstructions((InstructionBuilder)ib, (BigInteger)new BigInteger(segmentationId));
            ApplyActionsCase aac = (ApplyActionsCase)ib.getInstruction();
            List actionList = aac.getApplyActions().getAction();
            ActionBuilder ab = new ActionBuilder();
            ab.setAction(ActionUtils.nxLoadRegAction((DstChoice)new DstNxRegCaseBuilder().setNxReg(REG_FIELD).build(), (BigInteger)BigInteger.valueOf(1L)));
            ab.setOrder(Integer.valueOf(1));
            ab.setKey(new ActionKey(Integer.valueOf(1)));
            actionList.add(ab.build());
            ib.setOrder(Integer.valueOf(0));
            ib.setKey(new InstructionKey(Integer.valueOf(0)));
            instructions.add(ib.build());
            ib = InstructionUtils.createGotoTableInstructions((InstructionBuilder)new InstructionBuilder(), (short)goToTableId);
            ib.setOrder(Integer.valueOf(1));
            ib.setKey(new InstructionKey(Integer.valueOf(1)));
            instructions.add(ib.build());
            isb.setInstruction((List)instructions);
            flowBuilder.setInstructions(isb.build());
            this.writeFlow(flowBuilder, nodeBuilder);
        } else {
            this.removeFlow(flowBuilder, nodeBuilder);
        }
    }

    public MatchBuilder buildMatch(Matches matches) {
        MatchBuilder matchBuilder = new MatchBuilder();
        if (matches.getAceType() instanceof AceIp) {
            AceIp aceIp = (AceIp)matches.getAceType();
            if (aceIp.getAceIpVersion() instanceof AceIpv4) {
                MatchUtils.createIpProtocolMatch((MatchBuilder)matchBuilder, (short)aceIp.getProtocol());
                MatchUtils.addLayer4Match((MatchBuilder)matchBuilder, (int)aceIp.getProtocol().intValue(), (int)0, (int)aceIp.getDestinationPortRange().getLowerPort().getValue());
            }
        } else if (matches.getAceType() instanceof AceEth) {
            AceEth aceEth = (AceEth)matches.getAceType();
            MatchUtils.createEthSrcMatch((MatchBuilder)matchBuilder, (MacAddress)new MacAddress(aceEth.getSourceMacAddress().getValue()));
            MatchUtils.createDestEthMatch((MatchBuilder)matchBuilder, (MacAddress)new MacAddress(aceEth.getDestinationMacAddress().getValue()), (MacAddress)new MacAddress(aceEth.getDestinationMacAddressMask().getValue()));
        }
        LOG.info("buildMatch: {}", (Object)matchBuilder.build());
        return matchBuilder;
    }

    protected void writeFlow(FlowBuilder flowBuilder, NodeBuilder nodeBuilder) {
        LOG.debug("writeFlow: flowBuilder: {}, nodeBuilder: {}", (Object)flowBuilder.build(), (Object)nodeBuilder.build());
        this.mdsalUtils.merge(LogicalDatastoreType.CONFIGURATION, FlowUtils.createNodePath((NodeBuilder)nodeBuilder), (DataObject)nodeBuilder.build());
        this.mdsalUtils.put(LogicalDatastoreType.CONFIGURATION, FlowUtils.createFlowPath((FlowBuilder)flowBuilder, (NodeBuilder)nodeBuilder), (DataObject)flowBuilder.build());
    }

    protected void removeFlow(FlowBuilder flowBuilder, NodeBuilder nodeBuilder) {
        this.mdsalUtils.delete(LogicalDatastoreType.CONFIGURATION, FlowUtils.createFlowPath((FlowBuilder)flowBuilder, (NodeBuilder)nodeBuilder));
    }
}

