/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.auth.aaa;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.Credentials;
import org.opendaylight.aaa.api.PasswordCredentialAuth;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.auth.aaa.DefaultPasswordCredentials;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, property={"type=netconf-auth-provider"})
public final class CredentialServiceAuthProvider
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialServiceAuthProvider.class);
    private final PasswordCredentialAuth credService;

    @Inject
    @Activate
    public CredentialServiceAuthProvider(@Reference PasswordCredentialAuth credService) {
        this.credService = Objects.requireNonNull(credService);
    }

    public boolean authenticated(String username, String password) {
        Claim claim;
        DefaultPasswordCredentials credentials = new DefaultPasswordCredentials(username, password);
        try {
            claim = this.credService.authenticate((Credentials)credentials);
        }
        catch (AuthenticationException e) {
            LOG.debug("Authentication failed for user '{}'", (Object)username, (Object)e);
            return false;
        }
        LOG.debug("Authentication result for user '{}' : {}", (Object)username, (Object)claim.domain());
        return true;
    }
}

