/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.trace.impl.CloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;

final class CloseTrackedTrait<T extends CloseTracked<T>>
implements CloseTracked<T> {
    private final @Nullable Throwable allocationContext;
    private final CloseTrackedRegistry<T> closeTrackedRegistry;
    private final CloseTracked<T> realCloseTracked;

    CloseTrackedTrait(CloseTrackedRegistry<T> transactionChainRegistry, CloseTracked<T> realCloseTracked) {
        this.allocationContext = transactionChainRegistry.isDebugContextEnabled() ? new Throwable() : null;
        this.realCloseTracked = Objects.requireNonNull(realCloseTracked, "realCloseTracked");
        this.closeTrackedRegistry = Objects.requireNonNull(transactionChainRegistry, "transactionChainRegistry");
        this.closeTrackedRegistry.add(this);
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public @Nullable StackTraceElement[] getAllocationContextStackTrace() {
        Throwable local = this.allocationContext;
        return local != null ? local.getStackTrace() : null;
    }

    public void removeFromTrackedRegistry() {
        this.closeTrackedRegistry.remove(this);
    }

    @Override
    public CloseTracked<T> getRealCloseTracked() {
        return this.realCloseTracked;
    }
}

