/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

final class ThrowableAdapterFactory
implements TypeAdapterFactory {
    public static final ThrowableAdapterFactory INSTANCE = new ThrowableAdapterFactory();

    private ThrowableAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Throwable.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        TypeAdapter<Throwable> adapter = new TypeAdapter<Throwable>(){

            public Throwable read(JsonReader in) throws IOException {
                JsonToken token = in.peek();
                if (token == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String exceptionType = null;
                String message = null;
                Throwable cause = null;
                ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
                in.beginObject();
                while (in.hasNext()) {
                    String name;
                    switch (name = in.nextName()) {
                        case "type": {
                            exceptionType = in.nextString();
                            break;
                        }
                        case "message": {
                            message = in.nextString();
                            break;
                        }
                        case "cause": {
                            cause = this.read(in);
                            break;
                        }
                        case "suppressed": {
                            in.beginArray();
                            while (in.hasNext()) {
                                suppressed.add(this.read(in));
                            }
                            in.endArray();
                            break;
                        }
                    }
                }
                in.endObject();
                if (exceptionType != null && !exceptionType.isEmpty()) {
                    try {
                        Class<?> exceptionClass = Class.forName("java.lang." + exceptionType);
                        Constructor<?> constructor = exceptionClass.getConstructor(String.class, Throwable.class);
                        Throwable throwable = (Throwable)constructor.newInstance(message, cause);
                        suppressed.forEach(throwable::addSuppressed);
                        return throwable;
                    }
                    catch (ClassNotFoundException e) {
                        throw new JsonParseException("Failed to create Throwable instance: Class not found", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JsonParseException("Failed to create Throwable instance: Constructor not found", (Throwable)e);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new JsonParseException("Failed to create Throwable instance: Instantiation error", (Throwable)e);
                    }
                }
                return new Throwable(message, cause);
            }

            public void write(JsonWriter out, Throwable value) throws IOException {
                Throwable[] suppressedArray;
                if (value == null) {
                    out.nullValue();
                    return;
                }
                out.beginObject();
                out.name("type");
                out.value(value.getClass().getSimpleName());
                out.name("message");
                out.value(value.getMessage());
                Throwable cause = value.getCause();
                if (cause != null) {
                    out.name("cause");
                    this.write(out, cause);
                }
                if ((suppressedArray = value.getSuppressed()).length > 0) {
                    out.name("suppressed");
                    out.beginArray();
                    for (Throwable suppressed : suppressedArray) {
                        this.write(out, suppressed);
                    }
                    out.endArray();
                }
                out.endObject();
            }
        };
        return adapter;
    }
}

